/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.tx;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.util.PayloadKey;
import org.jboss.ejb3.interceptors.container.ContainerMethodInvocation;
import org.jboss.ejb3.tx.BMTInterceptor;
import org.jboss.ejb3.tx.container.StatefulBeanContext;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;

public class StatefulBMTInterceptor
extends BMTInterceptor {
    private static final Logger log = Logger.getLogger(StatefulBMTInterceptor.class);

    public StatefulBMTInterceptor(TransactionManager tm) {
        super(tm);
    }

    private void checkBadStateful(String ejbName) {
        int status = 6;
        try {
            status = this.tm.getStatus();
        }
        catch (SystemException ex) {
            log.error((Object)"Failed to get status", (Throwable)ex);
        }
        switch (status) {
            case 1: 
            case 7: 
            case 8: 
            case 9: {
                try {
                    this.tm.rollback();
                }
                catch (Exception ex) {
                    log.error((Object)"Failed to rollback", (Throwable)ex);
                }
                String msg = "BMT stateful bean '" + ejbName + "' did not complete user transaction properly status=" + TxUtils.getStatusAsString((int)status);
                log.error((Object)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleInvocation(Invocation invocation) throws Throwable {
        assert (this.tm.getTransaction() == null) : "can't handle BMT transaction, there is a transaction active";
        StatefulBeanContext ctx = (StatefulBeanContext)ContainerMethodInvocation.getContainerMethodInvocation((Invocation)invocation).getBeanContext();
        String ejbName = invocation.getAdvisor().getName();
        Transaction tx = (Transaction)ctx.getMetaData().getMetaData((Object)"TX", (Object)"TX");
        if (tx != null) {
            ctx.getMetaData().addMetaData((Object)"TX", (Object)"TX", null, PayloadKey.TRANSIENT);
            this.tm.resume(tx);
        }
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            this.checkBadStateful(ejbName);
            Transaction newTx = this.tm.getTransaction();
            if (newTx != null) {
                ctx.getMetaData().addMetaData((Object)"TX", (Object)"TX", (Object)newTx, PayloadKey.TRANSIENT);
                this.tm.suspend();
            } else {
                ctx.getMetaData().addMetaData((Object)"TX", (Object)"TX", null, PayloadKey.TRANSIENT);
            }
        }
    }
}

