/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.mock.ds;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.util.StringPropertyReplacer;
import org.jboss.util.xml.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataSourceDeployment
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(DataSourceDeployment.class);
    private boolean replace = true;
    private String type;
    private String jndiName;
    private String driverClass;
    private String typeMapping;
    private String jdbcURL;
    private String username;
    private String password;
    private String securityDomain;
    private String minPoolSize;
    private String maxPoolSize;
    private Properties connProps;
    private ArrayList<String> depends = new ArrayList();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDriverClass() {
        return this.driverClass;
    }

    public void setDriverClass(String driverClass) {
        this.driverClass = driverClass;
    }

    public String getJdbcURL() {
        return this.jdbcURL;
    }

    public void setJdbcURL(String jdbcURL) {
        this.jdbcURL = jdbcURL;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiName(String jndiName) {
        this.jndiName = jndiName;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public void setMaxPoolSize(String maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public String getMinPoolSize() {
        return this.minPoolSize;
    }

    public void setMinPoolSize(String minPoolSize) {
        this.minPoolSize = minPoolSize;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    public String getSecurityDomain() {
        return this.securityDomain;
    }

    public void setSecurityDomain(String securityDomain) {
        this.securityDomain = securityDomain;
    }

    public String getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(String typeMapping) {
        this.typeMapping = typeMapping;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Properties getConnectionProperties() {
        return this.connProps;
    }

    public void setConnectionProperties(Properties connProps) {
        this.connProps = connProps;
    }

    public List<String> getDepends() {
        return this.depends;
    }

    public void parse(Document document) {
        this.type = "local-tx-datasource";
        NodeList datasources = document.getElementsByTagName(this.type);
        for (int i = 0; i < datasources.getLength(); ++i) {
            Node node = datasources.item(i);
            if (node.getNodeType() != 1) continue;
            Element e = (Element)node;
            System.out.println("ELEMENT_NODE: " + e);
            NodeList tags = node.getChildNodes();
            for (int j = 0; j < tags.getLength(); ++j) {
                Node child = tags.item(j);
                if (child.getNodeType() != 1) continue;
                Element ej = (Element)child;
                if (ej.getTagName().equals("jndi-name")) {
                    this.jndiName = this.getText(ej);
                    continue;
                }
                if (ej.getTagName().equals("connection-url")) {
                    this.jdbcURL = this.getText(ej);
                    continue;
                }
                if (ej.getTagName().equals("user-name")) {
                    this.username = this.getText(ej);
                    continue;
                }
                if (ej.getTagName().equals("driver-class")) {
                    this.driverClass = this.getText(ej);
                    continue;
                }
                if (ej.getTagName().equals("password")) {
                    this.password = this.getText(ej);
                    if (this.password != null) continue;
                    this.password = "";
                    continue;
                }
                if (ej.getTagName().equals("min-pool-size")) {
                    this.minPoolSize = this.getText(ej);
                    continue;
                }
                if (ej.getTagName().equals("max-pool-size")) {
                    this.maxPoolSize = this.getText(ej);
                    continue;
                }
                if (ej.getTagName().equals("security-domain")) {
                    this.securityDomain = this.getText(ej);
                    continue;
                }
                if (ej.getTagName().equals("metadata")) {
                    NodeList tms = ej.getElementsByTagName("type-mapping");
                    Element tm = (Element)tms.item(0);
                    this.typeMapping = this.getText(tm);
                    continue;
                }
                if (ej.getTagName().equals("depends")) {
                    String depends = this.getText(ej);
                    this.addDepends(depends);
                    continue;
                }
                if (!ej.getTagName().equals("connection-properties")) continue;
            }
        }
    }

    public void parse(Map<String, ManagedProperty> properties) {
        for (ManagedProperty property : properties.values()) {
            String name = property.getName();
            Object value = property.getValue();
            if (value == null) continue;
            if (name.equals("")) {
                this.type = value.toString();
                continue;
            }
            if (name.equals("jndi-name")) {
                this.jndiName = value.toString();
                continue;
            }
            if (name.equals("connection-url")) {
                this.jdbcURL = value.toString();
                continue;
            }
            if (name.equals("user-name")) {
                this.username = value.toString();
                continue;
            }
            if (name.equals("driver-class")) {
                this.driverClass = value.toString();
                continue;
            }
            if (name.equals("password")) {
                this.password = value.toString();
                if (this.password != null) continue;
                this.password = "";
                continue;
            }
            if (name.equals("min-pool-size")) {
                this.minPoolSize = value.toString();
                continue;
            }
            if (name.equals("max-pool-size")) {
                this.maxPoolSize = value.toString();
                continue;
            }
            if (name.equals("security-domain")) {
                this.securityDomain = value.toString();
                continue;
            }
            if (name.equals("type-mapping")) {
                this.typeMapping = value.toString();
                continue;
            }
            if (name.equals("connection-properties")) {
                CompositeValue cvalue = (CompositeValue)value;
                this.parseConnProps(cvalue);
                continue;
            }
            if (!name.equals("depends")) continue;
            String depends = value.toString();
            this.addDepends(depends);
        }
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(super.toString());
        tmp.append('(');
        tmp.append("depends=");
        tmp.append(this.depends);
        tmp.append(",driverClass=");
        tmp.append(this.driverClass);
        tmp.append(",jdbcURL=");
        tmp.append(this.jdbcURL);
        tmp.append(",jndiName=");
        tmp.append(this.jndiName);
        tmp.append(",username=");
        tmp.append(this.username);
        tmp.append(",password=");
        tmp.append(this.password);
        tmp.append(",minPoolSize=");
        tmp.append(this.minPoolSize);
        tmp.append(",maxPoolSize=");
        tmp.append(this.maxPoolSize);
        tmp.append(",securityDomain=");
        tmp.append(this.securityDomain);
        tmp.append(",typeMapping=");
        tmp.append(this.typeMapping);
        tmp.append(",connProps=");
        tmp.append(this.connProps);
        tmp.append(')');
        return tmp.toString();
    }

    private void addDepends(String depends) {
        this.depends.add(depends);
    }

    private String getText(Node node) {
        String text = DOMUtils.getTextContent((Node)node);
        if (text != null && this.replace) {
            text = StringPropertyReplacer.replaceProperties((String)text);
        }
        return text;
    }

    private void parseConnProps(CompositeValue cvalue) {
        this.connProps = new Properties();
        for (String key : cvalue.getMetaType().keySet()) {
            if (!cvalue.containsKey(key)) continue;
            MetaValue value = cvalue.get(key);
            SimpleValue svalue = (SimpleValue)value;
            this.connProps.setProperty(key, svalue.getValue().toString());
        }
    }
}

