/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.upload;

import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.deployers.spi.management.deploy.DeploymentProgress;
import org.jboss.deployers.spi.management.deploy.DeploymentStatus;
import org.jboss.deployers.spi.management.deploy.DeploymentTarget;
import org.jboss.logging.Logger;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.profileservice.management.upload.DeploymentProgressImpl;
import org.jboss.profileservice.management.upload.SerializableDeploymentID;
import org.jboss.profileservice.management.upload.remoting.DeployHandler;
import org.jboss.profileservice.management.upload.remoting.StreamingDeploymentTarget;
import org.jboss.profileservice.spi.DeploymentRepository;
import org.jboss.profileservice.spi.DeploymentRepositoryFactory;
import org.jboss.profileservice.spi.NoSuchProfileException;
import org.jboss.profileservice.spi.Profile;
import org.jboss.profileservice.spi.ProfileKey;
import org.jboss.profileservice.spi.ProfileService;
import org.jboss.remoting.InvokerLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManagerImpl
implements DeploymentManager {
    private static Logger log = Logger.getLogger(DeploymentManagerImpl.class);
    private static final String BUNDLE_NAME = "org.jboss.profileservice.management.upload.messages";
    private ProfileService ps;
    private Profile activeProfile;
    private DeploymentRepositoryFactory repositoryFactory;
    private DeployHandler deployHandler;
    private ResourceBundle i18n;
    private Locale currentLocale;
    private MessageFormat formatter = new MessageFormat("");
    private InvokerLocator locator;
    private String remotingSubsystem = "DeploymentManager";

    public DeploymentManagerImpl() {
        this.currentLocale = Locale.getDefault();
        this.formatter.setLocale(this.currentLocale);
        this.i18n = ResourceBundle.getBundle(BUNDLE_NAME, this.currentLocale);
    }

    public ProfileService getProfileService() {
        return this.ps;
    }

    public void setProfileService(ProfileService ps) {
        this.ps = ps;
    }

    public DeploymentRepositoryFactory getRepositoryFactory() {
        return this.repositoryFactory;
    }

    public void setRepositoryFactory(DeploymentRepositoryFactory repositoryFactory) {
        this.repositoryFactory = repositoryFactory;
    }

    public DeployHandler getDeployHandler() {
        return this.deployHandler;
    }

    public void setDeployHandler(DeployHandler deployHandler) {
        this.deployHandler = deployHandler;
    }

    public InvokerLocator getLocator() {
        return this.locator;
    }

    public void setLocator(InvokerLocator locator) {
        this.locator = locator;
    }

    public String getRemotingSubsystem() {
        return this.remotingSubsystem;
    }

    public void setRemotingSubsystem(String remotingSubsystem) {
        this.remotingSubsystem = remotingSubsystem;
    }

    public DeploymentProgress distribute(String name, ManagedDeployment.DeploymentPhase phase, URL contentURL) {
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(name, phase, contentURL.toString());
        deployment.setContentURL(contentURL);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.DISTRIBUTE);
    }

    public String[] getRepositoryNames(String[] names, ManagedDeployment.DeploymentPhase phase) throws Exception {
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        String[] repositoryNames = targets.get(0).getRepositoryNames(names, phase);
        return repositoryNames;
    }

    public boolean isRedeploySupported() {
        return true;
    }

    public void loadProfile(ProfileKey key) throws Exception {
        this.activeProfile = this.ps.getProfile(key);
        if (this.activeProfile == null) {
            this.formatter.applyPattern(this.i18n.getString("DeploymentManager.NoSuchProfileException"));
            Object[] args = new Object[]{key};
            String msg = this.formatter.format(args);
            throw new NoSuchProfileException(msg);
        }
        DeploymentRepository repository = this.repositoryFactory.getDeploymentRepository(key);
        this.deployHandler.setDeploymentRepository(repository);
    }

    public DeploymentProgress redeploy(String name, ManagedDeployment.DeploymentPhase phase, URL contentURL) {
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(name, phase, null);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.REDEPLOY);
    }

    public DeploymentProgress prepare(ManagedDeployment.DeploymentPhase phase, String ... names) throws Exception {
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(names, phase, null);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.PREPARE);
    }

    public DeploymentProgress start(ManagedDeployment.DeploymentPhase phase, String ... names) throws Exception {
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(names, phase, null);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.START);
    }

    public DeploymentProgress stop(ManagedDeployment.DeploymentPhase phase, String ... names) throws Exception {
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(names, phase, null);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.STOP);
    }

    public DeploymentProgress undeploy(ManagedDeployment.DeploymentPhase phase, String ... names) throws Exception {
        List<DeploymentTarget> targets = this.getDeploymentTargets();
        SerializableDeploymentID deployment = new SerializableDeploymentID(names, phase, null);
        return new DeploymentProgressImpl(targets, deployment, DeploymentStatus.CommandType.UNDEPLOY);
    }

    protected List<DeploymentTarget> getDeploymentTargets() {
        String targetName = this.locator.getHost();
        ArrayList<DeploymentTarget> targets = new ArrayList<DeploymentTarget>();
        StreamingDeploymentTarget hostTarget = new StreamingDeploymentTarget(this.locator, targetName, this.remotingSubsystem);
        targets.add(hostTarget);
        return targets;
    }
}

