/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.microcontainer.beans;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AspectDefinition;
import org.jboss.aop.advice.AspectFactory;
import org.jboss.aop.advice.AspectFactoryDelegator;
import org.jboss.aop.advice.GenericAspectFactory;
import org.jboss.aop.advice.Scope;
import org.jboss.aop.advice.ScopeUtil;
import org.jboss.aop.instrument.Untransformable;
import org.jboss.aop.microcontainer.beans.Binding;
import org.jboss.aop.microcontainer.beans.DelegatingBeanAspectFactory;
import org.jboss.aop.microcontainer.beans.GenericBeanAspectFactory;
import org.jboss.aop.microcontainer.beans.ManagedAspectDefinition;
import org.jboss.beans.metadata.plugins.factory.GenericBeanFactory;
import org.jboss.beans.metadata.spi.factory.BeanFactory;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.kernel.spi.dependency.ConfigureKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.logging.Logger;
import org.w3c.dom.Element;

public class Aspect
implements ConfigureKernelControllerContextAware,
Untransformable {
    private static final Logger log = Logger.getLogger(Aspect.class);
    protected AspectManager manager;
    protected boolean factory;
    protected Scope scope;
    protected ManagedAspectDefinition definition;
    protected GenericBeanFactory advice;
    protected String adviceBean;
    protected ControllerContext context;
    protected String myname;
    protected String aspectDefName;
    protected Map<String, Binding> bindings = new LinkedHashMap<String, Binding>();
    private Element element;

    public String getAdviceName() {
        return this.myname;
    }

    public void setFactory(boolean factory) {
        this.factory = factory;
    }

    public void setAdviceName(String adviceName) {
        this.myname = adviceName;
    }

    public String getAdviceBean() {
        return this.adviceBean;
    }

    public void setAdviceBean(String adviceBean) {
        this.adviceBean = adviceBean;
    }

    public AspectDefinition getDefinition() {
        return this.definition;
    }

    public AspectManager getManager() {
        return this.manager;
    }

    public void setManager(AspectManager manager) {
        this.manager = manager;
    }

    public GenericBeanFactory getAdvice() {
        return this.advice;
    }

    public void setAdvice(GenericBeanFactory advice) {
        this.advice = advice;
    }

    public String getScope() {
        return this.scope.toString();
    }

    public void setScope(String scope) {
        this.scope = ScopeUtil.parse((String)scope);
    }

    public void setKernelControllerContext(KernelControllerContext context) throws Exception {
        this.myname = (String)context.getName();
        this.context = context;
    }

    public void unsetKernelControllerContext(KernelControllerContext context) throws Exception {
        this.context = null;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void install(GenericBeanFactory factory) throws Exception {
        this.advice = factory;
        this.start();
    }

    public void start() throws Exception {
        if (this.definition == null) {
            String string = this.aspectDefName = this.adviceBean != null ? this.adviceBean : this.myname;
            if (this.manager == null) {
                throw new IllegalArgumentException("Null manager");
            }
            this.definition = this.advice != null ? this.getAspectDefinitionNoDependencies() : (this.adviceBean != null && this.context.getController() != null ? this.getAspectDefintionDependencies() : this.getAspectDefinitionPlainAspectFactory());
            this.addDefinitionToManager();
        }
        if (this.adviceBean != null && this.advice != null) {
            this.definition.setDeployed(true);
            GenericBeanAspectFactory factory = (GenericBeanAspectFactory)this.definition.getFactory();
            factory.setBeanFactory(this.advice);
        }
        ArrayList<Binding> clonedBindings = new ArrayList<Binding>();
        for (Binding aspectBinding : this.bindings.values()) {
            clonedBindings.add(aspectBinding);
        }
        for (Binding binding : clonedBindings) {
            binding.rebind();
        }
        log.debug((Object)("Bound aspect " + this.aspectDefName + "; deployed:" + this.definition.isDeployed()));
    }

    protected ManagedAspectDefinition getAspectDefinitionNoDependencies() {
        Object factory = this.factory ? new DelegatingBeanAspectFactory(this.myname, (BeanFactory)this.advice, this.element) : new GenericBeanAspectFactory(this.myname, this.advice, this.element);
        return new ManagedAspectDefinition(this.aspectDefName, this.scope, (AspectFactory)factory);
    }

    protected ManagedAspectDefinition getAspectDefintionDependencies() {
        Object factory = this.factory ? new DelegatingBeanAspectFactory(this.aspectDefName, (BeanFactory)this.advice, this.element) : new GenericBeanAspectFactory(this.aspectDefName, this.advice, this.element);
        return new ManagedAspectDefinition(this.aspectDefName, this.scope, (AspectFactory)factory, false);
    }

    protected ManagedAspectDefinition getAspectDefinitionPlainAspectFactory() {
        AspectFactoryDelegator factory = this.factory ? new AspectFactoryDelegator(this.myname, null) : new GenericAspectFactory(this.myname, this.element);
        return new ManagedAspectDefinition(this.aspectDefName, this.scope, (AspectFactory)factory);
    }

    protected void addDefinitionToManager() {
        this.manager.addAspectDefinition((AspectDefinition)this.definition);
    }

    public void uninstall() throws Exception {
        this.stop();
    }

    public void stop() {
        this.aspectDefName = this.adviceBean != null ? this.adviceBean : this.myname;
        log.debug((Object)("Unbinding aspect " + this.aspectDefName));
        this.manager.removeAspectDefinition(this.aspectDefName);
        if (this.definition != null) {
            this.definition.undeploy();
            this.definition = null;
        }
    }

    void addBinding(Binding binding) {
        this.bindings.put(binding.getName(), binding);
    }

    void removeBinding(Binding binding) {
        this.bindings.remove(binding.getName());
    }
}

