/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployers;

import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.management.ObjectName;
import org.jboss.classloading.spi.metadata.ClassLoadingMetaData;
import org.jboss.classloading.spi.metadata.ExportAll;
import org.jboss.classloading.spi.version.Version;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.mx.loading.LoaderRepositoryFactory;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedConnectionFactoryClassLoaderDeployer
extends AbstractSimpleRealDeployer<ManagedConnectionFactoryDeploymentGroup> {
    public ManagedConnectionFactoryClassLoaderDeployer() {
        super(ManagedConnectionFactoryDeploymentGroup.class);
        this.setStage(DeploymentStages.POST_PARSE);
        this.setOutput(ClassLoadingMetaData.class);
    }

    public void deploy(DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup deployment) throws DeploymentException {
        String domain;
        ClassLoadingMetaData classLoadingMetaData = (ClassLoadingMetaData)unit.getAttachment(ClassLoadingMetaData.class);
        if (classLoadingMetaData != null) {
            this.log.warn((Object)("Not converting LoaderRepositoryConfig to ClassLoadingMetaData for " + unit.getName() + " since it already exists: " + classLoadingMetaData));
            return;
        }
        LoaderRepositoryFactory.LoaderRepositoryConfig loaderConfig = deployment.getLoaderRepositoryConfig();
        if (loaderConfig == null) {
            return;
        }
        ObjectName name = loaderConfig.repositoryName;
        if (name != null && (domain = name.getCanonicalName().trim()).length() != 0) {
            ClassLoadingMetaData metaData = new ClassLoadingMetaData();
            metaData.setName(unit.getName());
            metaData.setDomain(domain);
            metaData.setExportAll(ExportAll.NON_EMPTY);
            metaData.setImportAll(true);
            metaData.setVersion((Object)Version.DEFAULT_VERSION);
            Properties props = new Properties();
            String config = loaderConfig.repositoryConfig;
            try {
                if (config != null) {
                    ByteArrayInputStream bais = new ByteArrayInputStream(config.getBytes());
                    props.load(bais);
                }
            }
            catch (Exception e) {
                throw DeploymentException.rethrowAsDeploymentException((String)("Error parsing repository config " + config), (Throwable)e);
            }
            String java2ParentDelegation = props.getProperty("java2ParentDelegation");
            if (java2ParentDelegation == null) {
                java2ParentDelegation = props.getProperty("java2ParentDelegaton", "false");
            }
            boolean useParentFirst = Boolean.valueOf(java2ParentDelegation);
            metaData.setJ2seClassLoadingCompliance(useParentFirst);
            unit.addAttachment(ClassLoadingMetaData.class, (Object)metaData);
        }
    }
}

