/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.deployer.kernel;

import java.util.ArrayList;
import java.util.List;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BeanMetaDataFactoryVisitor<T>
implements DeploymentVisitor<T> {
    private Logger log = Logger.getLogger(this.getClass());

    protected static void addBeanComponent(DeploymentUnit unit, BeanMetaData bean) {
        DeploymentUnit component = unit.addComponent(bean.getName());
        component.addAttachment(BeanMetaData.class.getName(), (Object)bean);
    }

    protected static void removeBeanComponent(DeploymentUnit unit, BeanMetaData bean) {
        unit.removeComponent(bean.getName());
    }

    protected void safeRemoveBeanComponent(DeploymentUnit unit, BeanMetaData bean) {
        try {
            BeanMetaDataFactoryVisitor.removeBeanComponent(unit, bean);
        }
        catch (Throwable ignored) {
            this.log.warn((Object)("Error during component removal: " + unit.getName()), ignored);
        }
    }

    protected abstract List<BeanMetaData> getBeans(T var1);

    public void deploy(DeploymentUnit unit, T deployment) throws DeploymentException {
        List<BeanMetaData> beans = this.getBeans(deployment);
        if (beans != null && !beans.isEmpty()) {
            ArrayList<BeanMetaData> visited = new ArrayList<BeanMetaData>();
            try {
                for (BeanMetaData bean : beans) {
                    BeanMetaDataFactoryVisitor.addBeanComponent(unit, bean);
                    visited.add(bean);
                }
            }
            catch (Throwable t) {
                for (int i = visited.size() - 1; i >= 0; --i) {
                    this.safeRemoveBeanComponent(unit, (BeanMetaData)visited.get(i));
                }
                throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + unit.getName()), (Throwable)t);
            }
        }
    }

    public void undeploy(DeploymentUnit unit, T deployment) {
        List<BeanMetaData> beans = this.getBeans(deployment);
        if (beans != null && !beans.isEmpty()) {
            for (BeanMetaData bean : beans) {
                this.safeRemoveBeanComponent(unit, bean);
            }
        }
    }
}

