/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloading.spi;

import java.net.URL;
import org.jboss.classloading.spi.RealClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DelegatingClassLoader
extends ClassLoader {
    private RealClassLoader parent;
    protected boolean standard = false;

    private static ClassLoader checkParent(RealClassLoader parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Null parent");
        }
        if (!(parent instanceof ClassLoader)) {
            throw new IllegalArgumentException("Parent is not a classloader");
        }
        return (ClassLoader)ClassLoader.class.cast(parent);
    }

    public DelegatingClassLoader(RealClassLoader parent) {
        super(DelegatingClassLoader.checkParent(parent));
        this.parent = parent;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz == null) {
            clazz = this.parent.getCachedClass(name);
        }
        if (clazz == null) {
            clazz = this.standard ? super.loadClass(name, resolve) : this.getParent().loadClass(name);
        }
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.parent.getCachedResource(name);
        if (resource == null) {
            resource = this.standard ? super.getResource(name) : this.getParent().getResource(name);
        }
        return resource;
    }
}

