/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.interceptors;

import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.cache.pojo.PojoCacheException;

public class MethodReentrancyStopperInterceptor
implements Interceptor {
    private final Log log_ = LogFactory.getLog(MethodReentrancyStopperInterceptor.class);
    private ThreadLocal<Boolean> done = new ThreadLocal();
    private String methodName;

    public MethodReentrancyStopperInterceptor() {
        this.done.set(false);
    }

    public void setMethodName(String mname) {
        this.methodName = mname;
    }

    public String getName() {
        return MethodReentrancyStopperInterceptor.class.getName() + "-" + this.methodName;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        boolean wasDone = this.done.get();
        try {
            Object object;
            if (!wasDone) {
                this.done.set(true);
                Object object2 = invocation.invokeNext();
                return object2;
            }
            if (this.log_.isDebugEnabled()) {
                Method method = ((MethodInvocation)invocation).getMethod();
                this.log_.debug((Object)("Detect recursive interception. Will call the target directly: " + method.getName()));
            }
            if (this.methodName.equals("toString")) {
                object = invocation.getTargetObject().getClass().getName();
                return object;
            }
            if (this.methodName.equals("hashCode")) {
                object = 0;
                return object;
            }
            throw new PojoCacheException("MethodReentrancyStopperInterceptor.invoke(): unknown method name" + this.methodName);
        }
        finally {
            if (!wasDone) {
                this.done.set(false);
            }
        }
    }
}

