/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting;

import EDU.oswego.cs.dl.util.concurrent.LinkedQueue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jboss.logging.Logger;
import org.jboss.mx.remoting.JMXUtil;
import org.jboss.mx.remoting.NotificationEntry;
import org.jboss.mx.remoting.NotificationQueue;
import org.jboss.remoting.Client;
import org.jboss.remoting.ConnectionFailedException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.InvokerRegistry;
import org.jboss.remoting.ServerInvoker;
import org.jboss.remoting.invocation.NameBasedInvocation;
import org.jboss.remoting.network.NetworkNotification;
import org.jboss.remoting.network.NetworkRegistryFinder;
import org.jboss.remoting.transport.ClientInvoker;

public class MBeanNotificationCache
implements NotificationListener {
    private static final Logger log = Logger.getLogger((String)MBeanNotificationCache.class.getName());
    private final MBeanServer server;
    private final List listeners = new ArrayList();
    private final Map queue = new HashMap();
    private final ObjectName networkRegistry;
    private final ServerInvoker serverInvoker;
    private final String localServerId;
    static /* synthetic */ Class class$org$jboss$mx$remoting$NotificationQueue;

    public MBeanNotificationCache(ServerInvoker invoker, MBeanServer server) throws Exception {
        this.server = server;
        this.serverInvoker = invoker;
        this.localServerId = JMXUtil.getServerId(server);
        this.networkRegistry = NetworkRegistryFinder.find((MBeanServer)server);
        if (this.networkRegistry == null) {
            throw new Exception("Couldn't find the required NetworkRegistryMBean in this MBeanServer");
        }
        server.addNotificationListener(this.networkRegistry, this, null, (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotification(Notification notification, Object o) {
        String type;
        if (notification instanceof NetworkNotification && o != null && this.equals(o) && (type = notification.getType()).equals("jboss.network.server.removed")) {
            NetworkNotification nn = (NetworkNotification)notification;
            String sessionId = nn.getIdentity().getJMXId();
            ArrayList<Listener> failed = new ArrayList<Listener>();
            Object object = this.listeners;
            synchronized (object) {
                Iterator iter = this.listeners.iterator();
                while (iter.hasNext()) {
                    Listener listener = (Listener)iter.next();
                    if (!sessionId.equals(listener.sessionId)) continue;
                    failed.add(listener);
                }
            }
            if (!failed.isEmpty()) {
                Iterator iter = failed.iterator();
                while (iter.hasNext()) {
                    Listener listener = (Listener)iter.next();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("++ Removed orphaned listener because server failed: " + nn.getIdentity()));
                    }
                    try {
                        this.removeNotificationListener(listener.locator, listener.sessionId, listener.objectName, listener.handback);
                    }
                    catch (Exception ig) {
                        // empty catch block
                    }
                    listener = null;
                }
                failed = null;
            }
            object = this.queue;
            synchronized (object) {
                this.queue.remove(sessionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void destroy() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"destroy call on notification cache");
        }
        Object object = this.listeners;
        synchronized (object) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                Listener l = (Listener)iter.next();
                try {
                    this.removeNotificationListener(l.locator, l.sessionId, l.objectName, l.handback);
                }
                catch (Exception e) {}
            }
        }
        object = this.queue;
        synchronized (object) {
            this.queue.clear();
        }
        try {
            this.server.removeNotificationListener(this.networkRegistry, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotificationListener(InvokerLocator clientLocator, String sessionId, ObjectName objectName, NotificationFilter filter, Object handback) throws InstanceNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("remote notification listener added for client [" + clientLocator + "] on objectName [" + objectName + "] and mbeanServerId [" + sessionId + "], filter: " + filter + ", handback: " + handback));
        }
        Listener l = new Listener(clientLocator, sessionId, objectName, filter, handback);
        List list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(l)) {
                this.listeners.add(l);
                this.server.addNotificationListener(objectName, l, filter, handback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotificationListener(InvokerLocator clientLocator, String sessionId, ObjectName objectName, Object handback) throws InstanceNotFoundException, ListenerNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("removeNotificationListener called with clientLocator: " + clientLocator + ", sessionId: " + sessionId + ", objectName: " + objectName));
        }
        List list = this.listeners;
        synchronized (list) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                Listener l = (Listener)iter.next();
                if (!l.locator.equals((Object)clientLocator) || !l.objectName.equals(objectName) || !l.sessionId.equals(sessionId)) continue;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("remote notification listener removed for client [" + clientLocator + "] on objectName [" + objectName + "] and MBeanServerId [" + sessionId + "]"));
                }
                iter.remove();
                this.server.removeNotificationListener(objectName, l, l.filter, handback);
                l.destroy();
                l = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NotificationQueue getNotifications(String sessionId) {
        Map map = this.queue;
        synchronized (map) {
            return (NotificationQueue)this.queue.remove(sessionId);
        }
    }

    private final class Listener
    implements NotificationListener {
        final ObjectName objectName;
        final Object handback;
        final NotificationFilter filter;
        final InvokerLocator locator;
        final String sessionId;
        private ClientInvoker clientInvoker;
        private Client client;
        private boolean asyncSend = false;
        private LinkedQueue asyncQueue;
        private int counter = 0;
        private BiDirectionClientNotificationSender biDirectionalSender;

        Listener(InvokerLocator locator, String sessionId, ObjectName objectName, NotificationFilter filter, Object handback) {
            this.objectName = objectName;
            this.filter = filter;
            this.locator = locator;
            this.sessionId = sessionId;
            this.handback = handback;
            if (MBeanNotificationCache.this.serverInvoker.isTransportBiDirectional()) {
                this.connectAsync();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void destroy() {
            if (log.isTraceEnabled()) {
                log.trace((Object)("destroy called on client [" + this.locator + "], session id [" + this.sessionId + "]"));
            }
            try {
                MBeanNotificationCache.this.removeNotificationListener(this.locator, this.sessionId, this.objectName, this.handback);
            }
            catch (Throwable e) {
                // empty catch block
            }
            if (this.biDirectionalSender != null) {
                this.biDirectionalSender.running = false;
                this.biDirectionalSender.interrupt();
                this.biDirectionalSender = null;
                while (this.asyncQueue != null && !this.asyncQueue.isEmpty()) {
                    try {
                        this.asyncQueue.take();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                        break;
                    }
                }
                this.asyncQueue = null;
            }
            if (this.client != null) {
                try {
                    this.client.disconnect();
                }
                finally {
                    this.client = null;
                }
            }
        }

        private void connectAsync() {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("attempting an bi-directional connection back to client [" + this.locator + "], server id [" + this.sessionId + "]"));
                }
                this.clientInvoker = InvokerRegistry.createClientInvoker((InvokerLocator)this.locator);
                this.clientInvoker.connect();
                this.client = new Client(Thread.currentThread().getContextClassLoader(), this.clientInvoker, "jmx");
                this.asyncQueue = new LinkedQueue();
                this.biDirectionalSender = new BiDirectionClientNotificationSender();
                this.biDirectionalSender.start();
                this.asyncSend = true;
            }
            catch (Throwable e) {
                log.debug((Object)("attempted a bi-directional connection back to client [" + this.locator + "], but it failed"), e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNotification(Notification notification, Object o) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("(" + (this.asyncSend ? "async" : "polling") + ") notification received ..." + notification + " for client [" + this.locator + "]"));
            }
            if (!this.asyncSend) {
                NotificationQueue q = null;
                Map map = MBeanNotificationCache.this.queue;
                synchronized (map) {
                    q = (NotificationQueue)MBeanNotificationCache.this.queue.get(this.sessionId);
                    if (q == null) {
                        q = new NotificationQueue(this.sessionId);
                        MBeanNotificationCache.this.queue.put(this.sessionId, q);
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("added notification to polling queue: " + notification + " for sessionId: " + this.sessionId));
                    }
                    q.add(new NotificationEntry(notification, this.handback));
                }
            }
            if (this.asyncQueue != null) {
                try {
                    this.asyncQueue.put((Object)new NotificationEntry(notification, this.handback));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        private final class BiDirectionClientNotificationSender
        extends Thread {
            private boolean running = true;

            private BiDirectionClientNotificationSender() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                NotificationQueue nq = new NotificationQueue(Listener.this.sessionId);
                int count = 0;
                long lastTx = 0L;
                while (this.running) {
                    try {
                        NotificationEntry ne;
                        while (count < 10 && !Listener.this.asyncQueue.isEmpty()) {
                            ne = (NotificationEntry)Listener.this.asyncQueue.take();
                            nq.add(ne);
                            ++count;
                            Listener.this.counter++;
                        }
                        if ((count > 10 || Listener.this.asyncQueue.isEmpty() || System.currentTimeMillis() - lastTx >= 2000L) && !nq.isEmpty()) {
                            try {
                                if (log.isTraceEnabled()) {
                                    log.trace((Object)("sending notification queue [" + nq + "] to client [" + Listener.this.locator + "] with sessionId [" + Listener.this.sessionId + "], counter=" + Listener.this.counter + " ,count=" + count));
                                }
                                lastTx = System.currentTimeMillis();
                                Listener.this.client.setSessionId(MBeanNotificationCache.this.localServerId);
                                Listener.this.client.invoke((Object)new NameBasedInvocation("$NOTIFICATIONS$", new Object[]{nq}, new String[]{(class$org$jboss$mx$remoting$NotificationQueue == null ? MBeanNotificationCache.class$("org.jboss.mx.remoting.NotificationQueue") : class$org$jboss$mx$remoting$NotificationQueue).getName()}), null);
                                continue;
                            }
                            catch (Throwable t) {
                                if (t instanceof ConnectionFailedException) {
                                    if (log.isTraceEnabled()) {
                                        log.trace((Object)"Client is dead during invocation");
                                    }
                                    Listener.this.destroy();
                                    break;
                                }
                                log.warn((Object)("Error sending async notifications to client: " + Listener.this.locator), t);
                                continue;
                            }
                            finally {
                                nq.clear();
                                count = 0;
                                continue;
                            }
                        }
                        if (!Listener.this.asyncQueue.isEmpty()) continue;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)"blocking on more notifications to arrive");
                        }
                        ne = (NotificationEntry)Listener.this.asyncQueue.take();
                        nq.add(ne);
                        ++count;
                        Listener.this.counter++;
                    }
                    catch (InterruptedException ex) {
                        break;
                    }
                }
            }
        }
    }
}

