/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;

public class OutgoingBufferPool {
    private BlockingQueue<ExposedDataOutputStream> buffers;

    public OutgoingBufferPool(int capacity) {
        this.buffers = new ArrayBlockingQueue<ExposedDataOutputStream>(capacity);
        for (int i = 0; i < capacity; ++i) {
            ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(1024);
            ExposedDataOutputStream dos = new ExposedDataOutputStream(out_stream);
            try {
                this.buffers.put(dos);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
    }

    public ExposedDataOutputStream take() throws InterruptedException {
        return this.buffers.take();
    }

    public void put(ExposedDataOutputStream buf) throws InterruptedException {
        ((ExposedByteArrayOutputStream)buf.getOutputStream()).reset();
        buf.reset();
        this.buffers.put(buf);
    }

    public String dumpStats() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.buffers.size()).append(" elements, capacities:\n");
        for (ExposedDataOutputStream buf : this.buffers) {
            ExposedByteArrayOutputStream stream = (ExposedByteArrayOutputStream)buf.getOutputStream();
            sb.append("size=").append(stream.size()).append(", capacity=").append(stream.getCapacity()).append(")\n");
        }
        return sb.toString();
    }
}

