/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.ExtendedReceiverAdapter;
import org.jgroups.JChannelFactory;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.mux.MuxChannel;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class MultiplexerConnectStateTransferMixTest
extends ChannelTestBase {
    private Cache c1;
    private Cache c2;
    private Cache c3;
    private Cache c1_repl;
    private Cache c2_repl;
    private Cache c3_repl;
    private Channel ch1;
    private Channel ch2;
    private Channel ch3;
    private Channel ch1_repl;
    private Channel ch2_repl;
    private Channel ch3_repl;
    JChannelFactory factory;
    JChannelFactory factory2;

    public MultiplexerConnectStateTransferMixTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.factory = new JChannelFactory();
        this.factory.setMultiplexerConfig(MUX_CHANNEL_CONFIG);
        this.factory2 = new JChannelFactory();
        this.factory2.setMultiplexerConfig(MUX_CHANNEL_CONFIG);
    }

    public void tearDown() throws Exception {
        if (this.ch1_repl != null) {
            this.ch1_repl.close();
        }
        if (this.ch2_repl != null) {
            this.ch2_repl.close();
        }
        if (this.ch3_repl != null) {
            this.ch3_repl.close();
        }
        if (this.ch1 != null) {
            this.ch1.close();
        }
        if (this.ch2 != null) {
            this.ch2.close();
        }
        if (this.ch3 != null) {
            this.ch3.close();
        }
        if (this.ch1 != null) {
            MultiplexerConnectStateTransferMixTest.assertFalse((boolean)((MuxChannel)this.ch1).getChannel().isOpen());
            MultiplexerConnectStateTransferMixTest.assertFalse((boolean)((MuxChannel)this.ch1).getChannel().isConnected());
        }
        if (this.ch2 != null) {
            MultiplexerConnectStateTransferMixTest.assertFalse((boolean)((MuxChannel)this.ch2).getChannel().isOpen());
            MultiplexerConnectStateTransferMixTest.assertFalse((boolean)((MuxChannel)this.ch2).getChannel().isConnected());
        }
        if (this.ch1_repl != null) {
            MultiplexerConnectStateTransferMixTest.assertFalse((boolean)((MuxChannel)this.ch1_repl).getChannel().isOpen());
            MultiplexerConnectStateTransferMixTest.assertFalse((boolean)((MuxChannel)this.ch1_repl).getChannel().isConnected());
        }
        if (this.ch2_repl != null) {
            MultiplexerConnectStateTransferMixTest.assertFalse((boolean)((MuxChannel)this.ch2_repl).getChannel().isOpen());
            MultiplexerConnectStateTransferMixTest.assertFalse((boolean)((MuxChannel)this.ch2_repl).getChannel().isConnected());
        }
        if (this.c1 != null) {
            this.c1.clear();
        }
        if (this.c2 != null) {
            this.c2.clear();
        }
        if (this.c3 != null) {
            this.c3.clear();
        }
        if (this.c1_repl != null) {
            this.c1_repl.clear();
        }
        if (this.c2_repl != null) {
            this.c2_repl.clear();
        }
        if (this.c3_repl != null) {
            this.c3_repl.clear();
        }
        this.ch3 = null;
        this.ch2 = null;
        this.ch1 = null;
        this.ch2_repl = null;
        this.ch1_repl = null;
        this.c3_repl = null;
        this.c2_repl = null;
        this.c1_repl = null;
        this.c2 = null;
        this.c1 = null;
        super.tearDown();
    }

    public void testConnectStateTransferMixing() throws Exception {
        this.stateTransferWithIntermixedTransferTypes(new boolean[]{true, false, true});
    }

    public void testConnectStateTransferMixing2() throws Exception {
        this.stateTransferWithIntermixedTransferTypes(new boolean[]{true, true, false});
    }

    public void testConnectStateTransferMixing3() throws Exception {
        this.stateTransferWithIntermixedTransferTypes(new boolean[]{false, true, false});
    }

    public void testConnectStateTransferMixing4() throws Exception {
        this.stateTransferWithIntermixedTransferTypes(new boolean[]{false, false, true});
    }

    private void stateTransferWithIntermixedTransferTypes(boolean[] connectTypes) throws Exception {
        boolean rc;
        this.ch1 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "c1");
        this.c1 = new Cache(this.ch1, "cache-1");
        if (connectTypes[0]) {
            System.out.println("Connect and state transfer");
            this.ch1.connect("bla", null, null, 5000L);
        } else {
            System.out.println("Regular connect");
            this.ch1.connect("bla");
            rc = this.ch1.getState(null, 5000L);
            System.out.println("state transfer: " + rc);
        }
        MultiplexerConnectStateTransferMixTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c1.size());
        this.ch2 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "c2");
        this.c2 = new Cache(this.ch2, "cache-2");
        if (connectTypes[1]) {
            System.out.println("Connect and state transfer");
            this.ch2.connect("bla", null, null, 5000L);
        } else {
            System.out.println("Regular connect");
            this.ch2.connect("bla");
            rc = this.ch2.getState(null, 5000L);
            System.out.println("state transfer: " + rc);
        }
        MultiplexerConnectStateTransferMixTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c2.size());
        this.ch3 = this.factory.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "c3");
        this.c3 = new Cache(this.ch3, "cache-3");
        if (connectTypes[2]) {
            System.out.println("Connect and state transfer");
            this.ch3.connect("bla", null, null, 5000L);
        } else {
            System.out.println("Regular connect");
            this.ch3.connect("bla");
            rc = this.ch3.getState(null, 5000L);
            System.out.println("state transfer: " + rc);
        }
        MultiplexerConnectStateTransferMixTest.assertEquals((String)"cache has to be empty initially", (int)0, (int)this.c2.size());
        this.ch1_repl = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "c1");
        this.ch2_repl = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "c2");
        this.ch3_repl = this.factory2.createMultiplexerChannel(MUX_CHANNEL_CONFIG_STACK_NAME, "c3");
        this.c1.put("name", "cache-1");
        this.c2.put("name", "cache-2");
        this.c3.put("name", "cache-3");
        this.c1_repl = new Cache(this.ch1_repl, "cache-1-repl");
        if (connectTypes[0]) {
            System.out.println("Connect and state transfer");
            this.ch1_repl.connect("bla", null, null, 5000L);
        } else {
            System.out.println("Regular connect");
            this.ch1_repl.connect("bla");
            rc = this.ch1_repl.getState(null, 5000L);
            System.out.println("state transfer: " + rc);
        }
        this.c2_repl = new Cache(this.ch2_repl, "cache-2-repl");
        if (connectTypes[1]) {
            System.out.println("Connect and state transfer");
            this.ch2_repl.connect("bla", null, null, 5000L);
        } else {
            System.out.println("Regular connect");
            this.ch2_repl.connect("bla");
            rc = this.ch2_repl.getState(null, 5000L);
            System.out.println("state transfer: " + rc);
        }
        this.c3_repl = new Cache(this.ch3_repl, "cache-3-repl");
        if (connectTypes[2]) {
            System.out.println("Connect and state transfer");
            this.ch3_repl.connect("bla", null, null, 5000L);
        } else {
            System.out.println("Regular connect");
            this.ch3_repl.connect("bla");
            rc = this.ch3_repl.getState(null, 5000L);
            System.out.println("state transfer: " + rc);
        }
        System.out.println("Caches after state transfers:");
        System.out.println("c1: " + this.c1);
        System.out.println("c1_repl: " + this.c1_repl);
        System.out.println("c2: " + this.c2);
        System.out.println("c2_repl: " + this.c2_repl);
        System.out.println("c3: " + this.c3);
        System.out.println("c3_repl: " + this.c3_repl);
        MultiplexerConnectStateTransferMixTest.assertEquals((int)1, (int)this.c1.size());
        MultiplexerConnectStateTransferMixTest.assertEquals((int)1, (int)this.c1_repl.size());
        MultiplexerConnectStateTransferMixTest.assertEquals((int)1, (int)this.c2.size());
        MultiplexerConnectStateTransferMixTest.assertEquals((int)1, (int)this.c2_repl.size());
        MultiplexerConnectStateTransferMixTest.assertEquals((int)1, (int)this.c3.size());
        MultiplexerConnectStateTransferMixTest.assertEquals((int)1, (int)this.c3_repl.size());
        MultiplexerConnectStateTransferMixTest.assertEquals((Object)"cache-1", (Object)this.c1.get("name"));
        MultiplexerConnectStateTransferMixTest.assertEquals((Object)"cache-1", (Object)this.c1_repl.get("name"));
        MultiplexerConnectStateTransferMixTest.assertEquals((Object)"cache-2", (Object)this.c2.get("name"));
        MultiplexerConnectStateTransferMixTest.assertEquals((Object)"cache-2", (Object)this.c2_repl.get("name"));
        MultiplexerConnectStateTransferMixTest.assertEquals((Object)"cache-3", (Object)this.c3.get("name"));
        MultiplexerConnectStateTransferMixTest.assertEquals((Object)"cache-3", (Object)this.c3_repl.get("name"));
    }

    public static Test suite() {
        return new TestSuite(MultiplexerConnectStateTransferMixTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)MultiplexerConnectStateTransferMixTest.suite());
    }

    private static class Cache
    extends ExtendedReceiverAdapter {
        protected final Map data = new TreeMap();
        Channel ch;
        String name;

        public Cache(Channel ch, String name) {
            this.ch = ch;
            this.name = name;
            this.ch.setReceiver(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object get(Object key) {
            Map map = this.data;
            synchronized (map) {
                return this.data.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void put(Object key, Object val) throws Exception {
            Object[] buf = new Object[]{key, val};
            Map map = this.data;
            synchronized (map) {
                this.data.put(key, val);
            }
            Message msg = new Message(null, null, (Serializable)buf);
            this.ch.send(msg);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected int size() {
            Map map = this.data;
            synchronized (map) {
                return this.data.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receive(Message msg) {
            if (this.ch.getLocalAddress().equals(msg.getSrc())) {
                return;
            }
            Object[] modification = (Object[])msg.getObject();
            Object key = modification[0];
            Object val = modification[1];
            Map map = this.data;
            synchronized (map) {
                this.data.put(key, val);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState() {
            byte[] state = null;
            Map map = this.data;
            synchronized (map) {
                try {
                    state = Util.objectToByteBuffer(this.data);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return state;
        }

        public byte[] getState(String state_id) {
            return this.getState();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(byte[] state) {
            try {
                Map m = (Map)Util.objectFromByteBuffer(state);
                Map map = this.data;
                synchronized (map) {
                    this.data.clear();
                    this.data.putAll(m);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setState(String state_id, byte[] state) {
            this.setState(state);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(OutputStream ostream) {
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                Map map = this.data;
                synchronized (map) {
                    oos.writeObject(this.data);
                }
                oos.flush();
            }
            catch (IOException e) {
            }
            finally {
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }

        public void getState(String state_id, OutputStream ostream) {
            this.getState(ostream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setState(InputStream istream) {
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(istream);
                Map m = (Map)ois.readObject();
                Map map = this.data;
                synchronized (map) {
                    this.data.clear();
                    this.data.putAll(m);
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (ois != null) {
                        ois.close();
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            }
        }

        public void setState(String state_id, InputStream istream) {
            this.setState(istream);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clear() {
            Map map = this.data;
            synchronized (map) {
                this.data.clear();
            }
        }

        public void viewAccepted(View new_view) {
            this.log("view is " + new_view);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Map map = this.data;
            synchronized (map) {
                return this.data.toString();
            }
        }

        public String printKeys() {
            return this.data.keySet().toString();
        }

        private void log(String msg) {
            System.out.println("-- [" + this.name + "] " + msg);
        }
    }
}

