/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Properties;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.jgroups.JChannel;
import org.jgroups.View;
import org.jgroups.protocols.DISCARD;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.MPING;
import org.jgroups.protocols.TP;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class MergeTest
extends ChannelTestBase {
    public boolean useBlocking() {
        return false;
    }

    public void testMerging2Members() {
        String[] names = null;
        names = MergeTest.isMuxChannelUsed() ? this.createMuxApplicationNames(1, 2) : this.createApplicationNames(2);
        this.mergeHelper(names);
    }

    public void testMerging4Members() {
        String[] names = null;
        names = MergeTest.isMuxChannelUsed() ? this.createMuxApplicationNames(1, 4) : this.createApplicationNames(4);
        this.mergeHelper(names);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void mergeHelper(String[] names) {
        int count = names.length;
        ChannelTestBase.ChannelRetrievable[] channels = new MergeApplication[count];
        try {
            View view;
            int j;
            DISCARD discard;
            int i;
            Semaphore semaphore = new Semaphore(count);
            semaphore.acquire(count);
            for (int i2 = 0; i2 < count; ++i2) {
                channels[i2] = new MergeApplication(names[i2], semaphore, false);
                ((ChannelTestBase.ChannelApplication)channels[i2]).start();
                semaphore.release(1);
                MergeTest.sleepRandom(1000, 1500);
            }
            MergeTest.blockUntilViewsReceived(channels, 60000L);
            Util.sleep(2000L);
            int split = count / 2;
            for (i = 0; i < split; ++i) {
                discard = (DISCARD)((JChannel)((ChannelTestBase.ChannelApplication)channels[i]).getChannel()).getProtocolStack().findProtocol("DISCARD");
                for (j = split; j < count; ++j) {
                    discard.addIgnoreMember(((ChannelTestBase.ChannelApplication)channels[j]).getLocalAddress());
                }
            }
            for (i = count - 1; i >= split; --i) {
                discard = (DISCARD)((JChannel)((ChannelTestBase.ChannelApplication)channels[i]).getChannel()).getProtocolStack().findProtocol("DISCARD");
                for (j = 0; j < split; ++j) {
                    discard.addIgnoreMember(((ChannelTestBase.ChannelApplication)channels[j]).getLocalAddress());
                }
            }
            System.out.println("Waiting for split to be detected...");
            long stop = System.currentTimeMillis() + 35000L;
            while ((view = ((MergeApplication)channels[0]).channel.getView()).size() != 1) {
                Util.sleep(1000L);
                if (System.currentTimeMillis() < stop) continue;
            }
            System.out.println("Waiting for merging to kick in....");
            for (int i3 = 0; i3 < count; ++i3) {
                ((JChannel)((ChannelTestBase.ChannelApplication)channels[i3]).getChannel()).getProtocolStack().removeProtocol("DISCARD");
            }
            MergeTest.blockUntilViewsReceived(channels, 60000L);
            boolean acquired = semaphore.tryAcquire(count, 20L, TimeUnit.SECONDS);
            if (!acquired) {
                this.log.warn((Object)"Most likely a bug, analyse the stack below:");
                this.log.warn((Object)Util.dumpThreads());
            }
            Util.sleep(1000L);
        }
        catch (Exception ex) {
            this.log.warn((Object)"Exception encountered during test", (Throwable)ex);
            MergeTest.fail((String)ex.getLocalizedMessage());
        }
        finally {
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                ((ChannelTestBase.ChannelApplication)channel).cleanup();
                Util.sleep(2000L);
            }
            if (!this.useBlocking()) return;
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                this.checkEventStateTransferSequence((ChannelTestBase.EventSequence)((Object)channel));
            }
            return;
        }
        for (ChannelTestBase.ChannelRetrievable channel : channels) {
            ((ChannelTestBase.ChannelApplication)channel).cleanup();
            Util.sleep(2000L);
        }
        if (!this.useBlocking()) return;
        for (ChannelTestBase.ChannelRetrievable channel : channels) {
            this.checkEventStateTransferSequence((ChannelTestBase.EventSequence)((Object)channel));
        }
        return;
    }

    private static void addDiscardProtocol(JChannel ch) throws Exception {
        ProtocolStack stack = ch.getProtocolStack();
        TP transport = stack.getTransport();
        DISCARD discard = new DISCARD();
        discard.setProtocolStack(ch.getProtocolStack());
        discard.start();
        stack.insertProtocol(discard, 1, transport.getName());
    }

    private static void replaceDiscoveryProtocol(JChannel ch) throws Exception {
        ProtocolStack stack = ch.getProtocolStack();
        Protocol discovery = stack.removeProtocol("TCPPING");
        if (discovery != null) {
            TP transport = stack.getTransport();
            MPING mping = new MPING();
            mping.setProperties(new Properties());
            mping.setProtocolStack(ch.getProtocolStack());
            stack.insertProtocol(mping, 1, transport.getName());
            mping.init();
            mping.start();
            System.out.println("Replaced TCPPING with MPING. See http://wiki.jboss.org/wiki/Wiki.jsp?page=JGroupsMERGE2");
        }
    }

    private static void modiftFDAndMergeSettings(JChannel ch) {
        MERGE2 merge;
        ProtocolStack stack = ch.getProtocolStack();
        FD fd = (FD)stack.findProtocol("FD");
        if (fd != null) {
            fd.setMaxTries(3);
            fd.setTimeout(1000L);
        }
        if ((merge = (MERGE2)stack.findProtocol("MERGE2")) != null) {
            merge.setMinInterval(5000L);
            merge.setMaxInterval(10000L);
        }
    }

    protected class MergeApplication
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        public MergeApplication(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
            MergeTest.replaceDiscoveryProtocol((JChannel)this.channel);
            MergeTest.addDiscardProtocol((JChannel)this.channel);
            MergeTest.modiftFDAndMergeSettings((JChannel)this.channel);
        }

        public void useChannel() throws Exception {
            this.channel.connect("test");
        }

        public void viewAccepted(View new_view) {
            this.events.add(new_view);
            System.out.println("Channel " + this.getLocalAddress() + "[" + this.getName() + "] accepted view " + new_view);
        }
    }
}

