/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.tests.ChannelTestBase;
import org.jgroups.util.Util;

public class ConcurrentStartupTest
extends ChannelTestBase {
    private AtomicInteger mod = new AtomicInteger(1);

    public void setUp() throws Exception {
        super.setUp();
        this.mod.set(1);
        CHANNEL_CONFIG = System.getProperty("channel.conf.flush", "flush-udp.xml");
    }

    public boolean useBlocking() {
        return true;
    }

    public void testConcurrentStartupLargeState() {
        this.concurrentStartupHelper(true, false);
    }

    public void testConcurrentStartupSmallState() {
        this.concurrentStartupHelper(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void concurrentStartupHelper(boolean largeState, boolean useDispatcher) {
        String[] names = null;
        names = ConcurrentStartupTest.isMuxChannelUsed() ? this.createMuxApplicationNames(1) : new String[]{"A", "B", "C", "D"};
        int count = names.length;
        ChannelTestBase.ChannelRetrievable[] channels = new ConcurrentStartupChannel[count];
        try {
            Semaphore semaphore = new Semaphore(count);
            semaphore.acquire(count);
            for (int i = 0; i < count; ++i) {
                channels[i] = largeState ? new ConcurrentStartupChannelWithLargeState(semaphore, names[i], useDispatcher) : new ConcurrentStartupChannel(names[i], semaphore, useDispatcher);
                ((ChannelTestBase.ChannelApplication)channels[i]).start();
                semaphore.release(1);
                ConcurrentStartupTest.sleepRandom(1000, 1500);
            }
            if (ConcurrentStartupTest.isMuxChannelUsed()) {
                ConcurrentStartupTest.blockUntilViewsReceived(channels, this.getMuxFactoryCount(), 60000L);
            } else {
                ConcurrentStartupTest.blockUntilViewsReceived(channels, 60000L);
            }
            Util.sleep(2000L);
            boolean acquired = semaphore.tryAcquire(count, 20L, TimeUnit.SECONDS);
            if (!acquired) {
                this.log.warn((Object)"Most likely a bug, analyse the stack below:");
                this.log.warn((Object)Util.dumpThreads());
            }
            Util.sleep(3000L);
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                this.log.info((Object)(((ChannelTestBase.ChannelApplication)channel).getName() + "=" + ((ConcurrentStartupChannel)channel).getList()));
            }
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                this.log.info((Object)(((ChannelTestBase.ChannelApplication)channel).getName() + "=" + ((ConcurrentStartupChannel)channel).getModifications()));
            }
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                ConcurrentStartupTest.assertEquals((String)(((ChannelTestBase.ChannelApplication)channel).getName() + " should have " + count + " elements"), (int)count, (int)((ConcurrentStartupChannel)channel).getList().size());
            }
        }
        catch (Exception ex) {
            this.log.warn((Object)"Exception encountered during test", (Throwable)ex);
            ConcurrentStartupTest.fail((String)ex.getLocalizedMessage());
        }
        finally {
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                ((ChannelTestBase.ChannelApplication)channel).cleanup();
                Util.sleep(2000L);
            }
            for (ChannelTestBase.ChannelRetrievable channel : channels) {
                this.checkEventStateTransferSequence((ChannelTestBase.EventSequence)((Object)channel));
            }
        }
        for (ChannelTestBase.ChannelRetrievable channel : channels) {
            ((ChannelTestBase.ChannelApplication)channel).cleanup();
            Util.sleep(2000L);
        }
        for (ChannelTestBase.ChannelRetrievable channel : channels) {
            this.checkEventStateTransferSequence((ChannelTestBase.EventSequence)((Object)channel));
        }
    }

    protected int getMod() {
        return this.mod.incrementAndGet();
    }

    public static Test suite() {
        return new TestSuite(ConcurrentStartupTest.class);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{ConcurrentStartupTest.class.getName()};
        TestRunner.main((String[])testCaseName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ConcurrentStartupChannel
    extends ChannelTestBase.PushChannelApplicationWithSemaphore {
        private final List<Address> l;
        private final Map<Integer, Object> mods;

        public ConcurrentStartupChannel(String name, Semaphore semaphore, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
            this.l = new LinkedList<Address>();
            this.mods = new TreeMap<Integer, Object>();
        }

        @Override
        public void useChannel() throws Exception {
            this.channel.connect("test", null, null, 25000L);
            this.channel.send(null, null, this.channel.getLocalAddress());
        }

        List<Address> getList() {
            return this.l;
        }

        Map<Integer, Object> getModifications() {
            return this.mods;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void receive(Message msg) {
            if (msg.getBuffer() == null) {
                return;
            }
            Address obj = (Address)msg.getObject();
            ConcurrentStartupTest.this.log.info((Object)("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: received " + obj));
            ConcurrentStartupChannel concurrentStartupChannel = this;
            synchronized (concurrentStartupChannel) {
                this.l.add(obj);
                Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                this.mods.put(key, obj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void viewAccepted(View new_view) {
            super.viewAccepted(new_view);
            ConcurrentStartupChannel concurrentStartupChannel = this;
            synchronized (concurrentStartupChannel) {
                Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                this.mods.put(key, new_view.getVid());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(byte[] state) {
            super.setState(state);
            try {
                List tmp = (List)Util.objectFromByteBuffer(state);
                ConcurrentStartupChannel concurrentStartupChannel = this;
                synchronized (concurrentStartupChannel) {
                    this.l.clear();
                    this.l.addAll(tmp);
                    ConcurrentStartupTest.this.log.info((Object)("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: state is " + this.l));
                    Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                    this.mods.put(key, tmp);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public byte[] getState() {
            super.getState();
            LinkedList<Address> tmp = null;
            ConcurrentStartupChannel concurrentStartupChannel = this;
            synchronized (concurrentStartupChannel) {
                tmp = new LinkedList<Address>(this.l);
                try {
                    return Util.objectToByteBuffer(tmp);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getState(OutputStream ostream) {
            super.getState(ostream);
            ObjectOutputStream oos = null;
            try {
                oos = new ObjectOutputStream(ostream);
                LinkedList<Address> tmp = null;
                ConcurrentStartupChannel concurrentStartupChannel = this;
                synchronized (concurrentStartupChannel) {
                    tmp = new LinkedList<Address>(this.l);
                }
                oos.writeObject(tmp);
                oos.flush();
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Util.close(oos);
                    throw throwable;
                }
                Util.close(oos);
            }
            Util.close(oos);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setState(InputStream istream) {
            super.setState(istream);
            ObjectInputStream ois = null;
            try {
                ois = new ObjectInputStream(istream);
                List tmp = (List)ois.readObject();
                ConcurrentStartupChannel concurrentStartupChannel = this;
                synchronized (concurrentStartupChannel) {
                    this.l.clear();
                    this.l.addAll(tmp);
                    ConcurrentStartupTest.this.log.info((Object)("-- [#" + this.getName() + " (" + this.channel.getLocalAddress() + ")]: state is " + this.l));
                    Integer key = new Integer(ConcurrentStartupTest.this.getMod());
                    this.mods.put(key, tmp);
                }
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    Util.close(ois);
                    throw throwable;
                }
                Util.close(ois);
            }
            Util.close(ois);
        }
    }

    protected class ConcurrentStartupChannelWithLargeState
    extends ConcurrentStartupChannel {
        private static final long TRANSFER_TIME = 2500L;

        public ConcurrentStartupChannelWithLargeState(Semaphore semaphore, String name, boolean useDispatcher) throws Exception {
            super(name, semaphore, useDispatcher);
        }

        public void setState(byte[] state) {
            Util.sleep(2500L);
            super.setState(state);
        }

        public byte[] getState() {
            Util.sleep(2500L);
            return super.getState();
        }

        public void getState(OutputStream ostream) {
            Util.sleep(2500L);
            super.getState(ostream);
        }

        public void setState(InputStream istream) {
            Util.sleep(2500L);
            super.setState(istream);
        }
    }
}

