/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.protocols.MERGE2;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.stack.ProtocolStack;

public class ChannelConcurrencyTest
extends TestCase {
    public void test() throws Exception {
        int count = 8;
        ExecutorService executor = Executors.newFixedThreadPool(8);
        final CountDownLatch latch = new CountDownLatch(8);
        JChannel[] channels = new JChannel[8];
        long start = System.currentTimeMillis();
        for (int i = 0; i < 8; ++i) {
            channels[i] = new JChannel("flush-udp.xml");
            ChannelConcurrencyTest.changeMergeInterval(channels[i]);
            ChannelConcurrencyTest.changeViewBundling(channels[i]);
        }
        JChannel[] arr$ = channels;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            final JChannel c = arr$[i$];
            executor.execute(new Runnable(){

                public void run() {
                    try {
                        c.connect("test");
                        latch.countDown();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        latch.await();
        while (true) {
            boolean done = true;
            for (JChannel channel : channels) {
                if (channel.getView().size() >= 8) continue;
                done = false;
            }
            if (done) break;
            TimeUnit.SECONDS.sleep(1L);
        }
        for (JChannel ch : channels) {
            System.out.println(((Channel)ch).getView());
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Converged to a single group after " + duration + " ms; group is:\n");
        for (int i = 0; i < channels.length; ++i) {
            System.out.println("#" + (i + 1) + ": " + channels[i].getLocalAddress() + ": " + channels[i].getView());
        }
    }

    private static void changeViewBundling(JChannel channel) {
        ProtocolStack stack = channel.getProtocolStack();
        GMS gms = (GMS)stack.findProtocol(GMS.class);
        if (gms != null) {
            gms.setViewBundling(true);
            gms.setMaxBundlingTime(500L);
        }
    }

    private static void changeMergeInterval(JChannel channel) {
        ProtocolStack stack = channel.getProtocolStack();
        MERGE2 merge = (MERGE2)stack.findProtocol(MERGE2.class);
        if (merge != null) {
            merge.setMinInterval(5000L);
            merge.setMaxInterval(10000L);
        }
    }
}

