/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Properties;
import org.jgroups.Event;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Util;

public class DELAY
extends Protocol {
    int in_delay = 0;
    int out_delay = 0;

    public String getName() {
        return "DELAY";
    }

    public boolean setProperties(Properties props) {
        super.setProperties(props);
        String str = props.getProperty("in_delay");
        if (str != null) {
            this.in_delay = Integer.parseInt(str);
            props.remove("in_delay");
        }
        if ((str = props.getProperty("out_delay")) != null) {
            this.out_delay = Integer.parseInt(str);
            props.remove("out_delay");
        }
        if (!props.isEmpty()) {
            this.log.error((Object)("DELAY.setProperties(): these properties are not recognized: " + props));
            return false;
        }
        return true;
    }

    public Object up(Event evt) {
        int delay = this.in_delay > 0 ? DELAY.computeDelay(this.in_delay) : 0;
        switch (evt.getType()) {
            case 1: {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("delaying incoming message for " + delay + " milliseconds"));
                }
                Util.sleep(delay);
            }
        }
        return this.up_prot.up(evt);
    }

    public Object down(Event evt) {
        int delay = this.out_delay > 0 ? DELAY.computeDelay(this.out_delay) : 0;
        switch (evt.getType()) {
            case 1: {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("delaying outgoing message for " + delay + " milliseconds"));
                }
                Util.sleep(delay);
            }
        }
        return this.down_prot.down(evt);
    }

    static int computeDelay(int n) {
        return (int)(Math.random() * 1000000.0 % (double)n);
    }
}

