/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.twiddle.command;

import java.io.PrintWriter;
import java.util.Date;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;
import org.jboss.console.twiddle.command.CommandException;
import org.jboss.console.twiddle.command.MBeanServerCommand;

public class XMBeanCommand
extends MBeanServerCommand {
    public XMBeanCommand() {
        super("xmbean", "Print out mbean metadata as an xmbean descriptor");
    }

    public void displayHelp() {
        PrintWriter out = this.context.getWriter();
        out.println(this.desc);
        out.println();
        out.println("Redirect the output and use it as a skeleton for");
        out.println("writing an xmbean descriptor for an existing mbean.");
        out.println();
        out.println("Usage: " + this.name + " <object-name>");
        out.println();
        out.flush();
    }

    public void execute(String[] args) throws Exception {
        int i;
        if (args.length != 1) {
            throw new CommandException("Missing object name");
        }
        ObjectName target = super.createObjectName(args[0]);
        MBeanInfo mbeanInfo = this.getMBeanServer().getMBeanInfo(target);
        MBeanConstructorInfo[] ctors = mbeanInfo.getConstructors();
        MBeanAttributeInfo[] attrs = mbeanInfo.getAttributes();
        MBeanOperationInfo[] ops = mbeanInfo.getOperations();
        MBeanNotificationInfo[] notifs = mbeanInfo.getNotifications();
        PrintWriter out = this.context.getWriter();
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<!DOCTYPE mbean PUBLIC");
        out.println("   \"-//JBoss//DTD JBOSS XMBEAN 1.2//EN\"");
        out.println("   \"http://www.jboss.org/j2ee/dtd/jboss_xmbean_1_2.dtd\">");
        out.println("<!--");
        out.println("   xmbean descriptor generated by 'twiddle'");
        out.println("   on " + new Date());
        out.println("   for '" + target + "'");
        out.println("-->");
        out.println("<mbean>");
        out.println("   <description>" + mbeanInfo.getDescription() + "</description>");
        out.println("   <class>" + mbeanInfo.getClassName() + "</class>");
        out.println();
        if (ctors.length > 0) {
            for (i = 0; i < ctors.length; ++i) {
                MBeanConstructorInfo ctorInfo = ctors[i];
                out.println("   <constructor>");
                out.println("      <description>" + ctorInfo.getDescription() + "</description>");
                out.println("      <name>" + ctorInfo.getName() + "</name>");
                this.outputParameters(out, ctorInfo.getSignature());
                out.println("   </constructor>");
            }
            out.println();
        }
        if (attrs.length > 0) {
            for (i = 0; i < attrs.length; ++i) {
                MBeanAttributeInfo attrInfo = attrs[i];
                String access = "read-write";
                access = attrInfo.isReadable() ? access : "write-only";
                access = attrInfo.isWritable() ? access : "read-only";
                String accessString = " access='" + access + "'";
                String getMethodString = "";
                if (attrInfo.isReadable()) {
                    getMethodString = " getMethod='" + (attrInfo.isIs() ? "is" : "get") + attrInfo.getName() + "'";
                }
                String setMethodString = "";
                if (attrInfo.isWritable()) {
                    setMethodString = " setMethod='set" + attrInfo.getName() + "'";
                }
                out.println("   <attribute" + accessString + getMethodString + setMethodString + ">");
                out.println("      <description>" + attrInfo.getDescription() + "</description>");
                out.println("      <name>" + attrInfo.getName() + "</name>");
                out.println("      <type>" + attrInfo.getType() + "</type>");
                out.println("   </attribute>");
            }
            out.println();
        }
        if (ops.length > 0) {
            for (i = 0; i < ops.length; ++i) {
                MBeanOperationInfo opInfo = ops[i];
                out.println("   <operation>");
                out.println("      <description>" + opInfo.getDescription() + "</description>");
                out.println("      <name>" + opInfo.getName() + "</name>");
                this.outputParameters(out, opInfo.getSignature());
                out.println("      <return-type>" + opInfo.getReturnType() + "</return-type>");
                out.println("   </operation>");
            }
            out.println();
        }
        if (notifs.length > 0) {
            for (i = 0; i < notifs.length; ++i) {
                MBeanNotificationInfo notifInfo = notifs[i];
                String[] types = notifInfo.getNotifTypes();
                out.println("   <notification>");
                out.println("      <description>" + notifInfo.getDescription() + "</description>");
                out.println("      <name>" + notifInfo.getName() + "</name>");
                for (int j = 0; j < types.length; ++j) {
                    out.println("      <notification-type>" + types[j] + "</notification-type>");
                }
                out.println("   </notification>");
            }
            out.println();
        }
        out.println("</mbean>");
        out.flush();
    }

    private void outputParameters(PrintWriter out, MBeanParameterInfo[] params) {
        for (int i = 0; i < params.length; ++i) {
            MBeanParameterInfo paramInfo = params[i];
            out.println("      <parameter>");
            out.println("         <description>" + paramInfo.getDescription() + "</description>");
            out.println("         <name>" + paramInfo.getName() + "</name>");
            out.println("         <type>" + paramInfo.getType() + "</type>");
            out.println("      </parameter>");
        }
    }
}

