/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.objectstore;

import com.arjuna.ats.arjuna.ArjunaNames;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.gandiva.ClassName;
import com.arjuna.ats.arjuna.gandiva.ObjectName;
import com.arjuna.ats.arjuna.gandiva.inventory.Inventory;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreImple;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.Implementations;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.SyncFailedException;

public class ObjectStore {
    public static final int OS_UNKNOWN = 0;
    public static final int OS_COMMITTED = 1;
    public static final int OS_UNCOMMITTED = 2;
    public static final int OS_HIDDEN = 4;
    public static final int OS_COMMITTED_HIDDEN = 5;
    public static final int OS_UNCOMMITTED_HIDDEN = 6;
    public static final int OS_SHADOW = 10;
    public static final int OS_ORIGINAL = 11;
    public static final int OS_INVISIBLE = 12;
    public static final int OS_SHARED = 13;
    public static final int OS_UNSHARED = 14;
    private ObjectStoreImple _imple;
    private static ClassName objectStoreType = null;

    public ObjectStore() {
        this("", 14);
    }

    public ObjectStore(int shareStatus) {
        this("", shareStatus);
    }

    public ObjectStore(String location) {
        this(location, 14);
    }

    public ObjectStore(String location, int shareStatus) {
        if (objectStoreType == null) {
            this.getDefault();
        }
        Object[] param = new Object[]{location, new Integer(shareStatus)};
        Object ptr = Inventory.inventory().createResources(objectStoreType, param);
        param = null;
        this._imple = ptr instanceof ObjectStoreImple ? (ObjectStoreImple)ptr : null;
    }

    public ObjectStore(ClassName typeName) {
        Object ptr;
        if (typeName == null) {
            typeName = this.getDefault();
        }
        this._imple = (ptr = Inventory.inventory().createVoid(typeName)) instanceof ObjectStoreImple ? (ObjectStoreImple)ptr : null;
    }

    public ObjectStore(ClassName typeName, int shareStatus) {
        this(typeName, "", shareStatus);
    }

    public ObjectStore(ClassName typeName, String location) {
        this(typeName, location, 14);
    }

    public ObjectStore(ClassName typeName, String location, int shareStatus) {
        if (typeName == null) {
            typeName = this.getDefault();
        }
        Object[] param = new Object[]{location, new Integer(shareStatus)};
        Object ptr = Inventory.inventory().createResources(typeName, param);
        param = null;
        this._imple = ptr instanceof ObjectStoreImple ? (ObjectStoreImple)ptr : null;
    }

    public ObjectStore(ClassName typeName, ObjectName objName) {
        Object ptr;
        if (typeName == null) {
            typeName = this.getDefault();
        }
        this._imple = (ptr = Inventory.inventory().createObjectName(typeName, objName)) instanceof ObjectStoreImple ? (ObjectStoreImple)ptr : null;
    }

    public ObjectStore(ObjectName objName) {
        Object ptr;
        ClassName typeName = null;
        try {
            typeName = objName.getClassNameAttribute("com.arjuna.ats.arjuna.objectstore.objectStoreType");
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (typeName == null) {
            typeName = this.getDefault();
        }
        ObjectName osObjName = null;
        try {
            osObjName = objName.getObjectNameAttribute(ArjunaNames.ObjectStore_implementationObjectName());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (osObjName == null) {
            osObjName = objName;
        }
        this._imple = (ptr = Inventory.inventory().createObjectName(typeName, osObjName)) instanceof ObjectStoreImple ? (ObjectStoreImple)ptr : null;
    }

    public void finalize() {
        this._imple = null;
    }

    public boolean allObjUids(String s, InputObjectState buff, int m) throws ObjectStoreException {
        return this._imple != null ? this._imple.allObjUids(s, buff, m) : false;
    }

    public boolean allObjUids(String s, InputObjectState buff) throws ObjectStoreException {
        return this._imple != null ? this._imple.allObjUids(s, buff, 0) : false;
    }

    public boolean allTypes(InputObjectState buff) throws ObjectStoreException {
        return this._imple != null ? this._imple.allTypes(buff) : false;
    }

    public int currentState(Uid u, String tn) throws ObjectStoreException {
        return this._imple != null ? this._imple.currentState(u, tn) : 0;
    }

    public String getStoreName() {
        return this._imple != null ? this._imple.getStoreName() : null;
    }

    public boolean commit_state(Uid u, String tn) throws ObjectStoreException {
        return this._imple != null ? this._imple.commit_state(u, tn) : false;
    }

    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        return this._imple != null ? this._imple.hide_state(u, tn) : false;
    }

    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        return this._imple != null ? this._imple.reveal_state(u, tn) : false;
    }

    public InputObjectState read_committed(Uid u, String tn) throws ObjectStoreException {
        return this._imple != null ? this._imple.read_committed(u, tn) : null;
    }

    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        return this._imple != null ? this._imple.read_uncommitted(u, tn) : null;
    }

    public boolean remove_committed(Uid u, String tn) throws ObjectStoreException {
        return this._imple != null ? this._imple.remove_committed(u, tn) : false;
    }

    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        return this._imple != null ? this._imple.remove_uncommitted(u, tn) : false;
    }

    public boolean write_committed(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        return this._imple != null ? this._imple.write_committed(u, tn, buff) : false;
    }

    public boolean write_uncommitted(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        return this._imple != null ? this._imple.write_uncommitted(u, tn, buff) : false;
    }

    public int typeIs() {
        return this._imple != null ? this._imple.typeIs() : -1;
    }

    public void sync() throws SyncFailedException, ObjectStoreException {
        if (this._imple == null) {
            throw new ObjectStoreException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.objectstore.ObjectStore_1"));
        }
        this._imple.sync();
    }

    public ClassName className() {
        return this._imple != null ? this._imple.className() : ClassName.invalid();
    }

    public String locateStore(String location) throws ObjectStoreException {
        return this._imple != null ? this._imple.locateStore(location) : null;
    }

    public boolean fullCommitNeeded() {
        return this._imple != null ? this._imple.fullCommitNeeded() : false;
    }

    public boolean isType(Uid u, String tn, int st) throws ObjectStoreException {
        return this._imple != null ? this._imple.isType(u, tn, st) : false;
    }

    public void initialise(Uid u, String tn) {
        if (this._imple != null) {
            this._imple.initialise(u, tn);
        }
    }

    public void pack(OutputBuffer buff) throws IOException {
        if (this._imple == null) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.objectstore.ObjectStore_1"));
        }
        this._imple.pack(buff);
    }

    public void unpack(InputBuffer buff) throws IOException {
        if (this._imple == null) {
            throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.objectstore.ObjectStore_1"));
        }
        this._imple.unpack(buff);
    }

    public static void printStateStatus(PrintWriter strm, int res) {
        strm.print(ObjectStore.stateStatusString(res));
    }

    public static String stateStatusString(int res) {
        switch (res) {
            case 0: {
                return "ObjectStore.OS_UNKNOWN";
            }
            case 1: {
                return "ObjectStore.OS_COMMITTED";
            }
            case 2: {
                return "ObjectStore.OS_UNCOMMITTED";
            }
            case 4: {
                return "ObjectStore.OS_HIDDEN";
            }
            case 5: {
                return "ObjectStore.OS_COMMITTED_HIDDEN";
            }
            case 6: {
                return "ObjectStore.OS_UNCOMMITTED_HIDDEN";
            }
        }
        return "Unknown";
    }

    public static void printStateType(PrintWriter strm, int res) {
        strm.print(ObjectStore.stateTypeString(res));
    }

    public static String stateTypeString(int res) {
        switch (res) {
            case 10: {
                return "ObjectStore.OS_SHADOW";
            }
            case 11: {
                return "ObjectStore.OS_ORIGINAL";
            }
            case 12: {
                return "ObjectStore.OS_INVISIBLE";
            }
        }
        return "Unknown";
    }

    public final int shareState() {
        return this._imple != null ? this._imple.shareState() : -1;
    }

    public final String storeDir() {
        return this._imple != null ? this._imple.storeDir() : null;
    }

    public final String storeRoot() {
        return this._imple != null ? this._imple.storeRoot() : null;
    }

    private ClassName getDefault() {
        if (objectStoreType == null) {
            objectStoreType = new ClassName(arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.objectStoreType", ArjunaNames.Implementation_ObjectStore_defaultStore().stringForm()));
        }
        return objectStoreType;
    }

    static {
        if (!Implementations.added()) {
            Implementations.initialise();
        }
    }
}

