/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.identity;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;

public class RoleFactory {
    public static String SIMPLE_ROLE_CLASS = "org.jboss.security.identity.plugins.SimpleRole";
    public static String SIMPLE_ROLEGROUP_CLASS = "org.jboss.security.identity.plugins.SimpleRoleGroup";

    public static Role createRole(final String name) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Role>(){

            @Override
            public Role run() throws Exception {
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = tcl.loadClass(SIMPLE_ROLE_CLASS);
                Constructor<?> ctr = clazz.getConstructor(String.class);
                return (Role)ctr.newInstance(name);
            }
        });
    }

    public static RoleGroup createRoleGroup(final String name) throws PrivilegedActionException {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<RoleGroup>(){

            @Override
            public RoleGroup run() throws Exception {
                ClassLoader tcl = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = tcl.loadClass(SIMPLE_ROLEGROUP_CLASS);
                Constructor<?> ctr = clazz.getConstructor(String.class);
                return (RoleGroup)ctr.newInstance(name);
            }
        });
    }
}

