/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.cond;

import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.BagAttribute;
import org.jboss.security.xacml.sunxacml.attr.BooleanAttribute;
import org.jboss.security.xacml.sunxacml.cond.Evaluatable;
import org.jboss.security.xacml.sunxacml.cond.EvaluationResult;
import org.jboss.security.xacml.sunxacml.cond.Expression;
import org.jboss.security.xacml.sunxacml.cond.Function;
import org.jboss.security.xacml.sunxacml.cond.VariableReference;

public class HigherOrderFunction
implements Function {
    public static final String NAME_ANY_OF = "urn:oasis:names:tc:xacml:1.0:function:any-of";
    public static final String NAME_ALL_OF = "urn:oasis:names:tc:xacml:1.0:function:all-of";
    public static final String NAME_ANY_OF_ANY = "urn:oasis:names:tc:xacml:1.0:function:any-of-any";
    public static final String NAME_ALL_OF_ANY = "urn:oasis:names:tc:xacml:1.0:function:all-of-any";
    public static final String NAME_ANY_OF_ALL = "urn:oasis:names:tc:xacml:1.0:function:any-of-all";
    public static final String NAME_ALL_OF_ALL = "urn:oasis:names:tc:xacml:1.0:function:all-of-all";
    private static final int ID_ANY_OF = 0;
    private static final int ID_ALL_OF = 1;
    private static final int ID_ANY_OF_ANY = 2;
    private static final int ID_ALL_OF_ANY = 3;
    private static final int ID_ANY_OF_ALL = 4;
    private static final int ID_ALL_OF_ALL = 5;
    private static HashMap idMap;
    private int functionId;
    private URI identifier;
    private boolean secondIsBag;
    private static URI returnTypeURI;
    private static RuntimeException earlyException;

    public HigherOrderFunction(String functionName) {
        Integer i = (Integer)idMap.get(functionName);
        if (i == null) {
            throw new IllegalArgumentException("unknown function: " + functionName);
        }
        this.functionId = i;
        try {
            this.identifier = new URI(functionName);
        }
        catch (URISyntaxException use) {
            throw new IllegalArgumentException("invalid URI");
        }
        this.secondIsBag = this.functionId != 0 && this.functionId != 1;
    }

    public static Set getSupportedIdentifiers() {
        return Collections.unmodifiableSet(idMap.keySet());
    }

    public URI getIdentifier() {
        return this.identifier;
    }

    public URI getType() {
        return this.getReturnType();
    }

    public URI getReturnType() {
        if (earlyException != null) {
            throw earlyException;
        }
        return returnTypeURI;
    }

    public boolean returnsBag() {
        return false;
    }

    public EvaluationResult evaluate(List inputs, EvaluationCtx context) {
        Iterator iterator = inputs.iterator();
        Expression xpr = (Expression)iterator.next();
        Function function = null;
        function = xpr instanceof Function ? (Function)xpr : (Function)((VariableReference)xpr).getReferencedDefinition().getExpression();
        AttributeValue[] args = new AttributeValue[2];
        Evaluatable eval = (Evaluatable)iterator.next();
        EvaluationResult result = eval.evaluate(context);
        if (result.indeterminate()) {
            return result;
        }
        args[0] = result.getAttributeValue();
        eval = (Evaluatable)iterator.next();
        result = eval.evaluate(context);
        if (result.indeterminate()) {
            return result;
        }
        args[1] = result.getAttributeValue();
        result = null;
        block0 : switch (this.functionId) {
            case 0: {
                result = this.any(args[0], (BagAttribute)args[1], function, context, false);
                break;
            }
            case 1: {
                result = this.all(args[0], (BagAttribute)args[1], function, context);
                break;
            }
            case 2: {
                result = new EvaluationResult(BooleanAttribute.getInstance(false));
                Iterator it = ((BagAttribute)args[0]).iterator();
                BagAttribute bag = (BagAttribute)args[1];
                while (it.hasNext()) {
                    AttributeValue value = (AttributeValue)it.next();
                    result = this.any(value, bag, function, context, false);
                    if (result.indeterminate()) {
                        return result;
                    }
                    if (!((BooleanAttribute)result.getAttributeValue()).getValue()) continue;
                    break block0;
                }
                break;
            }
            case 3: {
                result = this.allOfAny((BagAttribute)args[1], (BagAttribute)args[0], function, context);
                break;
            }
            case 4: {
                result = this.anyOfAll((BagAttribute)args[0], (BagAttribute)args[1], function, context);
                break;
            }
            case 5: {
                result = new EvaluationResult(BooleanAttribute.getInstance(true));
                Iterator it = ((BagAttribute)args[0]).iterator();
                BagAttribute bag = (BagAttribute)args[1];
                while (it.hasNext()) {
                    AttributeValue value = (AttributeValue)it.next();
                    result = this.all((AttributeValue)it.next(), bag, function, context);
                    if (result.indeterminate()) {
                        return result;
                    }
                    if (((BooleanAttribute)result.getAttributeValue()).getValue()) continue;
                    break block0;
                }
                break;
            }
        }
        return result;
    }

    public void checkInputs(List inputs) throws IllegalArgumentException {
        Expression xpr;
        Object[] list = inputs.toArray();
        if (list.length != 3) {
            throw new IllegalArgumentException("requires three inputs");
        }
        Function function = null;
        if (list[0] instanceof Function) {
            function = (Function)list[0];
        } else if (list[0] instanceof VariableReference && (xpr = ((VariableReference)list[0]).getReferencedDefinition().getExpression()) instanceof Function) {
            function = (Function)xpr;
        }
        if (function == null) {
            throw new IllegalArgumentException("first arg to higher-order  function must be a function");
        }
        if (!function.getReturnType().toString().equals("http://www.w3.org/2001/XMLSchema#boolean")) {
            throw new IllegalArgumentException("higher-order function must use a boolean function");
        }
        Evaluatable eval1 = (Evaluatable)list[1];
        Evaluatable eval2 = (Evaluatable)list[2];
        if (!eval1.getType().equals(eval2.getType())) {
            throw new IllegalArgumentException("input types to the any/all functions must match");
        }
        if (this.secondIsBag && !eval1.returnsBag()) {
            throw new IllegalArgumentException("first arg has to be a bag");
        }
        if (!eval2.returnsBag()) {
            throw new IllegalArgumentException("second arg has to be a bag");
        }
        ArrayList<Evaluatable> args = new ArrayList<Evaluatable>();
        args.add(eval1);
        args.add(eval2);
        function.checkInputsNoBag(args);
    }

    public void checkInputsNoBag(List inputs) throws IllegalArgumentException {
        throw new IllegalArgumentException("higher-order functions require use of bags");
    }

    private EvaluationResult any(AttributeValue value, BagAttribute bag, Function function, EvaluationCtx context, boolean argumentsAreSwapped) {
        return this.anyAndAllHelper(value, bag, function, context, false, argumentsAreSwapped);
    }

    private EvaluationResult all(AttributeValue value, BagAttribute bag, Function function, EvaluationCtx context) {
        return this.anyAndAllHelper(value, bag, function, context, true, false);
    }

    private EvaluationResult anyAndAllHelper(AttributeValue value, BagAttribute bag, Function function, EvaluationCtx context, boolean allFunction, boolean argumentsAreSwapped) {
        BooleanAttribute attr = BooleanAttribute.getInstance(allFunction);
        Iterator it = bag.iterator();
        while (it.hasNext()) {
            ArrayList<AttributeValue> params = new ArrayList<AttributeValue>();
            if (!argumentsAreSwapped) {
                params.add(value);
                params.add((AttributeValue)it.next());
            } else {
                params.add((AttributeValue)it.next());
                params.add(value);
            }
            EvaluationResult result = function.evaluate(params, context);
            if (result.indeterminate()) {
                return result;
            }
            BooleanAttribute bool = (BooleanAttribute)result.getAttributeValue();
            if (bool.getValue() == allFunction) continue;
            attr = bool;
            break;
        }
        return new EvaluationResult(attr);
    }

    private EvaluationResult anyOfAll(BagAttribute anyBag, BagAttribute allBag, Function function, EvaluationCtx context) {
        return this.allAnyHelper(anyBag, allBag, function, context, true);
    }

    private EvaluationResult allOfAny(BagAttribute anyBag, BagAttribute allBag, Function function, EvaluationCtx context) {
        return this.allAnyHelper(anyBag, allBag, function, context, false);
    }

    private EvaluationResult allAnyHelper(BagAttribute anyBag, BagAttribute allBag, Function function, EvaluationCtx context, boolean argumentsAreSwapped) {
        Iterator it = allBag.iterator();
        while (it.hasNext()) {
            AttributeValue value = (AttributeValue)it.next();
            EvaluationResult result = this.any(value, anyBag, function, context, argumentsAreSwapped);
            if (result.indeterminate()) {
                return result;
            }
            if (((BooleanAttribute)result.getAttributeValue()).getValue()) continue;
            return result;
        }
        return new EvaluationResult(BooleanAttribute.getTrueInstance());
    }

    public void encode(OutputStream output) {
        this.encode(output, new Indenter(0));
    }

    public void encode(OutputStream output, Indenter indenter) {
        PrintStream out = new PrintStream(output);
        out.println(indenter.makeString() + "<Function FunctionId=\"" + this.getIdentifier().toString() + "\"/>");
    }

    static {
        try {
            returnTypeURI = new URI("http://www.w3.org/2001/XMLSchema#boolean");
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
        idMap = new HashMap();
        idMap.put(NAME_ANY_OF, new Integer(0));
        idMap.put(NAME_ALL_OF, new Integer(1));
        idMap.put(NAME_ANY_OF_ANY, new Integer(2));
        idMap.put(NAME_ALL_OF_ANY, new Integer(3));
        idMap.put(NAME_ANY_OF_ALL, new Integer(4));
        idMap.put(NAME_ALL_OF_ALL, new Integer(5));
    }
}

