/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.sunxacml.attr;

import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.IPv4AddressAttribute;
import org.jboss.security.xacml.sunxacml.attr.IPv6AddressAttribute;
import org.jboss.security.xacml.sunxacml.attr.PortRange;
import org.w3c.dom.Node;

public abstract class IPAddressAttribute
extends AttributeValue {
    public static final String identifier = "urn:oasis:names:tc:xacml:2.0:data-type:ipAddress";
    private static URI identifierURI;
    private static RuntimeException earlyException;
    private InetAddress address;
    private InetAddress mask;
    private PortRange range;

    protected IPAddressAttribute(InetAddress address, InetAddress mask, PortRange range) {
        super(identifierURI);
        if (earlyException != null) {
            throw earlyException;
        }
        this.address = address;
        this.mask = mask;
        this.range = range;
    }

    public static IPAddressAttribute getInstance(Node root) throws ParsingException {
        return IPAddressAttribute.getInstance(root.getFirstChild().getNodeValue());
    }

    public static IPAddressAttribute getInstance(String value) throws ParsingException {
        try {
            if (value.indexOf(91) == 0) {
                return IPv6AddressAttribute.getV6Instance(value);
            }
            return IPv4AddressAttribute.getV4Instance(value);
        }
        catch (UnknownHostException uhe) {
            throw new ParsingException("Failed to parse an IPAddress", uhe);
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public InetAddress getMask() {
        return this.mask;
    }

    public PortRange getRange() {
        return this.range;
    }

    public boolean equals(Object o) {
        if (!(o instanceof IPAddressAttribute)) {
            return false;
        }
        IPAddressAttribute other = (IPAddressAttribute)o;
        if (!this.address.equals(other.address)) {
            return false;
        }
        if (this.mask != null) {
            if (other.mask == null) {
                return false;
            }
            if (!this.mask.equals(other.mask)) {
                return false;
            }
        } else if (other.mask != null) {
            return false;
        }
        return this.range.equals(other.range);
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "IPAddressAttribute: \"" + this.encode() + "\"";
    }

    static {
        try {
            identifierURI = new URI(identifier);
        }
        catch (Exception e) {
            earlyException = new IllegalArgumentException();
            earlyException.initCause(e);
        }
    }
}

