/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.inflow;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.ejb.EJBMetaData;
import javax.management.ObjectName;
import javax.resource.spi.ActivationSpec;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.resource.spi.endpoint.MessageEndpointFactory;
import javax.transaction.xa.XAResource;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.MessageDrivenContainer;
import org.jboss.ejb.plugins.inflow.GetTCLAction;
import org.jboss.ejb.plugins.inflow.JBossMessageEndpointFactoryMBean;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.InvokerInterceptor;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.metadata.InvokerProxyBindingMetaData;
import org.jboss.metadata.MessageDrivenMetaData;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.proxy.GenericProxyFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.Strings;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JBossMessageEndpointFactory
extends ServiceMBeanSupport
implements EJBProxyFactory,
MessageEndpointFactory,
JBossMessageEndpointFactoryMBean {
    protected boolean trace;
    protected MessageDrivenContainer container;
    protected MessageDrivenMetaData metaData;
    protected String invokerBinding;
    protected InvokerProxyBindingMetaData invokerMetaData;
    protected HashMap<String, ActivationConfigPropertyMetaData> properties;
    protected GenericProxyFactory proxyFactory;
    protected Class<?> messagingTypeClass;
    protected String resourceAdapterName;
    protected ObjectName resourceAdapterObjectName;
    protected ActivationSpec activationSpec;
    protected ArrayList<Class<?>> interceptors;
    protected Class<?>[] interfaces;
    protected AtomicInteger nextProxyId;
    protected AtomicBoolean deliveryActive;
    protected String[] createActivationSpecSig;
    protected String[] activationSig;

    public JBossMessageEndpointFactory() {
        this.trace = this.log.isTraceEnabled();
        this.properties = new HashMap();
        this.proxyFactory = new GenericProxyFactory();
        this.nextProxyId = new AtomicInteger(0);
        this.deliveryActive = new AtomicBoolean(true);
        this.createActivationSpecSig = new String[]{Class.class.getName(), Collection.class.getName()};
        this.activationSig = new String[]{MessageEndpointFactory.class.getName(), ActivationSpec.class.getName()};
    }

    public MessageDrivenContainer getContainer() {
        return this.container;
    }

    public String getConfig() {
        return this.toString();
    }

    public MessageEndpoint createEndpoint(XAResource resource) throws UnavailableException {
        this.trace = this.log.isTraceEnabled();
        if (this.getState() != 3 && this.getState() != 2) {
            throw new UnavailableException("The container is not started");
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("MessageEndpoint.Factory", this);
        context.put("MessageEndpoint.XAResource", resource);
        String ejbName = this.container.getBeanMetaData().getContainerObjectNameJndiName();
        if (this.trace) {
            this.log.trace((Object)("createEndpoint " + this + " xaResource=" + resource));
        }
        MessageEndpoint endpoint = (MessageEndpoint)this.proxyFactory.createProxy(ejbName + "@" + this.nextProxyId.incrementAndGet(), this.container.getServiceName(), InvokerInterceptor.getLocal(), null, null, this.interceptors, this.container.getClassLoader(), this.interfaces, context);
        if (this.trace) {
            this.log.trace((Object)("Created endpoint " + endpoint + " from " + this));
        }
        return endpoint;
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        boolean result = false;
        byte transType = this.metaData.getMethodTransactionType(method.getName(), (Class[])method.getParameterTypes(), InvocationType.LOCAL);
        if (transType == 1) {
            result = true;
        }
        if (this.trace) {
            this.log.trace((Object)("isDeliveryTransacted " + this.container.getBeanMetaData().getContainerObjectNameJndiName() + " method=" + method + " result=" + result));
        }
        return result;
    }

    protected void startService() throws Exception {
        this.metaData = (MessageDrivenMetaData)this.container.getBeanMetaData();
        this.resolveMessageListener();
        this.resolveResourceAdapter();
        this.createActivationSpec();
        this.setupProxyParameters();
        this.activate();
    }

    protected void stopService() throws Exception {
        this.deactivate();
    }

    public boolean isIdentical(Container container, Invocation mi) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getEJBHome() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public EJBMetaData getEJBMetaData() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Collection getEntityCollection(Collection collection) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getEntityEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getStatefulSessionEJBObject(Object id) {
        throw new Error("Not valid for MessageDriven beans");
    }

    public Object getStatelessSessionEJBObject() {
        throw new Error("Not valid for MessageDriven beans");
    }

    public void setInvokerBinding(String binding) {
        this.invokerBinding = binding;
    }

    public void setInvokerMetaData(InvokerProxyBindingMetaData imd) {
        this.invokerMetaData = imd;
    }

    public void setContainer(Container container) {
        this.container = (MessageDrivenContainer)container;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(super.toString());
        buffer.append("{ resourceAdapter=").append(this.resourceAdapterObjectName);
        buffer.append(", messagingType=").append(this.messagingTypeClass.getName());
        buffer.append(", ejbName=").append(this.container.getBeanMetaData().getContainerObjectNameJndiName());
        buffer.append(", activationConfig=").append(this.properties.values());
        buffer.append(", activationSpec=").append(this.activationSpec);
        buffer.append("}");
        return buffer.toString();
    }

    protected void resolveMessageListener() throws DeploymentException {
        String messagingType = this.metaData.getMessagingType();
        try {
            this.messagingTypeClass = GetTCLAction.getContextClassLoader().loadClass(messagingType);
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)("Could not load messaging-type class " + messagingType), (Throwable)e);
        }
    }

    protected String resolveResourceAdapterName() throws DeploymentException {
        return this.metaData.getResourceAdapterName();
    }

    protected void resolveResourceAdapter() throws DeploymentException {
        this.resourceAdapterName = this.resolveResourceAdapterName();
        try {
            this.resourceAdapterObjectName = new ObjectName("jboss.jca:service=RARDeployment,name='" + this.resourceAdapterName + "'");
            int state = (Integer)this.server.getAttribute(this.resourceAdapterObjectName, "State");
            if (state != 3) {
                throw new DeploymentException("The resource adapter is not started " + this.resourceAdapterName);
            }
        }
        catch (Exception e) {
            DeploymentException.rethrowAsDeploymentException((String)("Cannot locate resource adapter deployment " + this.resourceAdapterName), (Throwable)e);
        }
    }

    protected void setupProxyParameters() throws DeploymentException {
        this.interfaces = new Class[]{MessageEndpoint.class, this.messagingTypeClass};
        this.interceptors = new ArrayList();
        Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
        Element endpointInterceptors = MetaData.getOptionalChild((Element)proxyConfig, (String)"endpoint-interceptors", null);
        if (endpointInterceptors == null) {
            throw new DeploymentException("No endpoint interceptors found");
        }
        NodeList children = endpointInterceptors.getElementsByTagName("interceptor");
        for (int i = 0; i < children.getLength(); ++i) {
            Node currentChild = children.item(i);
            if (currentChild.getNodeType() != 1) continue;
            Element interceptor = (Element)children.item(i);
            String className = MetaData.getElementContent((Element)interceptor);
            try {
                Class<?> clazz = this.container.getClassLoader().loadClass(className);
                this.interceptors.add(clazz);
                continue;
            }
            catch (Throwable t) {
                DeploymentException.rethrowAsDeploymentException((String)("Error loading interceptor class " + className), (Throwable)t);
            }
        }
    }

    protected void augmentActivationConfigProperties() throws DeploymentException {
        String link;
        Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
        Element activationConfig = MetaData.getOptionalChild((Element)proxyConfig, (String)"activation-config");
        if (activationConfig != null) {
            Iterator iterator = MetaData.getChildrenByTagName((Element)activationConfig, (String)"activation-config-property");
            while (iterator.hasNext()) {
                Element xml = (Element)iterator.next();
                org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData md = new org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData();
                ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData(md);
                String name = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)xml, (String)"activation-config-property-name"));
                String value = MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)xml, (String)"activation-config-property-value"));
                if (name == null || name.trim().length() == 0) {
                    throw new DeploymentException("activation-config-property doesn't have a name");
                }
                if (!Strings.isValidJavaIdentifier((String)name)) {
                    throw new DeploymentException("activation-config-property '" + name + "' is not a valid java identifier");
                }
                md.setName(name);
                md.setValue(value);
                if (this.properties.containsKey(metaData.getName())) continue;
                this.properties.put(metaData.getName(), metaData);
            }
        }
        if ((link = this.metaData.getDestinationLink()) != null && (link = link.trim()).length() > 0) {
            if (this.properties.containsKey("destination")) {
                this.log.warn((Object)("Ignoring message-destination-link '" + link + "' when the destination " + "is already in the activation-config."));
            } else {
                MessageDestinationMetaData destinationMetaData = this.container.getMessageDestination(link);
                if (destinationMetaData == null) {
                    throw new DeploymentException("Unresolved message-destination-link '" + link + "' no message-destination in ejb-jar.xml");
                }
                String jndiName = destinationMetaData.getJndiName();
                if (jndiName == null) {
                    throw new DeploymentException("The message-destination '" + link + "' has no jndi-name in jboss.xml");
                }
                org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData acpmd = new org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData();
                acpmd.setActivationConfigPropertyName("destination");
                acpmd.setValue(jndiName);
                ActivationConfigPropertyMetaData wrapper = new ActivationConfigPropertyMetaData(acpmd);
                this.properties.put("destination", wrapper);
            }
        }
    }

    protected void createActivationSpec() throws DeploymentException {
        this.properties = new HashMap(this.metaData.getActivationConfigProperties());
        this.augmentActivationConfigProperties();
        Object[] params = new Object[]{this.messagingTypeClass, this.properties.values()};
        try {
            this.activationSpec = (ActivationSpec)this.server.invoke(this.resourceAdapterObjectName, "createActivationSpec", params, this.createActivationSpecSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            DeploymentException.rethrowAsDeploymentException((String)("Unable to create activation spec ra=" + this.resourceAdapterObjectName + " messaging-type=" + this.messagingTypeClass.getName() + " properties=" + this.metaData.getActivationConfigProperties()), (Throwable)t);
        }
    }

    public void startDelivery() throws Exception {
        if (this.getState() != 3) {
            throw new IllegalStateException("The MDB is not started");
        }
        if (this.deliveryActive.getAndSet(true)) {
            return;
        }
        this.activate();
    }

    public void stopDelivery() throws Exception {
        this.stopDelivery(false);
    }

    public void stopDelivery(boolean asynch) throws Exception {
        if (this.getState() != 3) {
            throw new IllegalStateException("The MDB is not started");
        }
        if (!this.deliveryActive.getAndSet(false)) {
            return;
        }
        if (asynch) {
            new Thread("StopDelivery: " + this.getServiceName()){

                public void run() {
                    JBossMessageEndpointFactory.this.deactivate();
                }
            }.start();
        } else {
            this.deactivate();
        }
    }

    public boolean getDeliveryActive() {
        return this.deliveryActive.get();
    }

    public void setDeliveryActive(boolean active) {
        this.deliveryActive.set(active);
    }

    protected void activate() throws DeploymentException {
        if (!this.deliveryActive.get()) {
            this.log.info((Object)("Delivery is disabled: " + this.getServiceName()));
            return;
        }
        Object[] params = new Object[]{this, this.activationSpec};
        try {
            this.server.invoke(this.resourceAdapterObjectName, "endpointActivation", params, this.activationSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            DeploymentException.rethrowAsDeploymentException((String)("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec), (Throwable)t);
        }
    }

    protected void deactivate() {
        Object[] params = new Object[]{this, this.activationSpec};
        try {
            this.server.invoke(this.resourceAdapterObjectName, "endpointDeactivation", params, this.activationSig);
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            this.log.warn((Object)("Endpoint activation failed ra=" + this.resourceAdapterObjectName + " activationSpec=" + this.activationSpec), t);
        }
    }
}

