/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.mbeans.MBeanUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.jboss.logging.Logger;

public class GlobalResourcesLifecycleListener
implements LifecycleListener {
    private static Logger log = Logger.getLogger(GlobalResourcesLifecycleListener.class);
    protected Lifecycle component = null;
    protected static Registry registry = MBeanUtils.createRegistry();

    public void lifecycleEvent(LifecycleEvent event) {
        if ("start".equals(event.getType())) {
            this.component = event.getLifecycle();
            this.createMBeans();
        } else if ("stop".equals(event.getType())) {
            this.destroyMBeans();
            this.component = null;
        }
    }

    protected void createMBeans() {
        Context context = null;
        try {
            context = (Context)new InitialContext().lookup("java:/");
        }
        catch (NamingException e) {
            log.error((Object)"No global naming context defined for server");
            return;
        }
        try {
            this.createMBeans("", context);
        }
        catch (NamingException e) {
            log.error((Object)"Exception processing Global JNDI Resources", (Throwable)e);
        }
    }

    protected void createMBeans(String prefix, Context context) throws NamingException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating MBeans for Global JNDI Resources in Context '" + prefix + "'"));
        }
        try {
            NamingEnumeration<Binding> bindings = context.listBindings("");
            while (bindings.hasMore()) {
                Binding binding = bindings.next();
                String name = prefix + binding.getName();
                Object value = context.lookup(binding.getName());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking resource " + name));
                }
                if (!(value instanceof Context)) continue;
                this.createMBeans(name + "/", (Context)value);
            }
        }
        catch (RuntimeException ex) {
            log.error((Object)("RuntimeException " + ex));
        }
        catch (OperationNotSupportedException ex) {
            log.error((Object)("Operation not supported " + ex));
        }
    }

    protected void destroyMBeans() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Destroying MBeans for Global JNDI Resources");
        }
    }
}

