/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.exec;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.exec.AbstractStatementExecutor;
import org.hibernate.hql.ast.tree.DeleteStatement;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Delete;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiTableDeleteExecutor
extends AbstractStatementExecutor {
    private static final Logger log = LoggerFactory.getLogger((Class)MultiTableDeleteExecutor.class);
    private final Queryable persister;
    private final String idInsertSelect;
    private final String[] deletes;

    public MultiTableDeleteExecutor(HqlSqlWalker walker) {
        super(walker, log);
        if (!walker.getSessionFactoryHelper().getFactory().getDialect().supportsTemporaryTables()) {
            throw new HibernateException("cannot perform multi-table deletes using dialect not supporting temp tables");
        }
        DeleteStatement deleteStatement = (DeleteStatement)walker.getAST();
        FromElement fromElement = deleteStatement.getFromClause().getFromElement();
        String bulkTargetAlias = fromElement.getTableAlias();
        this.persister = fromElement.getQueryable();
        this.idInsertSelect = this.generateIdInsertSelect(this.persister, bulkTargetAlias, deleteStatement.getWhereClause());
        log.trace("Generated ID-INSERT-SELECT SQL (multi-table delete) : " + this.idInsertSelect);
        String[] tableNames = this.persister.getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.persister.getContraintOrderedTableKeyColumnClosure();
        String idSubselect = this.generateIdSubselect(this.persister);
        this.deletes = new String[tableNames.length];
        for (int i = tableNames.length - 1; i >= 0; --i) {
            Delete delete = new Delete().setTableName(tableNames[i]).setWhere("(" + StringHelper.join(", ", columnNames[i]) + ") IN (" + idSubselect + ")");
            if (this.getFactory().getSettings().isCommentsEnabled()) {
                delete.setComment("bulk delete");
            }
            this.deletes[i] = delete.toStatementString();
        }
    }

    public String[] getSqlStatements() {
        return this.deletes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        this.coordinateSharedCacheCleanup(session);
        this.createTemporaryTableIfNecessary(this.persister, session);
        try {
            PreparedStatement ps = null;
            int resultCount = 0;
            try {
                try {
                    ps = session.getBatcher().prepareStatement(this.idInsertSelect);
                    Iterator paramSpecifications = this.getWalker().getParameters().iterator();
                    int pos = 1;
                    while (paramSpecifications.hasNext()) {
                        ParameterSpecification paramSpec = (ParameterSpecification)paramSpecifications.next();
                        pos += paramSpec.bind(ps, parameters, session, pos);
                    }
                    resultCount = ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        session.getBatcher().closeStatement(ps);
                    }
                }
            }
            catch (SQLException e) {
                throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), e, "could not insert/select ids for bulk delete", this.idInsertSelect);
            }
            for (int i = 0; i < this.deletes.length; ++i) {
                try {
                    try {
                        ps = session.getBatcher().prepareStatement(this.deletes[i]);
                        ps.executeUpdate();
                        continue;
                    }
                    finally {
                        if (ps != null) {
                            session.getBatcher().closeStatement(ps);
                        }
                    }
                }
                catch (SQLException e) {
                    throw JDBCExceptionHelper.convert(this.getFactory().getSQLExceptionConverter(), e, "error performing bulk delete", this.deletes[i]);
                }
            }
            int n = resultCount;
            return n;
        }
        finally {
            this.dropTemporaryTableIfNecessary(this.persister, session);
        }
    }

    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

