/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.stateful;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.ejb3.proxy.JndiSessionProxyObjectFactory;
import org.jboss.ejb3.proxy.ProxyFactory;
import org.jboss.ejb3.proxy.factory.BaseSessionProxyFactory;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public abstract class BaseStatefulProxyFactory
extends BaseSessionProxyFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(BaseStatefulProxyFactory.class);
    public static final String PROXY_FACTORY_NAME = "StatefulProxyFactory";

    protected BaseStatefulProxyFactory() {
    }

    public BaseStatefulProxyFactory(SessionSpecContainer container, String jndiName) {
        super(container);
        assert (jndiName != null) : "jndiName is null";
        this.jndiName = jndiName;
    }

    public void init() throws Exception {
        this.validateEjb21Views();
        this.createProxyConstructors();
    }

    public void start() throws Exception {
        this.init();
        Context ctx = this.getContainer().getInitialContext();
        Name name = ctx.getNameParser("").parse(this.jndiName);
        ctx = Util.createSubcontext((Context)ctx, (Name)name.getPrefix(name.size() - 1));
        String atom = name.get(name.size() - 1);
        StringRefAddr refAddr = new StringRefAddr("FACTORY", this.jndiName + PROXY_FACTORY_NAME);
        Reference ref = new Reference(Object.class.getName(), refAddr, JndiSessionProxyObjectFactory.class.getName(), null);
        try {
            log.debug((Object)("Binding reference for " + this.getContainer().getEjbName() + " in JNDI at " + this.jndiName));
            Util.rebind((Context)ctx, (String)atom, (Object)ref);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + ctx.getNameInNamespace() + "/" + atom);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    public void stop() throws Exception {
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)this.jndiName);
    }

    protected final void initializeJndiName() {
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        try {
            this.init();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new IOException(e.getMessage());
        }
        this.jndiName = in.readUTF();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeUTF(this.jndiName);
    }
}

