/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoteHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.SpecificationInterfaceType;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.proxy.JBossProxy;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.SessionProxyFactory;
import org.jboss.ejb3.proxy.handler.BaseSessionRemoteProxyInvocationHandler;
import org.jboss.ejb3.proxy.impl.EJBMetaDataImpl;
import org.jboss.ejb3.proxy.impl.HomeHandleImpl;
import org.jboss.ejb3.session.ProxyAccessType;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseSessionProxyFactory
implements SessionProxyFactory,
Externalizable {
    private static final Logger log = Logger.getLogger(BaseSessionProxyFactory.class);
    private static final String JNDI_NAME_SUFFIX_PROXY_FACTORY = "/ProxyFactory";
    private SessionSpecContainer container;
    protected String containerGuid;
    protected String containerClusterUid;
    protected boolean isClustered = false;
    protected String jndiName;
    protected Constructor<?> businessProxyConstructor;
    protected Constructor<?> ejb21ProxyConstructor;
    private static final String METHOD_PREFIX_EJB21_CREATE = "create";

    public BaseSessionProxyFactory() {
    }

    protected BaseSessionProxyFactory(SessionSpecContainer container) {
        assert (container != null) : "container is null";
        this.setContainer(container);
    }

    @Override
    public Object createHomeProxy() {
        throw new RuntimeException("NYI");
    }

    protected void createProxyConstructors() throws Exception {
        ClassLoader cl = this.getContainer().getBeanClass().getClassLoader();
        Class<?>[] businessInterfaces = this.getInterfacesForBusinessProxy();
        this.businessProxyConstructor = ProxyFactoryHelper.createProxyConstructor(businessInterfaces, cl);
        Class<?>[] ejb21Interfaces = this.getInterfacesForEjb21Proxy();
        if (ejb21Interfaces != null) {
            this.ejb21ProxyConstructor = ProxyFactoryHelper.createProxyConstructor(ejb21Interfaces, cl);
        }
    }

    protected void bindProxy(Object proxy) throws NamingException {
        try {
            log.debug((Object)("Binding proxy for " + this.getContainer().getEjbName() + " in JNDI at " + this.getJndiName()));
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)this.getJndiName(), (Object)proxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind session proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + this.getJndiName());
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    protected abstract boolean bindHomeAndBusinessTogether();

    protected Object constructProxyBusiness(InvocationHandler handler) {
        return this.constructProxy(handler, SpecificationInterfaceType.EJB30_BUSINESS);
    }

    protected Object constructEjb21Proxy(InvocationHandler handler) {
        return this.constructProxy(handler, SpecificationInterfaceType.EJB21);
    }

    protected Object constructProxy(InvocationHandler handler, SpecificationInterfaceType specType) {
        Object obj = null;
        try {
            if (specType.equals((Object)SpecificationInterfaceType.EJB30_BUSINESS)) {
                obj = this.businessProxyConstructor.newInstance(handler);
            } else if (specType.equals((Object)SpecificationInterfaceType.EJB21)) {
                if (this.ejb21ProxyConstructor == null) {
                    throw new IllegalStateException("EJB3 Specification Violation Section 4.3.3: \"Only session beans with a remote EJBObject / local EJBLocalObject interface can call this method.");
                }
                obj = this.ejb21ProxyConstructor.newInstance(handler);
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new RuntimeException(t);
        }
        assert (obj != null) : "Proxy Object must not be null";
        return obj;
    }

    protected void setContainer(SessionSpecContainer container) {
        this.container = container;
        this.containerGuid = Ejb3Registry.guid((Container)container);
        this.containerClusterUid = Ejb3Registry.clusterUid((Container)container);
        this.isClustered = container.isClustered();
    }

    protected SessionSpecContainer getContainer() {
        if (this.container == null) {
            this.container = (SessionSpecContainer)Ejb3Registry.findContainer(this.containerGuid);
            if (this.container == null && this.isClustered) {
                this.container = (SessionSpecContainer)Ejb3Registry.getClusterContainer(this.containerClusterUid);
            }
        }
        return this.container;
    }

    protected Class<?>[] getInterfacesForBusinessProxy() {
        return this.getInterfacesForProxy(this.getProxyAccessType(), SpecificationInterfaceType.EJB30_BUSINESS);
    }

    protected Class<?>[] getInterfacesForEjb21Proxy() {
        return this.getInterfacesForProxy(this.getProxyAccessType(), SpecificationInterfaceType.EJB21);
    }

    private Class<?>[] getInterfacesForProxy(ProxyAccessType accessType, SpecificationInterfaceType specType) {
        Class<?> home;
        HashSet<Class<JBossProxy>> interfaces = new HashSet<Class<JBossProxy>>();
        SessionSpecContainer container = this.getContainer();
        HashSet intfs = new HashSet();
        if (accessType.equals((Object)ProxyAccessType.LOCAL)) {
            if (specType.equals((Object)SpecificationInterfaceType.EJB30_BUSINESS)) {
                intfs.addAll(Arrays.asList(ProxyFactoryHelper.getLocalBusinessInterfaces((Container)container)));
                if (this.bindHomeAndBusinessTogether() && (home = this.getHomeType()) != null) {
                    intfs.add(home);
                }
            } else {
                intfs.addAll(Arrays.asList(ProxyFactoryHelper.getLocalInterfaces((Container)container)));
                if (intfs.size() == 0) {
                    return null;
                }
                intfs.add(EJBLocalObject.class);
            }
        } else if (specType.equals((Object)SpecificationInterfaceType.EJB30_BUSINESS)) {
            intfs.addAll(Arrays.asList(ProxyFactoryHelper.getRemoteBusinessInterfaces((Container)container)));
            if (this.bindHomeAndBusinessTogether() && (home = this.getHomeType()) != null) {
                intfs.add(home);
            }
        } else {
            intfs.addAll(Arrays.asList(ProxyFactoryHelper.getRemoteInterfaces((Container)container)));
            if (intfs.size() == 0) {
                return null;
            }
            intfs.add(EJBObject.class);
        }
        for (Class clazz : intfs) {
            interfaces.add(clazz);
        }
        interfaces.add(JBossProxy.class);
        return interfaces.toArray(new Class[0]);
    }

    protected abstract ProxyAccessType getProxyAccessType();

    protected void setEjb21Objects(BaseSessionRemoteProxyInvocationHandler proxy) {
        proxy.setHandle(this.createHandle());
        proxy.setHomeHandle(this.getHomeHandle());
        proxy.setEjbMetaData(this.getEjbMetaData());
    }

    protected abstract Handle createHandle();

    protected HomeHandle getHomeHandle() {
        SessionSpecContainer ejbContainer = this.container;
        HomeHandleImpl homeHandle = null;
        RemoteBinding remoteBindingAnnotation = ejbContainer.getAnnotation(RemoteBinding.class);
        if (remoteBindingAnnotation != null) {
            homeHandle = new HomeHandleImpl(ProxyFactoryHelper.getHomeJndiName((EJBContainer)this.container));
        }
        return homeHandle;
    }

    protected abstract Class<?> getHomeType();

    protected final String getJndiName() {
        return this.jndiName;
    }

    public final String getJndiNameProxyFactory() {
        return this.getJndiName() + JNDI_NAME_SUFFIX_PROXY_FACTORY;
    }

    protected EJBMetaData getEjbMetaData() {
        RemoteBinding remoteBindingAnnotation;
        RemoteHome homeAnnotation;
        Class<?> remote = null;
        Class home = null;
        Class<Object> pkClass = Object.class;
        HomeHandleImpl homeHandle = null;
        SessionSpecContainer ejbContainer = this.container;
        Class<?>[] remotes = ProxyFactoryHelper.getRemoteInterfaces((Container)this.getContainer());
        if (remotes != null && remotes.length > 0) {
            remote = remotes[0];
        }
        if ((homeAnnotation = ejbContainer.getAnnotation(RemoteHome.class)) != null) {
            home = homeAnnotation.value();
        }
        if ((remoteBindingAnnotation = ejbContainer.getAnnotation(RemoteBinding.class)) != null) {
            homeHandle = new HomeHandleImpl(remoteBindingAnnotation.jndiBinding());
        }
        EJBMetaDataImpl metadata = new EJBMetaDataImpl(remote, home, pkClass, true, false, homeHandle);
        return metadata;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerGuid = in.readUTF();
        this.containerClusterUid = in.readUTF();
        this.isClustered = in.readBoolean();
        if (this.getContainer() == null) {
            throw new EJBException("Invalid (i.e. remote) invocation of local interface (null container) for " + this.containerGuid);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.containerGuid);
        out.writeUTF(this.containerClusterUid);
        out.writeBoolean(this.isClustered);
    }

    protected void validateCompleteEjb21View(Class<?> home, Class<?>[] localOrRemoteInterfaces) throws RuntimeException {
        assert (home == null || EJBHome.class.isAssignableFrom(home) || EJBLocalHome.class.isAssignableFrom(home));
        for (Class<?> localOrRemoteInterface : localOrRemoteInterfaces) {
            assert (EJBObject.class.isAssignableFrom(localOrRemoteInterface) || EJBLocalObject.class.isAssignableFrom(localOrRemoteInterface));
        }
        if (home != null && localOrRemoteInterfaces.length == 0) {
            throw new RuntimeException("EJBTHREE-1075: " + this.container.getBeanClassName() + " defines home" + " but provides no local/remote interfaces extending " + EJBLocalObject.class.getName() + "/" + EJBObject.class.getName() + "; EJB 2.1 view cannot be realized");
        }
        if (home == null && localOrRemoteInterfaces.length != 0) {
            throw new RuntimeException("EJBTHREE-1075: " + this.container.getBeanClassName() + " defines local/remote interfaces" + " but provides no home; EJB 2.1 view cannot be realized");
        }
    }

    protected void validateHomeReturnsNoBusinessInterfaces(Class<?> home) {
        Method[] all;
        if (home == null) {
            return;
        }
        assert (EJBHome.class.isAssignableFrom(home) || EJBLocalHome.class.isAssignableFrom(home)) : "Specified home interface, " + home.getName() + ", must be of type " + EJBHome.class.getName() + " or " + EJBLocalHome.class.getName();
        assert (home.isInterface()) : "Specified home interface, " + home.getName() + " is not an interface.";
        HashSet<Method> creates = new HashSet<Method>();
        for (Method method : all = home.getDeclaredMethods()) {
            if (!method.getName().startsWith(METHOD_PREFIX_EJB21_CREATE)) continue;
            creates.add(method);
        }
        for (Method create : creates) {
            boolean isLocal = true;
            if (EJBHome.class.isAssignableFrom(home)) {
                isLocal = false;
            }
            if (isLocal) {
                if (EJBLocalObject.class.isAssignableFrom(create.getReturnType())) continue;
                throw new RuntimeException("EJB 3 Core Specification Section 4.6.10: The return type for a create<METHOD> method must be the session bean's local interface type.  " + home.getName() + " has method " + create.getName() + " which returns " + create.getReturnType().getName() + ". [EJBTHREE-1059]");
            }
            if (EJBObject.class.isAssignableFrom(create.getReturnType())) continue;
            throw new RuntimeException("EJB 3 Core Specification Section 4.6.8: The return type for a create<METHOD> method must be the session bean\u2019s remote interface type.  " + home.getName() + " has method " + create.getName() + " which returns " + create.getReturnType().getName() + ". [EJBTHREE-1059]");
        }
    }

    protected void validateEjb21Views(Class<?> home, Class<?>[] localOrRemoteInterfaces) throws RuntimeException {
        this.validateCompleteEjb21View(home, localOrRemoteInterfaces);
        this.validateHomeReturnsNoBusinessInterfaces(home);
    }

    protected abstract void validateEjb21Views();
}

