/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity.hibernate;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.persistence.EntityManager;
import org.hibernate.Session;
import org.hibernate.ejb.HibernateEntityManager;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;

public class TransactionScopedSessionInvocationHandler
implements InvocationHandler,
Externalizable {
    private static final long serialVersionUID = -5788395417446868080L;
    private transient ManagedEntityManagerFactory factory;

    public TransactionScopedSessionInvocationHandler(ManagedEntityManagerFactory factory) {
        if (factory == null) {
            throw new NullPointerException("factory must not be null");
        }
        this.factory = factory;
    }

    public TransactionScopedSessionInvocationHandler() {
    }

    protected Session getHibernateSession() {
        if (this.getSession() instanceof HibernateEntityManager) {
            return ((HibernateEntityManager)this.getSession()).getSession();
        }
        throw new RuntimeException("ILLEGAL ACTION: Not a Hibernate persistence provider");
    }

    protected EntityManager getSession() {
        return this.factory.getTransactionScopedEntityManager();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.factory.getKernelName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String kernelName = in.readUTF();
        PersistenceUnitDeployment deployment = PersistenceUnitRegistry.getPersistenceUnit((String)kernelName);
        if (deployment == null) {
            throw new IOException("Unable to find persistence unit in registry: " + kernelName);
        }
        this.factory = deployment.getManagedFactory();
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("close".equals(method.getName())) {
            throw new IllegalStateException("Illegal to call this method from injected, managed EntityManager");
        }
        try {
            return method.invoke((Object)this.getHibernateSession(), args);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            throw e;
        }
    }
}

