/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.loading;

import org.jboss.logging.Logger;
import org.jboss.remoting.serialization.ClassLoaderUtility;

public class RemotingClassLoader
extends ClassLoader {
    private ClassLoader userClassLoader = null;
    private int referenceCounter;
    protected static final Logger log = Logger.getLogger((Class)RemotingClassLoader.class);
    protected static final boolean isTrace = log.isTraceEnabled();

    public RemotingClassLoader(ClassLoader remotingClassLoader, ClassLoader userClassLoader) {
        super(remotingClassLoader);
        this.userClassLoader = userClassLoader;
        this.referenceCounter = 1;
    }

    public synchronized void setUserClassLoader(ClassLoader userClassLoader) throws Exception {
        if (this.userClassLoader == null) {
            this.userClassLoader = userClassLoader;
        } else if (this.userClassLoader != userClassLoader) {
            throw new Exception("Attempting to change existing userClassLoader");
        }
        ++this.referenceCounter;
    }

    public synchronized void unsetUserClassLoader() {
        if (--this.referenceCounter == 0) {
            this.userClassLoader = null;
        }
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        Class<?> loadedClass;
        block6: {
            loadedClass = null;
            try {
                loadedClass = Class.forName(name, false, this.getParent());
            }
            catch (ClassNotFoundException e) {
                if (isTrace) {
                    log.trace((Object)("Could not load class (" + name + ") using parent remoting class loader (" + this.getParent() + ")"));
                }
                if (this.userClassLoader == null) break block6;
                try {
                    loadedClass = Class.forName(name, false, this.userClassLoader);
                }
                catch (ClassNotFoundException e1) {
                    if (!isTrace) break block6;
                    log.trace((Object)("Could not load class (" + name + ") using parent remoting class loader (" + this.getParent() + ")"));
                }
            }
        }
        if (loadedClass == null) {
            loadedClass = ClassLoaderUtility.loadClass(name, this.getClass());
        }
        return loadedClass;
    }
}

