/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.annotations;

import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import org.jboss.deployers.plugins.annotations.WeakClassLoaderHolder;
import org.jboss.deployers.spi.annotations.Element;
import org.jboss.metadata.spi.signature.ConstructorParametersSignature;
import org.jboss.metadata.spi.signature.ConstructorSignature;
import org.jboss.metadata.spi.signature.FieldSignature;
import org.jboss.metadata.spi.signature.MethodParametersSignature;
import org.jboss.metadata.spi.signature.MethodSignature;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultElement<A extends Annotation, M extends AccessibleObject>
extends WeakClassLoaderHolder
implements Element<A, M> {
    protected String className;
    protected Signature signature;
    protected Class<A> annClass;
    protected Class<M> aoClass;
    private SoftReference<Class<?>> classRef;

    public DefaultElement(ClassLoader classLoader, String className, Signature signature, Class<A> annClass, Class<M> aoClass) {
        super(classLoader);
        if (className == null) {
            throw new IllegalArgumentException("Null className");
        }
        if (signature == null) {
            throw new IllegalArgumentException("Null signature");
        }
        if (annClass == null) {
            throw new IllegalArgumentException("Null annotation class");
        }
        if (aoClass == null) {
            throw new IllegalArgumentException("Null ao class");
        }
        this.className = className;
        this.signature = signature;
        this.annClass = annClass;
        this.aoClass = aoClass;
    }

    public Class<?> getOwner() {
        Class<?> clazz;
        if (this.classRef != null && (clazz = this.classRef.get()) != null) {
            return clazz;
        }
        clazz = this.loadClass(this.className);
        this.classRef = new SoftReference(clazz);
        return clazz;
    }

    public A getAnnotation() {
        M accessibleObject = this.getAccessibleObject();
        return ((AccessibleObject)accessibleObject).getAnnotation(this.annClass);
    }

    public M getAccessibleObject() {
        AccessibleObject result = null;
        Class<?> clazz = this.getOwner();
        if (this.signature instanceof ConstructorSignature || this.signature instanceof ConstructorParametersSignature) {
            try {
                result = clazz.getConstructor(this.signature.getParametersTypes(clazz));
            }
            catch (NoSuchMethodException ignored) {}
        } else if (this.signature instanceof MethodSignature || this.signature instanceof MethodParametersSignature) {
            try {
                result = clazz.getMethod(this.signature.getName(), this.signature.getParametersTypes(clazz));
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        } else if (this.signature instanceof FieldSignature) {
            result = ReflectionUtils.findField(clazz, (String)this.signature.getName());
        }
        if (result == null) {
            throw new IllegalArgumentException("Expected accessible object " + this.className + "." + this.signature);
        }
        if (!this.aoClass.isInstance(result)) {
            throw new IllegalArgumentException("Expected accessible object " + this.className + "." + this.signature + " of type " + this.aoClass);
        }
        return (M)((AccessibleObject)this.aoClass.cast(result));
    }
}

