/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut.ast;

import java.io.StringReader;
import org.jboss.aop.pointcut.ast.ASTAll;
import org.jboss.aop.pointcut.ast.ASTAllParameter;
import org.jboss.aop.pointcut.ast.ASTAnd;
import org.jboss.aop.pointcut.ast.ASTAndCFlow;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTBoolean;
import org.jboss.aop.pointcut.ast.ASTCFlow;
import org.jboss.aop.pointcut.ast.ASTCFlowBoolean;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ASTCall;
import org.jboss.aop.pointcut.ast.ASTComposite;
import org.jboss.aop.pointcut.ast.ASTCompositeCFlow;
import org.jboss.aop.pointcut.ast.ASTConstruction;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTException;
import org.jboss.aop.pointcut.ast.ASTExecution;
import org.jboss.aop.pointcut.ast.ASTExecutionOnly;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTFieldExecution;
import org.jboss.aop.pointcut.ast.ASTGet;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTNot;
import org.jboss.aop.pointcut.ast.ASTNotCFlow;
import org.jboss.aop.pointcut.ast.ASTOr;
import org.jboss.aop.pointcut.ast.ASTOrCFlow;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ASTPointcut;
import org.jboss.aop.pointcut.ast.ASTSet;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTSub;
import org.jboss.aop.pointcut.ast.ASTSubCFlow;
import org.jboss.aop.pointcut.ast.ASTWithin;
import org.jboss.aop.pointcut.ast.ASTWithincode;
import org.jboss.aop.pointcut.ast.PointcutExpressionParser;
import org.jboss.aop.pointcut.ast.PointcutExpressionParserVisitor;
import org.jboss.aop.pointcut.ast.SimpleNode;

public class PointcutParserTester
implements PointcutExpressionParserVisitor {
    private int indent = 0;

    private String indentString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    public Object visit(SimpleNode node, Object data) {
        System.out.println(this.indentString() + node + ": acceptor not unimplemented in subclass?");
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTStart node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTHas node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTHasField node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTExecutionOnly node, Object data) {
        return null;
    }

    public Object visit(ASTBoolean node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTField node, Object data) {
        System.out.print(this.indentString());
        if (node.attributes != null) {
            for (int i = 0; i < node.attributes.size(); ++i) {
                ASTAttribute attr = (ASTAttribute)node.attributes.get(i);
                System.out.print(attr.attribute + " ");
            }
        }
        System.out.print(node.getTypeExpression() + " ");
        System.out.println(node.getClassExpr() + "." + node.getFieldExpr());
        return data;
    }

    public Object visit(ASTMethod node, Object data) {
        int i;
        System.out.print(this.indentString());
        System.out.print(node.getReturnTypeExpression() + " ");
        if (node.attributes != null) {
            for (i = 0; i < node.attributes.size(); ++i) {
                ASTAttribute attr = (ASTAttribute)node.attributes.get(i);
                System.out.print(attr.attribute + " ");
            }
        }
        System.out.print(node.getClassExpr() + "." + node.getMethodExpr() + "(");
        if (node.parameters != null && !node.isAnyParameters()) {
            for (i = 0; i < node.parameters.size(); ++i) {
                if (i > 0) {
                    System.out.print(", ");
                }
                System.out.print(node.parameters.get(i));
            }
        } else if (node.isAnyParameters()) {
            System.out.print("..");
        }
        System.out.println(")");
        return data;
    }

    public Object visit(ASTConstructor node, Object data) {
        int i;
        System.out.print(this.indentString());
        if (node.attributes != null) {
            for (i = 0; i < node.attributes.size(); ++i) {
                ASTAttribute attr = (ASTAttribute)node.attributes.get(i);
                System.out.print(attr.attribute + " ");
            }
        }
        System.out.print(node.getClassExpr() + "(");
        if (node.parameters != null && !node.isAnyParameters()) {
            for (i = 0; i < node.parameters.size(); ++i) {
                if (i > 0) {
                    System.out.print(", ");
                }
                System.out.print(node.parameters.get(i));
            }
        } else if (node.isAnyParameters()) {
            System.out.print("..");
        }
        System.out.println(")");
        return data;
    }

    public Object visit(ASTParameter node, Object data) {
        return null;
    }

    public Object visit(ASTComposite node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTCFlowExpression node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTCFlow node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTSub node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTAnd node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTOr node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTNot node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTNotCFlow node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTCFlowBoolean node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTCompositeCFlow node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTOrCFlow node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTAndCFlow node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTSubCFlow node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTAll node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        System.out.println(this.indentString() + node.getClasseExpression());
        --this.indent;
        return data;
    }

    public Object visit(ASTFieldExecution node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTCall node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.getBehavior().jjtAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTExecution node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTConstruction node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTGet node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTSet node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTPointcut node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTWithin node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTWithincode node, Object data) {
        System.out.println(this.indentString() + node);
        ++this.indent;
        data = node.childrenAccept(this, data);
        --this.indent;
        return data;
    }

    public Object visit(ASTAttribute node, Object data) {
        return null;
    }

    public Object visit(ASTException node, Object data) {
        return null;
    }

    public Object visit(ASTAllParameter node, Object data) {
        return null;
    }

    public static void main(String[] args) {
        args = new String[]{"execution(* $instanceof{com.blah.Test}->$implements{@IF}(..) throws Exception)"};
        System.out.println("----" + args[0]);
        StringReader reader = new StringReader(args[0]);
        PointcutExpressionParser t = new PointcutExpressionParser(reader);
        try {
            ASTStart n = t.Start();
            PointcutParserTester v = new PointcutParserTester();
            n.jjtAccept(v, null);
        }
        catch (Exception e) {
            System.out.println("Oops.");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

