/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.CallerConstructorInfo;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.ConstructorCallByMethod;
import org.jboss.aop.joinpoint.ConstructorCalledByMethodJoinpoint;
import org.jboss.aop.joinpoint.Joinpoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConByMethodInfo
extends CallerConstructorInfo
implements ConstructorCallByMethod {
    private final long callingMethodHash;
    private final Method callingMethod;

    public ConByMethodInfo(Advisor advisor, Class<?> calledClass, Method callingMethod, long callingMethodHash, Constructor<?> c, long calledConHash, Method wrappingMethod, Interceptor[] in) {
        super(advisor, calledClass, c, calledConHash, wrappingMethod, in, callingMethod.getDeclaringClass());
        this.callingMethodHash = callingMethodHash;
        this.callingMethod = callingMethod;
    }

    protected ConByMethodInfo(ConByMethodInfo other) {
        super(other);
        this.callingMethodHash = other.callingMethodHash;
        this.callingMethod = other.callingMethod;
    }

    @Override
    protected Joinpoint internalGetJoinpoint() {
        return new ConstructorCalledByMethodJoinpoint(this.callingMethod, this.getConstructor());
    }

    @Override
    public JoinPointInfo copy() {
        return new ConByMethodInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Constructor called by Method");
        sb.append("[");
        sb.append("calling=" + this.callingMethod);
        sb.append(",called=" + this.getConstructor());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public long getCallingMethodHash() {
        return this.callingMethodHash;
    }

    @Override
    public Method getCallingMethod() {
        return this.callingMethod;
    }
}

