/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.net.Socket;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.util.threadpool.Consumer;
import org.omg.ETF.Connection;

public class MessageReceptor
implements Consumer {
    private final Logger logger;
    private final boolean enhanceThreadName;

    public MessageReceptor(Configuration configuration) {
        this.logger = configuration.getNamedLogger("jacorb.orb.giop");
        this.enhanceThreadName = configuration.getAttributeAsBoolean("jacorb.enhanced_thread_name", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWork(Object object) {
        try {
            String string;
            GIOPConnection gIOPConnection = (GIOPConnection)object;
            if (this.enhanceThreadName) {
                string = Thread.currentThread().getName();
                Connection connection = gIOPConnection.getTransport();
                String string2 = this.getEnhancedName(connection, string);
                Thread.currentThread().setName(string2);
            } else {
                string = null;
            }
            try {
                gIOPConnection.receiveMessages();
            }
            finally {
                if (this.enhanceThreadName) {
                    Thread.currentThread().setName(string);
                }
            }
        }
        catch (Exception exception) {
            this.logger.error("unexpected exception during doWork", (Throwable)exception);
        }
    }

    private String getEnhancedName(Connection connection, String string) {
        if (connection instanceof ServerIIOPConnection) {
            Socket socket = ((ServerIIOPConnection)connection).getSocket();
            int n = socket.getLocalPort();
            int n2 = socket.getPort();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append('[');
            stringBuffer.append(n);
            stringBuffer.append(socket.getInetAddress().toString());
            stringBuffer.append(':');
            stringBuffer.append(n2);
            stringBuffer.append("] [");
            stringBuffer.append(System.currentTimeMillis());
            stringBuffer.append(']');
            return stringBuffer.toString();
        }
        return string;
    }
}

