/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateful;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.dgc.VMID;
import javax.ejb.EJBLocalObject;
import javax.ejb.LocalHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.SpecificationInterfaceType;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.stateful.BaseStatefulProxyFactory;
import org.jboss.ejb3.proxy.handler.stateful.StatefulLocalHomeProxyInvocationHandler;
import org.jboss.ejb3.proxy.handler.stateful.StatefulLocalProxyInvocationHandler;
import org.jboss.ejb3.session.ProxyAccessType;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.proxy.ejb.handle.StatefulHandleImpl;
import org.jboss.util.NotImplementedException;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulLocalProxyFactory
extends BaseStatefulProxyFactory {
    private VMID vmid = Ejb3Registry.getVMID();

    public StatefulLocalProxyFactory() {
    }

    public StatefulLocalProxyFactory(SessionSpecContainer container, LocalBinding binding) {
        super(container, binding.jndiBinding());
    }

    @Override
    protected Class<?> getHomeType() {
        return ProxyFactoryHelper.getLocalHomeInterface(this.getContainer());
    }

    @Override
    protected ProxyAccessType getProxyAccessType() {
        return ProxyAccessType.LOCAL;
    }

    @Override
    protected void validateEjb21Views() {
        SessionSpecContainer container = this.getContainer();
        LocalHome localHome = container.getAnnotation(LocalHome.class);
        this.validateEjb21Views(localHome == null ? null : localHome.value(), ProxyFactoryHelper.getLocalInterfaces(container));
    }

    @Override
    protected boolean bindHomeAndBusinessTogether() {
        return ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()).equals(this.jndiName);
    }

    @Override
    public void start() throws Exception {
        super.start();
        try {
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"), (Object)this);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful local proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        SessionSpecContainer statefulContainer = this.getContainer();
        LocalHome localHome = this.getContainer().getAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether()) {
            Class[] interfaces = new Class[]{localHome.value()};
            Object homeProxy = Proxy.newProxyInstance(statefulContainer.getBeanClass().getClassLoader(), interfaces, (InvocationHandler)new StatefulLocalHomeProxyInvocationHandler(statefulContainer));
            Util.rebind((Context)statefulContainer.getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(statefulContainer), (Object)homeProxy);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"));
        SessionSpecContainer statefulContainer = this.getContainer();
        LocalHome localHome = this.getContainer().getAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether()) {
            Util.unbind((Context)statefulContainer.getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(statefulContainer));
        }
    }

    @Override
    public Object createProxyBusiness() {
        SessionSpecContainer sfsb = this.getContainer();
        Object id = sfsb.createSession();
        return this.createProxyBusiness(id);
    }

    public EJBLocalObject createProxyEjb21(String businessInterfaceType) {
        Object id = this.getContainer().createSession();
        return this.createProxyEjb21(id, businessInterfaceType);
    }

    @Override
    public Object createProxyBusiness(String businessInterfaceType) {
        return this.createProxyBusiness(null, businessInterfaceType);
    }

    public Object createProxyBusiness(Object id) {
        return this.createProxyBusiness(id, null);
    }

    public Object createProxyBusiness(Object id, String businessInterfaceType) {
        return this.createProxy(id, SpecificationInterfaceType.EJB30_BUSINESS, businessInterfaceType);
    }

    public <T extends EJBLocalObject> T createProxyEjb21(Object id, String businessInterfaceType) {
        return (T)((EJBLocalObject)this.createProxy(id, SpecificationInterfaceType.EJB21, null));
    }

    private Object createProxy(Object id, SpecificationInterfaceType type, String businessInterfaceType) {
        StatefulLocalProxyInvocationHandler proxy = new StatefulLocalProxyInvocationHandler(this.getContainer(), id, this.vmid, businessInterfaceType);
        return type.equals((Object)SpecificationInterfaceType.EJB30_BUSINESS) ? this.constructProxyBusiness(proxy) : this.constructEjb21Proxy(proxy);
    }

    public Object createProxy(Class<?>[] initTypes, Object[] initValues) {
        SessionSpecContainer sfsb = this.getContainer();
        Object id = sfsb.createSession(initTypes, initValues);
        return this.createProxy(id, SpecificationInterfaceType.EJB30_BUSINESS, null);
    }

    public Object createProxyEjb21(Class<?>[] initTypes, Object[] initValues, String businessInterfaceType) {
        SessionSpecContainer sfsb = this.getContainer();
        Object id = sfsb.createSession(initTypes, initValues);
        return this.createProxyEjb21(id, businessInterfaceType);
    }

    protected StatefulHandleImpl createHandle() {
        throw new NotImplementedException("NYI");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.vmid = (VMID)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.vmid);
    }
}

