/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.session;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.LocalHome;
import javax.ejb.RemoteHome;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.Domain;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aspects.asynch.FutureHolder;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.EJBContainerInvocation;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.ThreadLocalStack;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.annotation.RemoteBindings;
import org.jboss.ejb3.proxy.ProxyFactory;
import org.jboss.ejb3.proxy.ProxyUtils;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactory;
import org.jboss.ejb3.proxy.factory.SessionProxyFactory;
import org.jboss.ejb3.session.ClassProxyHack;
import org.jboss.ejb3.session.ProxyDeployer;
import org.jboss.ejb3.stateful.StatefulContainerInvocation;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.serial.io.MarshalledObjectForLocalCalls;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SessionContainer
extends EJBContainer {
    private static final Logger log = Logger.getLogger(SessionContainer.class);
    protected ProxyDeployer proxyDeployer;
    private Map<String, HATarget> clusterFamilies;
    protected ThreadLocalStack<InvokedMethod> invokedMethod = new ThreadLocalStack();

    @Deprecated
    protected RemoteBinding getRemoteBinding() {
        RemoteBinding binding = null;
        RemoteBindings bindings = this.getAnnotation(RemoteBindings.class);
        binding = bindings != null ? bindings.value()[0] : this.getAnnotation(RemoteBinding.class);
        return binding;
    }

    public SessionContainer(ClassLoader cl, String beanClassName, String ejbName, Domain domain, Hashtable ctxProperties, Ejb3Deployment deployment, JBossSessionBeanMetaData beanMetaData) throws ClassNotFoundException {
        super("jboss.j2ee:service=EJB3,name=" + ejbName, domain, cl, beanClassName, ejbName, ctxProperties, deployment, (JBossEnterpriseBeanMetaData)beanMetaData);
        this.proxyDeployer = new ProxyDeployer(this);
    }

    protected abstract ProxyFactory getProxyFactory(LocalBinding var1);

    protected abstract RemoteProxyFactory getProxyFactory(RemoteBinding var1);

    public abstract InvocationResponse dynamicInvoke(Object var1, Invocation var2) throws Throwable;

    public Class<?> getInvokedBusinessInterface() {
        Class<?>[] remoteInterfaces;
        InvokedMethod method = this.invokedMethod.get();
        if (method == null) {
            throw new IllegalStateException("getInvokedBusinessInterface() being invoked outside of a business invocation");
        }
        if (method.method == null) {
            throw new IllegalStateException("getInvokedBusinessInterface() being invoked outside of a business invocation");
        }
        if (method.isLocalInterface) {
            return method.method.getDeclaringClass();
        }
        for (Class<?> intf : remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this)) {
            try {
                intf.getMethod(method.method.getName(), method.method.getParameterTypes());
                return intf;
            }
            catch (NoSuchMethodException ignored) {
            }
        }
        throw new IllegalStateException("Unable to find geInvokedBusinessInterface()");
    }

    protected JBossSessionBeanMetaData getMetaData() {
        return (JBossSessionBeanMetaData)this.getXml();
    }

    @Override
    public void instantiated() {
        super.instantiated();
        this.proxyDeployer.initializeRemoteBindingMetadata();
        this.proxyDeployer.initializeLocalBindingMetadata();
    }

    @Override
    protected List<Class<?>> resolveBusinessInterfaces() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(ProxyFactoryHelper.getLocalBusinessInterfaces(this)));
        list.addAll(Arrays.asList(ProxyFactoryHelper.getRemoteBusinessInterfaces(this)));
        return list;
    }

    @Override
    public void start() throws Exception {
        super.start();
        Dispatcher.singleton.registerTarget((Object)this.getObjectName().getCanonicalName(), (Object)new ClassProxyHack(this));
        this.proxyDeployer.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, HATarget> getClusterFamilies() {
        if (this.clusterFamilies != null) {
            return this.clusterFamilies;
        }
        SessionContainer sessionContainer = this;
        synchronized (sessionContainer) {
            if (this.clusterFamilies == null) {
                this.clusterFamilies = new HashMap<String, HATarget>();
            }
        }
        return this.clusterFamilies;
    }

    @Override
    public void stop() throws Exception {
        try {
            this.proxyDeployer.stop();
        }
        catch (Exception ignore) {
            log.debug((Object)"Proxy deployer stop failed", (Throwable)ignore);
        }
        try {
            Dispatcher.singleton.unregisterTarget((Object)this.getObjectName().getCanonicalName());
        }
        catch (Exception ignore) {
            log.debug((Object)"Dispatcher unregister target failed", (Throwable)ignore);
        }
        super.stop();
    }

    @Override
    public List<Method> getVirtualMethods() {
        ArrayList<Method> virtualMethods = new ArrayList<Method>();
        try {
            LocalHome localHome;
            RemoteHome home = this.getAnnotation(RemoteHome.class);
            if (home != null) {
                Method[] declaredMethods;
                for (Method declaredMethod : declaredMethods = home.value().getMethods()) {
                    virtualMethods.add(declaredMethod);
                }
                for (Method declaredMethod : declaredMethods = EJBObject.class.getMethods()) {
                    virtualMethods.add(declaredMethod);
                }
            }
            if ((localHome = this.getAnnotation(LocalHome.class)) != null) {
                Method[] declaredMethods;
                for (Method declaredMethod : declaredMethods = localHome.value().getMethods()) {
                    virtualMethods.add(declaredMethod);
                }
                for (Method declaredMethod : declaredMethods = EJBLocalObject.class.getMethods()) {
                    virtualMethods.add(declaredMethod);
                }
            }
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        return virtualMethods;
    }

    protected boolean isHomeMethod(Method method) {
        if (EJBHome.class.isAssignableFrom(method.getDeclaringClass())) {
            return true;
        }
        return EJBLocalHome.class.isAssignableFrom(method.getDeclaringClass());
    }

    protected boolean isEJBObjectMethod(Method method) {
        if (method.getDeclaringClass().getName().equals(EJBObject.class.getName())) {
            return true;
        }
        return method.getDeclaringClass().getName().equals(EJBLocalObject.class.getName());
    }

    protected boolean isHandleMethod(Method method) {
        return method.getDeclaringClass().getName().equals(Handle.class.getName());
    }

    public static InvocationResponse marshallException(Invocation invocation, Throwable exception, Map responseContext) throws Throwable {
        if (invocation.getMetaData((Object)"IS_LOCAL", (Object)"IS_LOCAL") == null) {
            throw exception;
        }
        InvocationResponse response = new InvocationResponse();
        response.setContextInfo(responseContext);
        response.addAttachment((Object)"IS_LOCAL_EXCEPTION", (Object)new MarshalledObjectForLocalCalls((Object)exception));
        return response;
    }

    public static InvocationResponse marshallResponse(Invocation invocation, Object rtn, Map responseContext) throws IOException {
        InvocationResponse response = rtn != null && invocation.getMetaData((Object)"IS_LOCAL", (Object)"IS_LOCAL") != null ? new InvocationResponse((Object)new MarshalledObjectForLocalCalls(rtn)) : new InvocationResponse(rtn);
        response.setContextInfo(responseContext);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(SessionProxyFactory factory, Object id, Method method, Object[] args, FutureHolder provider) throws Throwable {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        this.pushEnc();
        try {
            Object object;
            long hash = MethodHashing.calculateHash((Method)method);
            MethodInfo info = this.getAdvisor().getMethodInfo(hash);
            if (info == null) {
                throw new RuntimeException("Could not resolve beanClass method from proxy call: " + method.toString());
            }
            Method unadvisedMethod = info.getUnadvisedMethod();
            if (unadvisedMethod != null && this.isHomeMethod(unadvisedMethod)) {
                Object object2 = this.invokeHomeMethod(factory, info, args);
                return object2;
            }
            if (unadvisedMethod != null && this.isEJBObjectMethod(unadvisedMethod)) {
                Object object3 = this.invokeEJBObjectMethod(factory, id, info, args);
                return object3;
            }
            EJBContainerInvocation nextInvocation = new StatefulContainerInvocation(info, id);
            nextInvocation.setAdvisor(this.getAdvisor());
            nextInvocation.setArguments(args);
            nextInvocation = this.populateInvocation(nextInvocation);
            ProxyUtils.addLocalAsynchronousInfo((MethodInvocation)nextInvocation, provider);
            try {
                this.invokedMethod.push(new InvokedMethod(true, method));
                object = nextInvocation.invokeNext();
                this.invokedMethod.pop();
            }
            catch (Throwable throwable) {
                this.invokedMethod.pop();
                throw throwable;
            }
            return object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
            this.popEnc();
        }
    }

    private Object invokeHomeMethod(SessionProxyFactory factory, MethodInfo info, Object[] args) throws Exception {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().equals("create")) {
            return this.invokeHomeCreate(factory, unadvisedMethod, args);
        }
        if (unadvisedMethod.getName().equals("remove")) {
            if (args[0] instanceof Handle) {
                this.removeHandle((Handle)args[0]);
            } else {
                this.destroySession(args[0]);
            }
            return null;
        }
        throw new IllegalArgumentException("illegal home method " + unadvisedMethod);
    }

    protected abstract Object invokeHomeCreate(SessionProxyFactory var1, Method var2, Object[] var3) throws Exception;

    public abstract Object createSession(Class<?>[] var1, Object[] var2);

    public abstract Object localInvoke(Object var1, Method var2, Object[] var3, FutureHolder var4) throws Throwable;

    public abstract Object localHomeInvoke(Method var1, Object[] var2) throws Throwable;

    public Object createSession() {
        return this.createSession(new Class[0], new Object[0]);
    }

    protected void destroySession(Object id) {
        throw new RuntimeException("NYI");
    }

    @Override
    public boolean hasJNDIBinding(String jndiName) {
        return this.proxyDeployer.hasJNDIBinding(jndiName);
    }

    protected Object invokeEJBObjectMethod(ProxyFactory factory, Object id, MethodInfo info, Object[] args) throws Exception {
        Method unadvisedMethod = info.getUnadvisedMethod();
        if (unadvisedMethod.getName().equals("getEJBHome")) {
            return factory.createHomeProxy();
        }
        if (unadvisedMethod.getName().equals("getPrimaryKey")) {
            return id;
        }
        if (unadvisedMethod.getName().equals("isIdentical")) {
            if (id == null) {
                return false;
            }
            EJBObject bean = (EJBObject)args[0];
            Object primaryKey = bean.getPrimaryKey();
            if (primaryKey == null) {
                return false;
            }
            boolean isIdentical = id.equals(primaryKey);
            return isIdentical;
        }
        if (unadvisedMethod.getName().equals("remove")) {
            this.destroySession(id);
            return null;
        }
        throw new RuntimeException("NYI");
    }

    protected EJBContainerInvocation populateInvocation(EJBContainerInvocation invocation) {
        return invocation;
    }

    protected abstract void removeHandle(Handle var1) throws Exception;

    public class InvokedMethod {
        public boolean isLocalInterface;
        public Method method;

        public InvokedMethod(boolean localInterface, Method method) {
            this.isLocalInterface = localInterface;
            this.method = method;
        }
    }
}

