/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.handler.stateful;

import java.lang.reflect.Method;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.metadata.MetaDataResolver;
import org.jboss.aop.util.MethodHashing;
import org.jboss.aop.util.PayloadKey;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.proxy.ProxyUtils;
import org.jboss.ejb3.proxy.handler.BaseSessionRemoteProxyInvocationHandler;
import org.jboss.ejb3.stateful.StatefulHandleRemoteImpl;
import org.jboss.ejb3.stateful.StatefulRemoteInvocation;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;

public class StatefulHomeRemoteProxyInvocationHandler
extends BaseSessionRemoteProxyInvocationHandler {
    private static final long serialVersionUID = 5509794838403316545L;
    private static final Logger log = Logger.getLogger(StatefulHomeRemoteProxyInvocationHandler.class);
    protected InvokerLocator uri;
    private HomeHandle homeHandle;
    private EJBMetaData ejbMetaData;

    public StatefulHomeRemoteProxyInvocationHandler(Container container, Interceptor[] interceptors, InvokerLocator uri) {
        super(container, interceptors, null);
        this.uri = uri;
    }

    public StatefulHomeRemoteProxyInvocationHandler(Container container, Interceptor[] interceptors, InvokerLocator uri, Object id) {
        super(container, interceptors, null);
        this.uri = uri;
        this.id = id;
    }

    protected StatefulHomeRemoteProxyInvocationHandler() {
    }

    public void setHandle(StatefulHandleRemoteImpl handle) {
        this.handle = handle;
    }

    public void setHomeHandle(HomeHandle homeHandle) {
        this.homeHandle = homeHandle;
    }

    public void setEjbMetaData(EJBMetaData ejbMetaData) {
        this.ejbMetaData = ejbMetaData;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        long hash = MethodHashing.calculateHash((Method)method);
        Object ret = ProxyUtils.handleCallLocally(hash, proxy, this, method, args);
        if (ret != null) {
            return ret;
        }
        ret = this.handleEjb21CallLocally(method, args);
        if (ret != null) {
            return ret;
        }
        StatefulRemoteInvocation sri = new StatefulRemoteInvocation(this.interceptors, hash, method, method, null, null);
        sri.setArguments(args);
        sri.setInstanceResolver((MetaDataResolver)this.metadata);
        sri.getMetaData().addMetaData((Object)"DISPATCHER", (Object)"OID", (Object)this.containerId, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"REMOTING", (Object)"INVOKER_LOCATOR", (Object)this.uri, PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"REMOTING", (Object)"SUBSYSTEM", (Object)"AOP", PayloadKey.AS_IS);
        sri.getMetaData().addMetaData((Object)"IS_LOCAL", (Object)"GUID", (Object)this.containerGuid, PayloadKey.AS_IS);
        return sri.invokeNext();
    }

    public Object getAsynchronousProxy(Object proxy) {
        throw new RuntimeException("NOT IMPLEMENTED");
    }

    public String toString() {
        return this.containerId.toString() + ":Home";
    }

    private Object handleEjb21CallLocally(Method method, Object[] args) {
        if (method.equals(ProxyUtils.GET_HOME_HANDLE)) {
            return this.homeHandle;
        }
        if (method.equals(ProxyUtils.GET_EJB_METADATA)) {
            return this.ejbMetaData;
        }
        return null;
    }
}

