/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.ejb.RemoteHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactory;
import org.jboss.ejb3.proxy.factory.stateless.BaseStatelessRemoteProxyFactory;
import org.jboss.ejb3.proxy.handler.stateless.StatelessRemoteProxyInvocationHandler;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessRemoteProxyFactory
extends BaseStatelessRemoteProxyFactory
implements RemoteProxyFactory {
    private static final Logger log = Logger.getLogger(StatelessRemoteProxyFactory.class);
    private static final String STACK_NAME_STATELESS_SESSION_CLIENT_INTERCEPTORS = "StatelessSessionClientInterceptors";

    public StatelessRemoteProxyFactory(SessionSpecContainer container, RemoteBinding binding) {
        super(container, binding);
    }

    @Override
    protected boolean bindHomeAndBusinessTogether() {
        SessionSpecContainer container = this.getContainer();
        return ProxyFactoryHelper.getHomeJndiName(container).equals(ProxyFactoryHelper.getRemoteBusinessJndiName(container));
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    @Override
    public void start() throws Exception {
        super.start();
        RemoteHome remoteHome = this.getContainer().getAnnotation(RemoteHome.class);
        if (remoteHome != null && !this.bindHomeAndEjb21ViewTogether(this.getContainer())) {
            Object homeProxy = this.createHomeProxy(remoteHome.value());
            String jndiName = ProxyFactoryHelper.getHomeJndiName(this.getContainer());
            try {
                log.debug((Object)("Binding proxy for " + this.getContainer().getEjbName() + " in JNDI at " + jndiName));
                Util.rebind((Context)this.getContainer().getInitialContext(), (String)jndiName, (Object)homeProxy);
            }
            catch (NamingException e) {
                NamingException namingException = new NamingException("Could not bind stateless home proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + jndiName);
                namingException.setRootCause(e);
                throw namingException;
            }
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        SessionSpecContainer statelessContainer = this.getContainer();
        RemoteHome remoteHome = this.getContainer().getAnnotation(RemoteHome.class);
        if (remoteHome != null && !this.bindHomeAndEjb21ViewTogether(statelessContainer)) {
            Util.unbind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getHomeJndiName(this.getContainer()));
        }
    }

    public Object createHomeProxy(Class<?> homeInterface) {
        try {
            String stackName = this.getStackNameInterceptors();
            RemoteBinding binding = this.getBinding();
            InvokerLocator locator = this.getLocator();
            if (binding.interceptorStack() != null && !binding.interceptorStack().equals("")) {
                stackName = binding.interceptorStack();
            }
            AdviceStack stack = AspectManager.instance().getAdviceStack(stackName);
            StatelessRemoteProxyInvocationHandler proxy = new StatelessRemoteProxyInvocationHandler(this.getContainer(), stack.createInterceptors(this.getContainer().getAdvisor(), null), locator, null);
            this.setEjb21Objects(proxy);
            Class[] interfaces = new Class[]{homeInterface};
            return Proxy.newProxyInstance(this.getContainer().getBeanClass().getClassLoader(), interfaces, (InvocationHandler)proxy);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Class<?> getHomeType() {
        return ProxyFactoryHelper.getRemoteHomeInterface(this.getContainer());
    }

    @Override
    String getStackNameInterceptors() {
        return STACK_NAME_STATELESS_SESSION_CLIENT_INTERCEPTORS;
    }
}

