/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.stateless;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.ejb.EJBLocalObject;
import javax.ejb.LocalHome;
import javax.naming.Context;
import org.jboss.ejb3.SpecificationInterfaceType;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.stateless.BaseStatelessProxyFactory;
import org.jboss.ejb3.proxy.handler.stateless.StatelessLocalProxyInvocationHandler;
import org.jboss.ejb3.session.ProxyAccessType;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.ejb3.stateless.StatelessHandleRemoteImpl;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatelessLocalProxyFactory
extends BaseStatelessProxyFactory {
    private static final Logger log = Logger.getLogger(StatelessLocalProxyFactory.class);

    public StatelessLocalProxyFactory(SessionSpecContainer container, LocalBinding binding) {
        super(container, binding.jndiBinding());
    }

    @Override
    protected Class<?> getHomeType() {
        return ProxyFactoryHelper.getLocalHomeInterface(this.getContainer());
    }

    @Override
    protected ProxyAccessType getProxyAccessType() {
        return ProxyAccessType.LOCAL;
    }

    @Override
    protected void validateEjb21Views() {
        SessionSpecContainer container = this.getContainer();
        LocalHome localHome = container.getAnnotation(LocalHome.class);
        this.validateEjb21Views(localHome == null ? null : localHome.value(), ProxyFactoryHelper.getLocalInterfaces(container));
    }

    @Override
    protected boolean bindHomeAndBusinessTogether() {
        return ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()).equals(this.jndiName);
    }

    @Override
    public void start() throws Exception {
        super.start();
        SessionSpecContainer statelessContainer = this.getContainer();
        LocalHome localHome = statelessContainer.getAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether()) {
            Class[] interfaces = new Class[]{localHome.value()};
            Object homeProxy = Proxy.newProxyInstance(this.getContainer().getBeanClass().getClassLoader(), interfaces, (InvocationHandler)new StatelessLocalProxyInvocationHandler(this.getContainer(), null));
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()), (Object)homeProxy);
        }
    }

    @Override
    public void stop() throws Exception {
        super.stop();
        SessionSpecContainer statelessContainer = this.getContainer();
        LocalHome localHome = statelessContainer.getAnnotation(LocalHome.class);
        if (localHome != null && !this.bindHomeAndBusinessTogether()) {
            Util.unbind((Context)this.getContainer().getInitialContext(), (String)ProxyFactoryHelper.getLocalHomeJndiName(this.getContainer()));
        }
    }

    @Override
    public Object createProxyBusiness() {
        return this.createProxyBusiness(null);
    }

    @Override
    public Object createProxyBusiness(String businessInterfaceType) {
        return this.constructProxyBusiness(new StatelessLocalProxyInvocationHandler(this.getContainer(), businessInterfaceType));
    }

    public <T extends EJBLocalObject> T createProxyEjb21(String businessInterfaceType) {
        return (T)((EJBLocalObject)this.createProxy(SpecificationInterfaceType.EJB21, businessInterfaceType));
    }

    private Object createProxy(SpecificationInterfaceType type, String businessInterfaceType) {
        StatelessLocalProxyInvocationHandler proxy = new StatelessLocalProxyInvocationHandler(this.getContainer(), businessInterfaceType);
        return type.equals((Object)SpecificationInterfaceType.EJB30_BUSINESS) ? this.constructProxyBusiness(proxy) : this.constructEjb21Proxy(proxy);
    }

    @Override
    protected StatelessHandleRemoteImpl createHandle() {
        return null;
    }
}

