/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.stateful;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.RemoteHome;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.aop.AspectManager;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.AdviceStack;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aspects.remoting.ClusterChooserInterceptor;
import org.jboss.aspects.remoting.ClusteredPojiProxy;
import org.jboss.aspects.remoting.FamilyWrapper;
import org.jboss.aspects.remoting.InvokeRemoteInterceptor;
import org.jboss.ejb3.SpecificationInterfaceType;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.proxy.ProxyFactory;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactory;
import org.jboss.ejb3.proxy.factory.RemoteProxyFactoryRegistry;
import org.jboss.ejb3.proxy.factory.stateful.BaseStatefulRemoteProxyFactory;
import org.jboss.ejb3.proxy.handler.stateful.StatefulClusteredInvocationHandler;
import org.jboss.ejb3.remoting.ClusteredIsLocalInterceptor;
import org.jboss.ejb3.remoting.LoadBalancePolicyNotRegisteredException;
import org.jboss.ejb3.session.ProxyAccessType;
import org.jboss.ejb3.session.SessionSpecContainer;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.ha.client.loadbalance.RoundRobin;
import org.jboss.ha.client.loadbalance.aop.FirstAvailable;
import org.jboss.ha.framework.interfaces.ClusteringTargetsRepository;
import org.jboss.ha.framework.interfaces.DistributedReplicantManager;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.HAPartitionLocator;
import org.jboss.ha.framework.server.HATarget;
import org.jboss.logging.Logger;
import org.jboss.remoting.InvokerLocator;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatefulClusterProxyFactory
extends BaseStatefulRemoteProxyFactory
implements RemoteProxyFactory,
DistributedReplicantManager.ReplicantListener {
    private static final Logger log = Logger.getLogger(StatefulClusterProxyFactory.class);
    private static String STACK_NAME_CLUSTERED_STATEFUL_SESSION_CLIENT_INTERCEPTORS = "ClusteredStatefulSessionClientInterceptors";
    private Clustered clustered;
    private DistributedReplicantManager drm;
    private HATarget hatarget;
    private String proxyFamilyName;
    private String partitionName;
    private HAPartition partition;
    private LoadBalancePolicy lbPolicy;
    private FamilyWrapper wrapper;

    public StatefulClusterProxyFactory(SessionSpecContainer container, RemoteBinding binding, Clustered clustered) {
        super(container, binding);
        assert (clustered != null) : "clustered is null";
        this.clustered = clustered;
    }

    @Override
    protected Class<?> getHomeType() {
        return null;
    }

    @Override
    protected ProxyAccessType getProxyAccessType() {
        return ProxyAccessType.REMOTE;
    }

    @Override
    protected boolean bindHomeAndBusinessTogether() {
        return false;
    }

    @Override
    protected void validateEjb21Views() {
        SessionSpecContainer container = this.getContainer();
        RemoteHome remoteHome = container.getAnnotation(RemoteHome.class);
        this.validateEjb21Views(remoteHome == null ? null : remoteHome.value(), ProxyFactoryHelper.getRemoteInterfaces(container));
    }

    @Override
    public void start() throws Exception {
        this.init();
        InvokerLocator locator = this.getLocator();
        SessionSpecContainer container = this.getContainer();
        this.partitionName = container.getPartitionName();
        this.proxyFamilyName = container.getDeploymentQualifiedName() + locator.getProtocol() + this.partitionName;
        this.partition = HAPartitionLocator.getHAPartitionLocator().getHAPartition(this.partitionName, container.getInitialContextProperties());
        this.drm = this.partition.getDistributedReplicantManager();
        this.hatarget = new HATarget(this.partition, this.proxyFamilyName, (Serializable)locator, 2);
        ClusteringTargetsRepository.initTarget((String)this.proxyFamilyName, (List)this.hatarget.getReplicants());
        container.getClusterFamilies().put(this.proxyFamilyName, this.hatarget);
        if (this.clustered.loadBalancePolicy() == null || this.clustered.loadBalancePolicy().equals("LoadBalancePolicy")) {
            this.lbPolicy = new FirstAvailable();
        } else {
            String policyClass = this.clustered.loadBalancePolicy();
            try {
                RemoteProxyFactoryRegistry registry = container.getDeployment().getRemoteProxyFactoryRegistry();
                Class<LoadBalancePolicy> policy = registry.getLoadBalancePolicy(policyClass);
                policyClass = policy.getName();
            }
            catch (LoadBalancePolicyNotRegisteredException e) {
                // empty catch block
            }
            this.lbPolicy = (LoadBalancePolicy)Thread.currentThread().getContextClassLoader().loadClass(policyClass).newInstance();
        }
        this.wrapper = new FamilyWrapper(this.proxyFamilyName, (List)this.hatarget.getReplicants());
        this.drm.registerListener(this.proxyFamilyName, (DistributedReplicantManager.ReplicantListener)this);
        super.start();
        RoundRobin factoryLBP = null;
        if (this.clustered.homeLoadBalancePolicy() == null || this.clustered.homeLoadBalancePolicy().equals("LoadBalancePolicy")) {
            factoryLBP = new RoundRobin();
        } else {
            String policyClass = this.clustered.homeLoadBalancePolicy();
            try {
                RemoteProxyFactoryRegistry registry = container.getDeployment().getRemoteProxyFactoryRegistry();
                Class<LoadBalancePolicy> policy = registry.getLoadBalancePolicy(policyClass);
                policyClass = policy.getName();
            }
            catch (LoadBalancePolicyNotRegisteredException e) {
                // empty catch block
            }
            factoryLBP = (LoadBalancePolicy)Thread.currentThread().getContextClassLoader().loadClass(policyClass).newInstance();
        }
        Class[] interfaces = new Class[]{ProxyFactory.class};
        String targetId = this.getTargetId();
        Interceptor[] interceptors = new Interceptor[]{new ClusteredIsLocalInterceptor(), new ClusterChooserInterceptor(), InvokeRemoteInterceptor.singleton};
        ClusteredPojiProxy proxy = new ClusteredPojiProxy((Object)targetId, locator, interceptors, this.wrapper, (LoadBalancePolicy)factoryLBP, this.partitionName, null);
        Object factoryProxy = Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (InvocationHandler)proxy);
        try {
            Util.rebind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"), (Object)factoryProxy);
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind stateful cluster proxy with ejb name " + this.getContainer().getEjbName() + " into JNDI under jndiName: " + this.getContainer().getInitialContext().getNameInNamespace() + "/" + this.jndiName + "StatefulProxyFactory");
            namingException.setRootCause(e);
            throw namingException;
        }
        assert (!Dispatcher.singleton.isRegistered((Object)targetId)) : targetId + " is already registered";
        Dispatcher.singleton.registerTarget((Object)targetId, (Object)this);
    }

    @Override
    String getStackNameInterceptors() {
        return STACK_NAME_CLUSTERED_STATEFUL_SESSION_CLIENT_INTERCEPTORS;
    }

    @Override
    protected Object createProxy(Object id, SpecificationInterfaceType type, String businessInterfaceType) {
        AdviceStack stack;
        String stackName = this.getStackNameInterceptors();
        RemoteBinding binding = this.getBinding();
        if (binding.interceptorStack() != null && !binding.interceptorStack().trim().equals("")) {
            stackName = binding.interceptorStack();
        }
        if ((stack = AspectManager.instance().getAdviceStack(stackName)) == null) {
            throw new RuntimeException("unable to find interceptor stack: " + stackName);
        }
        StatefulClusteredInvocationHandler handler = new StatefulClusteredInvocationHandler(this.getContainer(), stack.createInterceptors(this.getContainer().getAdvisor(), null), this.wrapper, this.lbPolicy, this.partitionName, this.getLocator(), id, businessInterfaceType);
        if (type.equals((Object)SpecificationInterfaceType.EJB21)) {
            return this.constructEjb21Proxy(handler);
        }
        return this.constructProxyBusiness(handler);
    }

    @Override
    public void stop() throws Exception {
        Dispatcher.singleton.unregisterTarget((Object)this.getTargetId());
        this.hatarget.destroy();
        this.drm.unregisterListener(this.proxyFamilyName, (DistributedReplicantManager.ReplicantListener)this);
        this.getContainer().getClusterFamilies().remove(this.proxyFamilyName);
        Util.unbind((Context)this.getContainer().getInitialContext(), (String)(this.jndiName + "StatefulProxyFactory"));
        super.stop();
    }

    protected String getTargetId() {
        assert (this.jndiName != null) : "jndiName is null";
        String partition = this.getContainer().getPartitionName();
        return this.jndiName + "StatefulProxyFactory" + "@" + partition;
    }

    public synchronized void replicantsChanged(String key, List newReplicants, int newReplicantsViewId, boolean merge) {
        try {
            ArrayList targets = new ArrayList(newReplicants);
            this.wrapper.get().updateClusterInfo(targets, (long)newReplicantsViewId);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }
}

