/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.factory.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.ejb3.proxy.ProxyFactory;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.util.naming.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseServiceProxyFactory
implements ProxyFactory {
    protected Constructor<?> proxyConstructor;
    protected String jndiName;
    protected ServiceContainer container;

    protected BaseServiceProxyFactory(ServiceContainer container, String jndiName) {
        assert (container != null) : "container is null";
        assert (jndiName != null) : "jndiName is null";
        this.container = container;
        this.jndiName = jndiName;
    }

    @Override
    public Object createHomeProxy() {
        throw new UnsupportedOperationException("service can't have a home interface");
    }

    public Object createProxyBusiness(Object id) {
        if (id != null) {
            throw new IllegalArgumentException("service proxy must not have an id");
        }
        return this.createProxyBusiness();
    }

    @Override
    public void start() throws Exception {
        Class<?>[] interfaces = this.getInterfaces();
        Class<?> proxyClass = Proxy.getProxyClass(this.container.getBeanClass().getClassLoader(), interfaces);
        this.proxyConstructor = proxyClass.getConstructor(InvocationHandler.class);
        try {
            Util.rebind((Context)this.container.getInitialContext(), (String)this.jndiName, (Object)this.createProxyBusiness());
        }
        catch (NamingException e) {
            NamingException namingException = new NamingException("Could not bind service proxy factory for EJB container with ejb name " + this.container.getEjbName() + " into JNDI under jndiName: " + this.container.getInitialContext().getNameInNamespace() + "/" + this.jndiName);
            namingException.setRootCause(e);
            throw namingException;
        }
    }

    @Override
    public void stop() throws Exception {
        Util.unbind((Context)this.container.getInitialContext(), (String)this.jndiName);
    }

    protected abstract Class<?>[] getInterfaces();

    protected final void initializeJndiName() {
    }
}

