/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.mdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.jboss.aop.Domain;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.annotation.DefaultActivationSpecs;
import org.jboss.ejb3.mdb.MessagingContainer;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.mx.util.ObjectNameConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MDB
extends MessagingContainer {
    protected static final String DEFAULT_DESTINATION_TYPE = "javax.jms.Topic";
    protected Class<?> messagingType = null;

    public MDB(String ejbName, Domain domain, ClassLoader cl, String beanClassName, Hashtable ctxProperties, Ejb3Deployment deployment, JBossMessageDrivenBeanMetaData beanMetaData) throws ClassNotFoundException {
        super(ejbName, domain, cl, beanClassName, ctxProperties, deployment, (JBossEnterpriseBeanMetaData)beanMetaData);
    }

    @Override
    public Class<?> getMessagingType() {
        if (this.messagingType == null) {
            MessageDriven annotation = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
            this.messagingType = annotation.messageListenerInterface();
            if (this.messagingType.getName().equals(Object.class.getName())) {
                Set<Class<?>> businessInterfaces = ProxyFactoryHelper.getBusinessInterfaces(this.getBeanClass(), false);
                if (businessInterfaces.size() > 1 || businessInterfaces.size() == 0) {
                    throw new RuntimeException("Unable to choose messagingType interface for MDB " + this.getEjbName() + " from " + businessInterfaces);
                }
                this.messagingType = businessInterfaces.iterator().next();
            }
        }
        return this.messagingType;
    }

    public Map getActivationConfigProperties() {
        HashMap<String, ActivationConfigPropertyMetaData> result = new HashMap<String, ActivationConfigPropertyMetaData>();
        MessageDriven mdAnnotation = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
        for (ActivationConfigProperty property : mdAnnotation.activationConfig()) {
            this.addActivationSpecProperty(result, property);
        }
        DefaultActivationSpecs defaultSpecsAnnotation = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecsAnnotation != null) {
            for (ActivationConfigProperty property : defaultSpecsAnnotation.value()) {
                this.addActivationSpecProperty(result, property);
            }
        }
        return result;
    }

    protected JBossMessageDrivenBeanMetaData getMetaData() {
        return (JBossMessageDrivenBeanMetaData)super.getMetaData();
    }

    @Override
    protected NamedMethodMetaData getTimeoutMethodMetaData() {
        JBossMessageDrivenBeanMetaData metaData = this.getMetaData();
        if (metaData != null) {
            return metaData.getTimeoutMethod();
        }
        return null;
    }

    @Override
    protected List<Class<?>> resolveBusinessInterfaces() {
        ArrayList list = new ArrayList();
        list.add(this.getMessagingType());
        return list;
    }

    @Override
    public void start() throws Exception {
        super.start();
    }

    @Override
    public ObjectName getJmxName() {
        ObjectName jmxName = null;
        String jndiName = ProxyFactoryHelper.getLocalJndiName(this);
        String name = "jboss.j2ee:service=EJB,jndiName=" + jndiName;
        try {
            jmxName = ObjectNameConverter.convert((String)name);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to create ObjectName, msg=" + e.getMessage());
        }
        return jmxName;
    }

    @Override
    protected void populateActivationSpec() {
        DefaultActivationSpecs defaultSpecs = (DefaultActivationSpecs)this.resolveAnnotation(DefaultActivationSpecs.class);
        if (defaultSpecs != null) {
            this.activationSpec.merge(defaultSpecs.value());
        }
        MessageDriven md = (MessageDriven)this.resolveAnnotation(MessageDriven.class);
        this.activationSpec.merge(md.activationConfig());
    }
}

