/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.Properties;
import org.hibernate.cache.Cache;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CacheProvider;
import org.jboss.ejb3.entity.TransactionalCacheFactory;
import org.jboss.logging.Logger;

public class TreeCacheProviderHook
implements CacheProvider {
    public static final String HIBERNATE_CACHE_CONFIG_NAME_PROPERTY = "hibernate.cache.jbc2.config.name";
    public static final String HIBERNATE_CACHE_OBJECT_NAME_PROPERTY = "hibernate.treecache.mbean.object_name";
    public static final String DEFAULT_MBEAN_OBJECT_NAME = "jboss.cache:service=EJB3EntityTreeCache";
    protected Logger log = Logger.getLogger(this.getClass());
    private TransactionalCacheFactory cacheFactory;

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        return this.cacheFactory.buildCache(regionName, properties);
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public void start(Properties properties) throws CacheException {
        this.cacheFactory = TransactionalCacheFactory.getFactory(properties);
        this.cacheFactory.start();
    }

    public void stop() {
        if (this.cacheFactory != null) {
            this.cacheFactory.stop();
        }
    }

    protected TransactionalCacheFactory getCacheFactory() {
        return this.cacheFactory;
    }
}

