/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.InitialContext;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import org.hibernate.ejb.HibernatePersistence;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.NonSerializableFactory;
import org.jboss.ejb3.entity.InjectedEntityManagerFactory;
import org.jboss.ejb3.entity.ManagedEntityManagerFactory;
import org.jboss.ejb3.entity.PersistenceUnitInfoImpl;
import org.jboss.ejb3.entity.TransactionScopedEntityManager;
import org.jboss.ejb3.javaee.AbstractJavaEEComponent;
import org.jboss.ejb3.javaee.SimpleJavaEEModule;
import org.jboss.logging.Logger;
import org.jboss.metadata.jpa.spec.PersistenceUnitMetaData;
import org.jboss.metadata.jpa.spec.TransactionType;
import org.jboss.virtual.VFSUtils;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUnitDeployment
extends AbstractJavaEEComponent {
    private static final Logger log = Logger.getLogger(PersistenceUnitDeployment.class);
    protected InitialContext initialContext;
    protected DeploymentUnit di;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected ManagedEntityManagerFactory managedFactory;
    protected EntityManagerFactory actualFactory;
    protected PersistenceUnitMetaData metaData;
    protected String kernelName;
    protected Ejb3Deployment deployment;
    protected boolean scoped;

    public PersistenceUnitDeployment(InitialContext initialContext, Ejb3Deployment deployment, List<String> explicitEntityClasses, PersistenceUnitMetaData metadata, String ear, String jar, boolean isScoped) {
        super(new SimpleJavaEEModule(deployment.getEar() != null ? deployment.getEar().getShortName() : null, deployment.getDeploymentUnit().getShortName()));
        this.scoped = isScoped;
        this.deployment = deployment;
        this.initialContext = initialContext;
        this.di = deployment.getDeploymentUnit();
        this.explicitEntityClasses = explicitEntityClasses;
        this.metaData = metadata;
        this.kernelName = "persistence.units:";
        String name = this.getEntityManagerName();
        if (name == null || name.length() == 0) {
            throw new RuntimeException("Null string is not allowed for a persistence unit name.  Fix your persistence.xml file");
        }
        if (ear != null) {
            this.kernelName = this.kernelName + "ear=" + ear;
            if (!ear.endsWith(".ear")) {
                this.kernelName = this.kernelName + ".ear";
            }
            this.kernelName = this.kernelName + ",";
        }
        if (isScoped) {
            this.kernelName = this.kernelName + "jar=" + jar;
            if (!jar.endsWith(".jar")) {
                this.kernelName = this.kernelName + ".jar";
            }
            this.kernelName = this.kernelName + ",";
        }
        this.kernelName = this.kernelName + "unitName=" + name;
    }

    public static String getDefaultKernelName(String unitName) {
        int hashIndex = unitName.indexOf(35);
        if (hashIndex != -1) {
            String relativePath = unitName.substring(3, hashIndex);
            String name = unitName.substring(hashIndex + 1);
            return "persistence.units:jar=" + relativePath + "," + "unitName=" + name;
        }
        return "persistence.units:unitName=" + unitName;
    }

    public boolean isScoped() {
        return this.scoped;
    }

    public Ejb3Deployment getDeployment() {
        return this.deployment;
    }

    protected String getJaccContextId() {
        return this.di.getShortName();
    }

    public EntityManagerFactory getActualFactory() {
        return this.actualFactory;
    }

    public PersistenceUnitMetaData getXml() {
        return this.metaData;
    }

    public String getKernelName() {
        return this.kernelName;
    }

    public String getEntityManagerName() {
        return this.metaData.getName();
    }

    public ManagedEntityManagerFactory getManagedFactory() {
        if (this.managedFactory == null) {
            log.warn((Object)("managed factory is null, persistence unit " + this.kernelName + " has not yet been started"));
        }
        return this.managedFactory;
    }

    protected Map<String, String> getProperties() {
        Map<String, String> properties = this.metaData.getProperties();
        return properties != null ? properties : Collections.emptyMap();
    }

    public void addDependencies(DependencyPolicy policy) {
        Map<String, String> props = this.getProperties();
        if (!props.containsKey("jboss.no.implicit.datasource.dependency")) {
            String ds;
            if (this.metaData.getJtaDataSource() != null) {
                ds = this.metaData.getJtaDataSource();
                policy.addDatasource(ds);
            }
            if (this.metaData.getNonJtaDataSource() != null) {
                ds = this.metaData.getNonJtaDataSource();
                policy.addDatasource(ds);
            }
        }
        for (String prop : props.keySet()) {
            String property = prop;
            if (!property.startsWith("jboss.depends")) continue;
            policy.addDependency(props.get(property));
        }
    }

    protected PersistenceUnitTransactionType getJPATransactionType() {
        TransactionType type = this.metaData.getTransactionType();
        if (type == TransactionType.RESOURCE_LOCAL) {
            return PersistenceUnitTransactionType.RESOURCE_LOCAL;
        }
        return PersistenceUnitTransactionType.JTA;
    }

    private List<String> safeList(Set<String> set) {
        return set == null || set.isEmpty() ? Collections.emptyList() : new ArrayList<String>(set);
    }

    public void start() throws Exception {
        String entityManagerFactoryJndiName;
        String urlString;
        log.info((Object)("Starting persistence unit " + this.kernelName));
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.di.getDefaultPersistenceProperties());
        props.put("hibernate.jacc.ctx.id", this.getJaccContextId());
        PersistenceUnitInfoImpl pi = new PersistenceUnitInfoImpl();
        log.debug((Object)("Using class loader " + this.di.getClassLoader()));
        pi.setClassLoader(this.di.getClassLoader());
        ArrayList<URL> jarFiles = new ArrayList<URL>();
        pi.setJarFiles(jarFiles);
        pi.setPersistenceProviderClassName(HibernatePersistence.class.getName());
        log.debug((Object)"Found persistence.xml file in EJB3 jar");
        props.putAll(this.getProperties());
        pi.setManagedClassnames(this.safeList(this.metaData.getClasses()));
        pi.setPersistenceUnitName(this.metaData.getName());
        pi.setMappingFileNames(this.safeList(this.metaData.getMappingFiles()));
        pi.setExcludeUnlistedClasses(this.metaData.isExcludeUnlistedClasses());
        VirtualFile root = this.di.getRootFile();
        log.debug((Object)("Persistence root: " + root));
        URL url = root.toURL();
        if (!VFSUtils.isNestedFile((VirtualFile)root) && (urlString = url.toExternalForm()).startsWith("vfs")) {
            url = urlString.startsWith("vfszip") ? new URL("file" + urlString.substring(6)) : new URL(urlString.substring(3));
        }
        pi.setPersistenceUnitRootUrl(url);
        PersistenceUnitTransactionType transactionType = this.getJPATransactionType();
        pi.setTransactionType(transactionType);
        Set files = this.metaData.getJarFiles();
        if (files != null) {
            for (String jar : files) {
                jarFiles.add(this.deployment.getDeploymentUnit().getRelativeURL(jar));
            }
        }
        if (this.metaData.getProvider() != null) {
            pi.setPersistenceProviderClassName(this.metaData.getProvider());
        }
        if (this.explicitEntityClasses.size() > 0) {
            List<String> classes = pi.getManagedClassNames();
            if (classes == null) {
                classes = this.explicitEntityClasses;
            } else {
                classes.addAll(this.explicitEntityClasses);
            }
            pi.setManagedClassnames(classes);
        }
        if (this.metaData.getJtaDataSource() != null) {
            pi.setJtaDataSource((DataSource)this.initialContext.lookup(this.metaData.getJtaDataSource()));
        } else if (transactionType == PersistenceUnitTransactionType.JTA) {
            throw new RuntimeException("Specification violation [EJB3 JPA 6.2.1.2] - You have not defined a jta-data-source for a JTA enabled persistence context named: " + this.metaData.getName());
        }
        if (this.metaData.getNonJtaDataSource() != null) {
            pi.setNonJtaDataSource((DataSource)this.initialContext.lookup(this.metaData.getNonJtaDataSource()));
        } else if (transactionType == PersistenceUnitTransactionType.RESOURCE_LOCAL) {
            throw new RuntimeException("Specification violation [EJB3 JPA 6.2.1.2] - You have not defined a non-jta-data-source for a RESOURCE_LOCAL enabled persistence context named: " + this.metaData.getName());
        }
        pi.setProperties(props);
        if (pi.getPersistenceUnitName() == null) {
            throw new RuntimeException("you must specify a name in persistence.xml");
        }
        Class<?> providerClass = Thread.currentThread().getContextClassLoader().loadClass(pi.getPersistenceProviderClassName());
        if (!pi.getProperties().containsKey("hibernate.session_factory_name")) {
            pi.getProperties().put("hibernate.session_factory_name", this.kernelName);
        }
        PersistenceProvider pp = (PersistenceProvider)providerClass.newInstance();
        this.actualFactory = pp.createContainerEntityManagerFactory((PersistenceUnitInfo)pi, null);
        this.managedFactory = new ManagedEntityManagerFactory(this.actualFactory, this.kernelName);
        String entityManagerJndiName = (String)props.get("jboss.entity.manager.jndi.name");
        if (entityManagerJndiName != null) {
            TransactionScopedEntityManager injectedManager = new TransactionScopedEntityManager(this.managedFactory);
            NonSerializableFactory.rebind(this.initialContext, entityManagerJndiName, injectedManager);
        }
        if ((entityManagerFactoryJndiName = (String)props.get("jboss.entity.manager.factory.jndi.name")) != null) {
            InjectedEntityManagerFactory injectedFactory = new InjectedEntityManagerFactory(this.managedFactory);
            NonSerializableFactory.rebind(this.initialContext, entityManagerFactoryJndiName, injectedFactory);
        }
    }

    public void stop() throws Exception {
        String entityManagerFactoryJndiName;
        log.info((Object)("Stopping persistence unit " + this.kernelName));
        String entityManagerJndiName = this.getProperties().get("jboss.entity.manager.jndi.name");
        if (entityManagerJndiName != null) {
            NonSerializableFactory.unbind(this.initialContext, entityManagerJndiName);
        }
        if ((entityManagerFactoryJndiName = this.getProperties().get("jboss.entity.manager.factory.jndi.name")) != null) {
            NonSerializableFactory.unbind(this.initialContext, entityManagerFactoryJndiName);
        }
        this.managedFactory.destroy();
    }
}

