/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.entity;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.StandardQueryCache;
import org.hibernate.cache.UpdateTimestampsCache;
import org.hibernate.util.PropertiesHelper;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.config.Configuration;
import org.jboss.ejb3.entity.SecondLevelCacheUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JBCCacheBase {
    public static final String QUERY_CACHE_LOCAL_ONLY_PROP = "hibernate.cache.region.jbc2.query.localonly";
    protected static final String ITEM = "item";
    protected Cache<Object, Object> cache;
    protected final String regionName;
    protected final Fqn<String> regionFqn;
    protected final TransactionManager transactionManager;
    protected boolean localOnlyQueries;
    protected boolean forTimestamps;
    protected boolean forceAsync;
    protected Node<Object, Object> regionRoot;
    protected final Object regionRootMutex = new Object();

    public JBCCacheBase(Cache<Object, Object> cache, String regionName, String regionPrefix, TransactionManager transactionManager, Properties properties) throws CacheException {
        this.cache = cache;
        this.regionName = regionName;
        this.regionFqn = Fqn.fromString((String)SecondLevelCacheUtil.createRegionFqn(regionName, regionPrefix));
        this.transactionManager = transactionManager;
        this.forTimestamps = regionName.contains(UpdateTimestampsCache.class.getName());
        Configuration.CacheMode mode = cache.getConfiguration().getCacheMode();
        if (this.forTimestamps) {
            if (mode == Configuration.CacheMode.INVALIDATION_ASYNC || mode == Configuration.CacheMode.INVALIDATION_SYNC) {
                throw new IllegalStateException("Cache is configured for " + mode + "; not supported for a timestamps cache");
            }
            boolean bl = this.forceAsync = mode == Configuration.CacheMode.REPL_SYNC;
        }
        if (mode != Configuration.CacheMode.LOCAL) {
            this.localOnlyQueries = PropertiesHelper.getBoolean((String)QUERY_CACHE_LOCAL_ONLY_PROP, (Properties)properties, (boolean)false);
            this.localOnlyQueries = this.localOnlyQueries || StandardQueryCache.class.getName().equals(regionName);
        }
        this.activateLocalClusterNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateLocalClusterNode() {
        Transaction tx = this.suspend();
        try {
            Configuration cfg = this.cache.getConfiguration();
            if (cfg.isUseRegionBasedMarshalling()) {
                Region jbcRegion = this.cache.getRegion(this.regionFqn, true);
                boolean shared = SecondLevelCacheUtil.isSharedClassLoaderRegion(this.regionName);
                if (!shared) {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = this.getClass().getClassLoader();
                    }
                    jbcRegion.registerContextClassLoader(classLoader);
                }
                if (!jbcRegion.isActive()) {
                    boolean fetchState = cfg.isFetchInMemoryState();
                    try {
                        if (shared) {
                            cfg.setFetchInMemoryState(false);
                        }
                        jbcRegion.activate();
                    }
                    finally {
                        if (shared) {
                            cfg.setFetchInMemoryState(fetchState);
                        }
                    }
                }
            }
            this.regionRoot = this.createRegionRootNode();
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
        finally {
            this.resume(tx);
        }
    }

    protected abstract void establishRegionRootNode();

    protected abstract Node<Object, Object> createRegionRootNode();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureRegionRootExists() {
        if (this.regionRoot == null || !this.regionRoot.isValid()) {
            Object object = this.regionRootMutex;
            synchronized (object) {
                if (this.regionRoot != null && this.regionRoot.isValid()) {
                    return;
                }
                this.establishRegionRootNode();
            }
        }
        if (this.regionRoot != null && this.regionRoot.isValid() && !this.regionRoot.isResident()) {
            this.regionRoot.setResident(true);
        }
    }

    protected void resume(Transaction tx) {
        if (tx != null) {
            try {
                this.transactionManager.resume(tx);
            }
            catch (Exception e) {
                throw new CacheException("Could not resume transaction", (Throwable)e);
            }
        }
    }

    protected Transaction suspend() {
        Transaction tx = null;
        if (this.transactionManager != null) {
            try {
                tx = this.transactionManager.suspend();
            }
            catch (SystemException se) {
                throw new CacheException("Could not suspend transaction", (Throwable)se);
            }
        }
        return tx;
    }

    protected void inactivateCacheRegion() throws CacheException {
        Region region = this.cache.getRegion(this.regionFqn, false);
        if (region != null && region.isActive()) {
            try {
                region.deactivate();
                region.unregisterContextClassLoader();
            }
            catch (Exception e) {
                throw SecondLevelCacheUtil.convertToHibernateException(e);
            }
        }
    }

    public void lock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache" + this.regionName);
    }

    public void unlock(Object key) throws CacheException {
        throw new UnsupportedOperationException("TreeCache is a fully transactional cache: " + this.regionName);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public int getTimeout() {
        return 600;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public long getSizeInMemory() {
        return -1L;
    }

    public long getElementCountInMemory() {
        try {
            return this.getChildrenNames().size();
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    public long getElementCountOnDisk() {
        return 0L;
    }

    public Map<Object, Object> toMap() {
        try {
            HashMap<Object, Object> result = new HashMap<Object, Object>();
            for (Object key : this.getChildrenNames()) {
                result.put(key, this.cache.get(new Fqn(this.regionFqn, new Object[]{key}), (Object)ITEM));
            }
            return result;
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }

    private Set<Object> getChildrenNames() {
        try {
            return this.regionRoot == null ? new HashSet() : this.regionRoot.getChildrenNames();
        }
        catch (Exception e) {
            throw SecondLevelCacheUtil.convertToHibernateException(e);
        }
    }
}

