/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.tree;

import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.CacheManager;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.Region;
import org.jboss.cache.RegionNotEmptyException;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.eviction.LRUConfiguration;
import org.jboss.cache.notifications.annotation.CacheListener;
import org.jboss.cache.notifications.annotation.NodeActivated;
import org.jboss.cache.notifications.annotation.NodePassivated;
import org.jboss.cache.notifications.event.NodeActivatedEvent;
import org.jboss.cache.notifications.event.NodePassivatedEvent;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.CacheConfig;
import org.jboss.ejb3.cache.ClusteredStatefulCache;
import org.jboss.ejb3.cache.tree.AbortableLRUPolicy;
import org.jboss.ejb3.cache.tree.ContextInUseException;
import org.jboss.ejb3.stateful.NestedStatefulBeanContext;
import org.jboss.ejb3.stateful.ProxiedStatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.ha.framework.server.CacheManagerLocator;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

public class StatefulTreeCache
implements ClusteredStatefulCache {
    private static final int FQN_SIZE = 4;
    private static final String SFSB = "sfsb";
    private static final int DEFAULT_BUCKET_COUNT = 100;
    private static final String[] DEFAULT_HASH_BUCKETS = new String[100];
    private ThreadLocal<Boolean> localActivity = new ThreadLocal();
    private Logger log = Logger.getLogger(StatefulTreeCache.class);
    private WeakReference<ClassLoader> classloader;
    private Cache cache;
    private Fqn cacheNode;
    private Region region;
    private ClusteredStatefulCacheListener listener;
    public static long MarkInUseWaitTime;
    protected String[] hashBuckets = DEFAULT_HASH_BUCKETS;
    protected int createCount = 0;
    protected int passivatedCount = 0;
    protected int removeCount = 0;
    protected long removalTimeout = 0L;
    protected RemovalTimeoutTask removalTask = null;
    protected boolean running = true;
    protected Map<Object, Long> beans = new ConcurrentHashMap<Object, Long>();
    protected CacheConfig cacheConfig;
    protected CacheManager cacheManager;
    protected StatefulContainer ejbContainer;
    protected Object shutdownLock = new Object();

    public StatefulBeanContext create() {
        return this.create((Class[])null, (Object[])null);
    }

    public StatefulBeanContext create(Class[] initTypes, Object[] initValues) {
        Object ctx = null;
        try {
            ctx = this.ejbContainer.create(initTypes, initValues);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Caching context " + ((StatefulBeanContext)ctx).getId() + " of type " + ctx.getClass()));
            }
            this.putInCache((StatefulBeanContext)ctx);
            ((StatefulBeanContext)ctx).setInUse(true);
            ((StatefulBeanContext)ctx).lastUsed = System.currentTimeMillis();
            ++this.createCount;
            this.beans.put(((StatefulBeanContext)ctx).getId(), new Long(((StatefulBeanContext)ctx).lastUsed));
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException(e);
        }
        return ctx;
    }

    public StatefulBeanContext get(Object key) throws EJBException {
        return this.get(key, true);
    }

    public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException {
        StatefulBeanContext entry = null;
        Fqn id = this.getFqn(key, false);
        Boolean active = this.localActivity.get();
        try {
            try {
                this.localActivity.set(Boolean.TRUE);
                this.cache.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
                entry = (StatefulBeanContext)this.cache.get(id, (Object)"bean");
            }
            catch (CacheException e) {
                RuntimeException re = this.convertToRuntimeException(e);
                throw re;
            }
            Object var9_6 = null;
            this.localActivity.set(active);
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            this.localActivity.set(active);
            throw throwable;
        }
        if (entry == null) {
            throw new NoSuchEJBException("Could not find stateful bean: " + key);
        }
        if (markInUse && entry.isRemoved()) {
            throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed)");
        }
        entry.postReplicate();
        if (markInUse) {
            entry.setInUse(true);
            this.region.markNodeCurrentlyInUse(new Fqn(new Object[]{key.toString()}), MarkInUseWaitTime);
            entry.lastUsed = System.currentTimeMillis();
            this.beans.put(key, new Long(entry.lastUsed));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("get: retrieved bean with cache id " + id.toString()));
        }
        return entry;
    }

    public StatefulBeanContext peek(Object key) throws NoSuchEJBException {
        return this.get(key, false);
    }

    public void remove(Object key) {
        Fqn id = this.getFqn(key, false);
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("remove: cache id " + id.toString()));
            }
            this.cache.getInvocationContext().getOptionOverrides().setForceDataGravitation(true);
            StatefulBeanContext ctx = (StatefulBeanContext)this.cache.get(id, (Object)"bean");
            if (ctx == null) {
                throw new NoSuchEJBException("Could not find Stateful bean: " + key);
            }
            if (!ctx.isRemoved()) {
                this.ejbContainer.destroy(ctx);
            } else if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("remove: " + id.toString() + " already removed from pool"));
            }
            if (ctx.getCanRemoveFromCache()) {
                this.cache.removeNode(id);
            } else {
                this.putInCache(ctx);
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("remove: removed bean " + id.toString() + " cannot be removed from cache"));
                }
            }
            ++this.removeCount;
            this.beans.remove(key);
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.setInUse(false);
            ctx.lastUsed = System.currentTimeMillis();
            this.beans.put(ctx.getId(), new Long(ctx.lastUsed));
            this.region.unmarkNodeCurrentlyInUse(this.getFqn(ctx.getId(), true));
        }
    }

    public void replicate(StatefulBeanContext ctx) {
        if (ctx instanceof NestedStatefulBeanContext) {
            throw new IllegalArgumentException("Received unexpected replicate call for nested context " + ctx.getId());
        }
        try {
            this.putInCache(ctx);
        }
        catch (CacheException e) {
            RuntimeException re = this.convertToRuntimeException(e);
            throw re;
        }
    }

    public void initialize(EJBContainer container) throws Exception {
        this.ejbContainer = (StatefulContainer)container;
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.ejbContainer.getEjbName()));
        this.classloader = new WeakReference<ClassLoader>(this.ejbContainer.getClassloader());
        this.cacheConfig = this.ejbContainer.getAnnotation(CacheConfig.class);
        this.cacheManager = CacheManagerLocator.getCacheManagerLocator().getCacheManager(null);
        this.removalTimeout = this.cacheConfig.removalTimeoutSeconds();
        if (this.removalTimeout > 0L) {
            this.removalTask = new RemovalTimeoutTask("SFSB Removal Thread - " + this.ejbContainer.getObjectName().getCanonicalName());
        }
    }

    protected EvictionPolicyConfig getEvictionPolicyConfig() {
        LRUConfiguration epc = new LRUConfiguration();
        epc.setEvictionPolicyClass(AbortableLRUPolicy.class.getName());
        epc.setTimeToLiveSeconds((int)this.cacheConfig.idleTimeoutSeconds());
        epc.setMaxNodes(this.cacheConfig.maxSize());
        return epc;
    }

    public void start() {
        String name = this.cacheConfig.name();
        if (name == null || name.trim().length() == 0) {
            name = "jboss.cache:service=EJB3SFSBClusteredCache";
        }
        try {
            this.cache = this.cacheManager.getCache(name, true);
        }
        catch (CacheException ce) {
            throw this.convertToRuntimeException(ce);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e1) {
            throw new RuntimeException("Cannot get cache with name " + name, e1);
        }
        this.cacheNode = new Fqn(new Object[]{SFSB, this.ejbContainer.getDeploymentPropertyListString()});
        this.region = this.cache.getRegion(this.cacheNode, true);
        EvictionPolicyConfig epc = this.getEvictionPolicyConfig();
        this.region.setEvictionPolicy(epc);
        if (this.cache.getCacheStatus() != CacheStatus.STARTED) {
            if (this.cache.getCacheStatus() != CacheStatus.CREATED) {
                this.cache.create();
            }
            this.cache.start();
        }
        this.cleanBeanRegion();
        this.region.registerContextClassLoader((ClassLoader)this.classloader.get());
        try {
            this.region.activate();
        }
        catch (RegionNotEmptyException e) {
            this.cleanBeanRegion();
            this.region.activate();
        }
        Node regionRoot = this.cache.getNode(this.cacheNode);
        if (regionRoot == null) {
            regionRoot = this.cache.getRoot().addChild(this.cacheNode);
        }
        regionRoot.setResident(true);
        this.log.debug((Object)("started(): created region: " + this.region + " for ejb: " + this.ejbContainer.getEjbName()));
        this.listener = new ClusteredStatefulCacheListener();
        this.cache.addCacheListener((Object)this.listener);
        if (this.removalTask != null) {
            this.removalTask.start();
        }
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.running = false;
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.removalTask != null && this.removalTask.isAlive()) {
                this.removalTask.interrupt();
            }
        }
        if (this.cache != null) {
            if (this.listener != null) {
                this.cache.removeCacheListener((Object)this.listener);
            }
            this.cleanBeanRegion();
            if (this.region != null) {
                this.region.deactivate();
                this.region.unregisterContextClassLoader();
                this.cache.removeRegion(this.region.getFqn());
                this.region.resetEvictionQueues();
                this.region = null;
            }
        }
        this.classloader = null;
        String name = this.cacheConfig.name();
        if (name == null || name.trim().length() == 0) {
            name = "jboss.cache:service=EJB3SFSBClusteredCache";
        }
        this.cacheManager.releaseCache(name);
        this.log.debug((Object)("stop(): StatefulTreeCache stopped successfully for " + this.cacheNode));
    }

    public int getCacheSize() {
        int count = 0;
        try {
            Set children = null;
            for (int i = 0; i < this.hashBuckets.length; ++i) {
                Node node = this.cache.getRoot().getChild(new Fqn(this.cacheNode, new Object[]{this.hashBuckets[i]}));
                if (node == null) continue;
                children = node.getChildrenNames();
                count += children == null ? 0 : children.size();
            }
            count -= this.passivatedCount;
        }
        catch (CacheException e) {
            this.log.error((Object)"Caught exception calculating cache size", (Throwable)e);
            count = -1;
        }
        return count;
    }

    public int getTotalSize() {
        return this.beans.size();
    }

    public int getCreateCount() {
        return this.createCount;
    }

    public int getPassivatedCount() {
        return this.passivatedCount;
    }

    public int getRemoveCount() {
        return this.removeCount;
    }

    public int getAvailableCount() {
        return -1;
    }

    public int getMaxSize() {
        return -1;
    }

    public int getCurrentSize() {
        return this.getCacheSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putInCache(StatefulBeanContext ctx) {
        Boolean active = this.localActivity.get();
        try {
            this.localActivity.set(Boolean.TRUE);
            ctx.preReplicate();
            this.cache.put(this.getFqn(ctx.getId(), false), (Object)"bean", (Object)ctx);
            ctx.markedForReplication = false;
            Object var4_3 = null;
            this.localActivity.set(active);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.localActivity.set(active);
            throw throwable;
        }
    }

    private Fqn getFqn(Object id, boolean regionRelative) {
        String beanId = id.toString();
        int index = id instanceof GUID ? (id.hashCode() & Integer.MAX_VALUE) % this.hashBuckets.length : (beanId.hashCode() & Integer.MAX_VALUE) % this.hashBuckets.length;
        if (regionRelative) {
            return new Fqn(new Object[]{this.hashBuckets[index], beanId});
        }
        return new Fqn(this.cacheNode, new Object[]{this.hashBuckets[index], beanId});
    }

    private void cleanBeanRegion() {
        try {
            this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
            this.cache.removeNode(this.cacheNode);
        }
        catch (CacheException e) {
            this.log.error((Object)"Stop(): can't remove bean from the underlying distributed cache");
        }
    }

    private RuntimeException convertToRuntimeException(CacheException e) {
        RuntimeException re = new RuntimeException(((Object)((Object)e)).getClass().getName() + " " + e.getMessage());
        re.setStackTrace(e.getStackTrace());
        return re;
    }

    public boolean isStarted() {
        return this.running;
    }

    static {
        for (int i = 0; i < DEFAULT_HASH_BUCKETS.length; ++i) {
            StatefulTreeCache.DEFAULT_HASH_BUCKETS[i] = String.valueOf(i);
        }
        MarkInUseWaitTime = 15000L;
    }

    private class RemovalTimeoutTask
    extends Thread {
        public RemovalTimeoutTask(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (StatefulTreeCache.this.running) {
                try {
                    Thread.sleep(StatefulTreeCache.this.removalTimeout * 1000L);
                }
                catch (InterruptedException e) {
                    StatefulTreeCache.this.running = false;
                    return;
                }
                try {
                    long now = System.currentTimeMillis();
                    Iterator<Map.Entry<Object, Long>> it = StatefulTreeCache.this.beans.entrySet().iterator();
                    Object object = StatefulTreeCache.this.shutdownLock;
                    synchronized (object) {
                        while (StatefulTreeCache.this.running && it.hasNext()) {
                            Map.Entry<Object, Long> entry = it.next();
                            long lastUsed = entry.getValue();
                            if (now - lastUsed < StatefulTreeCache.this.removalTimeout * 1000L) continue;
                            StatefulTreeCache.this.remove(entry.getKey());
                        }
                    }
                }
                catch (Exception ex) {
                    StatefulTreeCache.this.log.error((Object)"problem removing SFSB thread", (Throwable)ex);
                }
            }
        }
    }

    @CacheListener
    public class ClusteredStatefulCacheListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NodeActivated
        public void nodeActivated(NodeActivatedEvent event) {
            if (event.isPre()) {
                return;
            }
            Map nodeData = event.getData();
            if (nodeData == null) {
                return;
            }
            Fqn fqn = event.getFqn();
            if (fqn.size() != 4) {
                return;
            }
            if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                return;
            }
            if (Boolean.TRUE != StatefulTreeCache.this.localActivity.get()) {
                --StatefulTreeCache.this.passivatedCount;
                return;
            }
            StatefulBeanContext bean = (StatefulBeanContext)nodeData.get("bean");
            if (bean == null) {
                throw new IllegalStateException("nodeLoaded(): null bean instance.");
            }
            --StatefulTreeCache.this.passivatedCount;
            if (StatefulTreeCache.this.log.isTraceEnabled()) {
                StatefulTreeCache.this.log.trace((Object)("nodeLoaded(): send postActivate event to bean at fqn: " + fqn));
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                bean.activateAfterReplication();
                Object var8_7 = null;
                Thread.currentThread().setContextClassLoader(oldCl);
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                Thread.currentThread().setContextClassLoader(oldCl);
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NodePassivated
        public void nodePassivated(NodePassivatedEvent event) {
            if (!event.isPre()) {
                return;
            }
            Fqn fqn = event.getFqn();
            if (fqn.size() != 4) {
                return;
            }
            if (!fqn.isChildOrEquals(StatefulTreeCache.this.cacheNode)) {
                return;
            }
            StatefulBeanContext bean = null;
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            Boolean active = (Boolean)StatefulTreeCache.this.localActivity.get();
            try {
                block16: {
                    try {
                        StatefulTreeCache.this.localActivity.set(Boolean.TRUE);
                        bean = (StatefulBeanContext)event.getData().get("bean");
                        if (bean == null) break block16;
                        ClassLoader cl = (ClassLoader)StatefulTreeCache.this.classloader.get();
                        if (cl != null) {
                            Thread.currentThread().setContextClassLoader(cl);
                        }
                        if (!bean.getCanPassivate()) {
                            throw new ContextInUseException("Cannot passivate bean " + fqn + " -- it or one if its children is currently in use");
                        }
                        if (StatefulTreeCache.this.log.isTraceEnabled()) {
                            StatefulTreeCache.this.log.trace((Object)("nodePassivated(): send prePassivate event to bean at fqn: " + fqn));
                        }
                        bean.passivateAfterReplication();
                        ++StatefulTreeCache.this.passivatedCount;
                    }
                    catch (NoSuchEJBException e) {
                        if (bean instanceof ProxiedStatefulBeanContext) {
                            try {
                                bean.getContainedIn();
                                throw e;
                            }
                            catch (NoSuchEJBException n) {
                                StatefulTreeCache.this.log.debug((Object)("nodePassivated(): removing orphaned proxy at " + fqn));
                                try {
                                    StatefulTreeCache.this.cache.removeNode(fqn);
                                }
                                catch (CacheException c) {
                                    StatefulTreeCache.this.log.error((Object)("nodePassivated(): could not remove orphaned proxy at " + fqn), (Throwable)c);
                                }
                            }
                        } else {
                            throw e;
                        }
                        Object var10_9 = null;
                        Thread.currentThread().setContextClassLoader(oldCl);
                        StatefulTreeCache.this.localActivity.set(active);
                    }
                }
                Object var10_8 = null;
                Thread.currentThread().setContextClassLoader(oldCl);
                StatefulTreeCache.this.localActivity.set(active);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                Thread.currentThread().setContextClassLoader(oldCl);
                StatefulTreeCache.this.localActivity.set(active);
                throw throwable;
            }
        }
    }
}

