/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.cache.simple;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.NoSuchEJBException;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.annotation.CacheConfig;
import org.jboss.ejb3.annotation.PersistenceManager;
import org.jboss.ejb3.cache.StatefulCache;
import org.jboss.ejb3.cache.simple.StatefulSessionPersistenceManager;
import org.jboss.ejb3.stateful.StatefulBeanContext;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStatefulCache
implements StatefulCache {
    private Logger log = Logger.getLogger(SimpleStatefulCache.class);
    private StatefulContainer container;
    private CacheMap cacheMap;
    private int maxSize = 1000;
    private StatefulSessionPersistenceManager pm;
    private long sessionTimeout = 300L;
    private long removalTimeout = 0L;
    private SessionTimeoutTask timeoutTask;
    private RemovalTimeoutTask removalTask = null;
    private boolean running = true;
    private int createCount = 0;
    private int passivatedCount = 0;
    private int removeCount = 0;

    @Override
    public void initialize(EJBContainer container) throws Exception {
        this.container = (StatefulContainer)container;
        Advisor advisor = container.getAdvisor();
        this.cacheMap = new CacheMap();
        PersistenceManager pmConfig = (PersistenceManager)advisor.resolveAnnotation(PersistenceManager.class);
        EJBContainer ejbContainer = container;
        this.pm = ejbContainer.getDeployment().getPersistenceManagerFactoryRegistry().getPersistenceManagerFactory(pmConfig.value()).createPersistenceManager();
        this.pm.initialize(container);
        CacheConfig config = (CacheConfig)advisor.resolveAnnotation(CacheConfig.class);
        this.maxSize = config.maxSize();
        this.sessionTimeout = config.idleTimeoutSeconds();
        this.removalTimeout = config.removalTimeoutSeconds();
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + container.getEjbName()));
        this.log.debug((Object)("Initializing SimpleStatefulCache with maxSize: " + this.maxSize + " timeout: " + this.sessionTimeout + " for " + container.getObjectName().getCanonicalName()));
        this.timeoutTask = new SessionTimeoutTask("SFSB Passivation Thread - " + container.getObjectName().getCanonicalName());
        if (this.removalTimeout > 0L) {
            this.removalTask = new RemovalTimeoutTask("SFSB Removal Thread - " + container.getObjectName().getCanonicalName());
        }
    }

    public void start() {
        this.running = true;
        this.timeoutTask.start();
        if (this.removalTask != null) {
            this.removalTask.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CacheMap cacheMap = this.cacheMap;
        synchronized (cacheMap) {
            this.running = false;
            this.timeoutTask.interrupt();
            if (this.removalTask != null) {
                this.removalTask.interrupt();
            }
            this.cacheMap.clear();
            try {
                this.pm.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void passivate(StatefulBeanContext ctx) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ctx.getContainer().getClassloader());
            this.pm.passivateSession(ctx);
            ++this.passivatedCount;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    public StatefulBeanContext create() {
        return this.create((Class[])null, (Object[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulBeanContext create(Class<?>[] initTypes, Object[] initValues) {
        Object ctx = null;
        try {
            ctx = this.container.create((Class[])initTypes, initValues);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Caching context " + ((StatefulBeanContext)ctx).getId() + " of type " + ctx.getClass()));
            }
            CacheMap cacheMap = this.cacheMap;
            synchronized (cacheMap) {
                this.cacheMap.put(((StatefulBeanContext)ctx).getId(), ctx);
            }
            ((StatefulBeanContext)ctx).setInUse(true);
            ((StatefulBeanContext)ctx).lastUsed = System.currentTimeMillis();
            ++this.createCount;
        }
        catch (EJBException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EJBException(e);
        }
        return ctx;
    }

    @Override
    public StatefulBeanContext get(Object key) throws EJBException {
        return this.get(key, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatefulBeanContext get(Object key, boolean markInUse) throws EJBException {
        StatefulBeanContext entry = null;
        CacheMap cacheMap = this.cacheMap;
        synchronized (cacheMap) {
            entry = (StatefulBeanContext)this.cacheMap.get(key);
        }
        if (entry == null) {
            entry = this.pm.activateSession(key);
            if (entry == null) {
                throw new NoSuchEJBException("Could not find stateful bean: " + key);
            }
            --this.passivatedCount;
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Caching activated context " + entry.getId() + " of type " + entry.getClass()));
            }
            cacheMap = this.cacheMap;
            synchronized (cacheMap) {
                this.cacheMap.put(key, entry);
            }
        }
        if (markInUse) {
            if (entry.isRemoved()) {
                throw new NoSuchEJBException("Could not find stateful bean: " + key + " (bean was marked as removed");
            }
            entry.setInUse(true);
            entry.lastUsed = System.currentTimeMillis();
        }
        return entry;
    }

    public StatefulBeanContext peek(Object key) throws NoSuchEJBException {
        return this.get(key, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(StatefulBeanContext ctx) {
        StatefulBeanContext statefulBeanContext = ctx;
        synchronized (statefulBeanContext) {
            ctx.setInUse(false);
            ctx.lastUsed = System.currentTimeMillis();
            if (ctx.markedForPassivation) {
                this.passivate(ctx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Removing context " + key));
        }
        StatefulBeanContext ctx = null;
        CacheMap cacheMap = this.cacheMap;
        synchronized (cacheMap) {
            ctx = (StatefulBeanContext)this.cacheMap.get(key);
        }
        if (ctx == null) {
            throw new NoSuchEJBException("Could not find Stateful bean: " + key);
        }
        if (!ctx.isRemoved()) {
            this.container.destroy(ctx);
        }
        ++this.removeCount;
        if (ctx.getCanRemoveFromCache()) {
            cacheMap = this.cacheMap;
            synchronized (cacheMap) {
                this.cacheMap.remove(key);
            }
        }
    }

    @Override
    public int getCacheSize() {
        return this.cacheMap.size();
    }

    @Override
    public int getTotalSize() {
        return this.getCacheSize() + this.getPassivatedCount();
    }

    @Override
    public int getCreateCount() {
        return this.createCount;
    }

    @Override
    public int getPassivatedCount() {
        return this.passivatedCount;
    }

    @Override
    public int getRemoveCount() {
        return this.removeCount;
    }

    @Override
    public int getAvailableCount() {
        return -1;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public int getCurrentSize() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }

    private class SessionTimeoutTask
    extends Thread {
        public SessionTimeoutTask(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (SimpleStatefulCache.this.running) {
                try {
                    Thread.sleep(SimpleStatefulCache.this.sessionTimeout * 1000L);
                }
                catch (InterruptedException e) {
                    SimpleStatefulCache.this.running = false;
                    return;
                }
                try {
                    CacheMap e = SimpleStatefulCache.this.cacheMap;
                    synchronized (e) {
                        if (!SimpleStatefulCache.this.running) {
                            return;
                        }
                        boolean trace = SimpleStatefulCache.this.log.isTraceEnabled();
                        Iterator it = SimpleStatefulCache.this.cacheMap.entrySet().iterator();
                        long now = System.currentTimeMillis();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            StatefulBeanContext centry = (StatefulBeanContext)entry.getValue();
                            if (now - centry.lastUsed >= SimpleStatefulCache.this.sessionTimeout * 1000L) {
                                StatefulBeanContext statefulBeanContext = centry;
                                synchronized (statefulBeanContext) {
                                    if (centry.getCanPassivate()) {
                                        if (!centry.getCanRemoveFromCache()) {
                                            SimpleStatefulCache.this.passivate(centry);
                                        } else if (trace) {
                                            SimpleStatefulCache.this.log.trace((Object)("Removing " + entry.getKey() + " from cache"));
                                        }
                                    } else {
                                        centry.markedForPassivation = true;
                                        assert (centry.isInUse()) : centry + " is not in use, and thus will never be passivated";
                                    }
                                    it.remove();
                                    continue;
                                }
                            }
                            if (!trace) continue;
                            SimpleStatefulCache.this.log.trace((Object)("Not passivating; id=" + centry.getId() + " only inactive " + Math.max(0L, now - centry.lastUsed) + " ms"));
                        }
                    }
                }
                catch (Exception ex) {
                    SimpleStatefulCache.this.log.error((Object)"problem passivation thread", (Throwable)ex);
                }
            }
        }
    }

    private class RemovalTimeoutTask
    extends Thread {
        public RemovalTimeoutTask(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (SimpleStatefulCache.this.running) {
                try {
                    Thread.sleep(SimpleStatefulCache.this.removalTimeout * 1000L);
                }
                catch (InterruptedException e) {
                    SimpleStatefulCache.this.running = false;
                    return;
                }
                try {
                    long now = System.currentTimeMillis();
                    CacheMap cacheMap = SimpleStatefulCache.this.cacheMap;
                    synchronized (cacheMap) {
                        if (!SimpleStatefulCache.this.running) {
                            return;
                        }
                        Iterator<Object> it = SimpleStatefulCache.this.cacheMap.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            StatefulBeanContext centry = (StatefulBeanContext)entry.getValue();
                            if (now - centry.lastUsed < SimpleStatefulCache.this.removalTimeout * 1000L) continue;
                            StatefulBeanContext statefulBeanContext = centry;
                            synchronized (statefulBeanContext) {
                                it.remove();
                            }
                        }
                    }
                    List<StatefulBeanContext> beans = SimpleStatefulCache.this.pm.getPassivatedBeans();
                    for (StatefulBeanContext centry : beans) {
                        if (now - centry.lastUsed < SimpleStatefulCache.this.removalTimeout * 1000L) continue;
                        SimpleStatefulCache.this.get(centry.getId(), false);
                        SimpleStatefulCache.this.remove(centry.getId());
                    }
                }
                catch (Exception ex) {
                    SimpleStatefulCache.this.log.error((Object)"problem removing SFSB thread", (Throwable)ex);
                }
            }
        }
    }

    private class CacheMap
    extends LinkedHashMap {
        private static final long serialVersionUID = 4514182777643616159L;

        public CacheMap() {
            super(SimpleStatefulCache.this.maxSize, 0.75f, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeEldestEntry(Map.Entry entry) {
            boolean removeIt;
            boolean bl = removeIt = this.size() > SimpleStatefulCache.this.maxSize;
            if (removeIt) {
                StatefulBeanContext centry;
                StatefulBeanContext statefulBeanContext = centry = (StatefulBeanContext)entry.getValue();
                synchronized (statefulBeanContext) {
                    if (centry.getCanPassivate()) {
                        SimpleStatefulCache.this.passivate(centry);
                    } else {
                        centry.markedForPassivation = true;
                        if (!centry.isInUse()) {
                            removeIt = false;
                        }
                    }
                }
            }
            return removeIt;
        }
    }
}

