/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.inflow;

import javax.jms.MessageListener;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.plugins.inflow.JBossMessageEndpointFactory;
import org.jboss.metadata.ActivationConfigPropertyMetaData;
import org.jboss.metadata.MetaData;
import org.w3c.dom.Element;

public class JBossJMSMessageEndpointFactory
extends JBossMessageEndpointFactory {
    protected static String jmsra = "jms-ra.rar";

    protected String resolveResourceAdapterName() throws DeploymentException {
        String result = super.resolveResourceAdapterName();
        if (result == null) {
            result = jmsra;
        }
        return result;
    }

    protected void resolveMessageListener() throws DeploymentException {
        if (this.metaData.getMessagingType() == null) {
            this.messagingTypeClass = MessageListener.class;
        } else {
            super.resolveMessageListener();
        }
    }

    protected void augmentActivationConfigProperties() throws DeploymentException {
        super.augmentActivationConfigProperties();
        if (this.messagingTypeClass.equals(MessageListener.class)) {
            this.checkActivationConfig("destination", this.metaData.getDestinationJndiName());
            this.checkActivationConfig("destinationType", this.metaData.getDestinationType());
            this.checkActivationConfig("messageSelector", this.metaData.getMessageSelector());
            if (3 == this.metaData.getAcknowledgeMode()) {
                this.checkActivationConfig("acknowledgeMode", "DUPS_OK_ACKNOWLEDGE");
            } else {
                this.checkActivationConfig("acknowledgeMode", "AUTO_ACKNOWLEDGE");
            }
            if (0 == this.metaData.getSubscriptionDurability()) {
                this.checkActivationConfig("subscriptionDurability", "Durable");
            } else {
                this.checkActivationConfig("subscriptionDurability", "NonDurable");
            }
            this.checkActivationConfig("clientID", this.metaData.getClientId());
            this.checkActivationConfig("subscriptionName", this.metaData.getSubscriptionId());
            if (jmsra.equals(this.resourceAdapterName)) {
                this.checkActivationConfig("user", this.metaData.getUser());
                this.checkActivationConfig("password", this.metaData.getPasswd());
                Element proxyConfig = this.invokerMetaData.getProxyFactoryConfig();
                this.checkActivationConfig("maxMessages", MetaData.getOptionalChildContent((Element)proxyConfig, (String)"MaxMessages"));
                this.checkActivationConfig("minSession", MetaData.getOptionalChildContent((Element)proxyConfig, (String)"MinimumSize"));
                this.checkActivationConfig("maxSession", MetaData.getOptionalChildContent((Element)proxyConfig, (String)"MaximumSize"));
                this.checkActivationConfig("keepAlive", MetaData.getOptionalChildContent((Element)proxyConfig, (String)"KeepAliveMillis"));
                Element mdbConfig = MetaData.getOptionalChild((Element)proxyConfig, (String)"MDBConfig");
                if (mdbConfig != null) {
                    try {
                        if ("false".equalsIgnoreCase(MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)mdbConfig, (String)"DeliveryActive")))) {
                            this.setDeliveryActive(false);
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    this.checkActivationConfig("reconnectInterval", MetaData.getOptionalChildContent((Element)proxyConfig, (String)"ReconnectIntervalSec"));
                    this.checkActivationConfig("deliveryActive", MetaData.getOptionalChildContent((Element)proxyConfig, (String)"DeliveryActive"));
                    this.checkActivationConfig("providerAdapterJNDI", MetaData.getOptionalChildContent((Element)proxyConfig, (String)"JMSProviderAdapterJNDI"));
                    Element dlqEl = MetaData.getOptionalChild((Element)mdbConfig, (String)"DLQConfig");
                    if (dlqEl != null) {
                        this.checkActivationConfig("useDLQ", "true");
                        this.checkActivationConfig("DLQJNDIName", MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)dlqEl, (String)"DestinationQueue")));
                        try {
                            this.checkActivationConfig("DLQMaxResent", MetaData.getElementContent((Element)MetaData.getUniqueChild((Element)dlqEl, (String)"MaxTimesRedelivered")));
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        this.checkActivationConfig("DLQUser", MetaData.getElementContent((Element)MetaData.getOptionalChild((Element)dlqEl, (String)"DLQUser")));
                        this.checkActivationConfig("DLQPassword", MetaData.getElementContent((Element)MetaData.getOptionalChild((Element)dlqEl, (String)"DLQPassword")));
                    } else {
                        this.checkActivationConfig("useDLQ", "false");
                    }
                }
            }
        }
    }

    void checkActivationConfig(String name, String value) {
        if (value != null && !this.properties.containsKey(name)) {
            org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData md = new org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData();
            ActivationConfigPropertyMetaData metaData = new ActivationConfigPropertyMetaData(md);
            md.setName(name);
            md.setValue(value);
            this.properties.put(name, metaData);
        }
    }
}

