/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.security.Principal;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJBException;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationType;
import org.jboss.metadata.ApplicationMetaData;
import org.jboss.metadata.AssemblyDescriptorMetaData;
import org.jboss.metadata.BeanMetaData;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.RealmMapping;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;

public class SecurityRolesInterceptor
extends AbstractInterceptor {
    protected RealmMapping realmMapping;
    protected Map securityRoles;

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            ApplicationMetaData applicationMetaData = beanMetaData.getApplicationMetaData();
            AssemblyDescriptorMetaData assemblyDescriptor = applicationMetaData.getAssemblyDescriptor();
            this.securityRoles = assemblyDescriptor.getSecurityRoles();
            this.realmMapping = container.getRealmMapping();
        }
    }

    public void start() throws Exception {
        super.start();
    }

    public Object invokeHome(Invocation mi) throws Exception {
        this.checkSecurityAssociation(mi);
        Object returnValue = this.getNext().invokeHome(mi);
        return returnValue;
    }

    public Object invoke(Invocation mi) throws Exception {
        this.checkSecurityAssociation(mi);
        Object returnValue = this.getNext().invoke(mi);
        return returnValue;
    }

    private void checkSecurityAssociation(Invocation mi) throws Exception {
        Principal principal = mi.getPrincipal();
        boolean trace = this.log.isTraceEnabled();
        if (this.realmMapping == null) {
            throw new EJBException("checkSecurityAssociation", (Exception)new SecurityException("Role mapping manager has not been set"));
        }
        InvocationType iface = mi.getType();
        Set<Principal> methodRoles = this.container.getMethodPermissions(mi.getMethod(), iface);
        if (methodRoles == null) {
            String method = mi.getMethod().getName();
            String msg = "No method permissions assigned to method=" + method + ", interface=" + iface;
            this.log.error((Object)msg);
            SecurityException e = new SecurityException(msg);
            throw new EJBException("checkSecurityAssociation", (Exception)e);
        }
        if (trace) {
            this.log.trace((Object)("method=" + mi.getMethod() + ", interface=" + iface + ", requiredRoles=" + methodRoles));
        }
        RunAsIdentity callerRunAsIdentity = SecurityAssociation.peekRunAsIdentity();
        if (!methodRoles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL)) {
            if (callerRunAsIdentity == null) {
                if (!this.realmMapping.doesUserHaveRole(principal, methodRoles)) {
                    Set userRoles = this.realmMapping.getUserRoles(principal);
                    String method = mi.getMethod().getName();
                    String msg = "Insufficient method permissions, principal=" + principal + ", method=" + method + ", interface=" + iface + ", requiredRoles=" + methodRoles + ", principalRoles=" + userRoles;
                    this.log.error((Object)msg);
                    SecurityException e = new SecurityException(msg);
                    throw new EJBException("checkSecurityAssociation", (Exception)e);
                }
            } else if (!callerRunAsIdentity.doesUserHaveRole(methodRoles)) {
                String method = mi.getMethod().getName();
                String msg = "Insufficient method permissions, runAsPrincipal=" + callerRunAsIdentity.getName() + ", method=" + method + ", interface=" + iface + ", requiredRoles=" + methodRoles + ", runAsRoles=" + callerRunAsIdentity.getRunAsRoles();
                this.log.error((Object)msg);
                SecurityException e = new SecurityException(msg);
                throw new EJBException("checkSecurityAssociation", (Exception)e);
            }
        }
    }
}

