/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import javax.security.jacc.PolicyContextException;
import org.jboss.deployment.security.PolicyConfigurationFacadeMBean;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.support.IdMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PolicyConfigurationFacade<T extends IdMetaData>
implements PolicyConfigurationFacadeMBean {
    protected static Logger log = Logger.getLogger(PolicyConfigurationFacade.class);
    protected boolean trace = log.isTraceEnabled();
    private String jaccContextId;
    private PolicyConfiguration policyConfiguration;
    private T metaData;

    public PolicyConfigurationFacade(String id, T md) {
        if (id == null) {
            throw new IllegalArgumentException("Context ID is null");
        }
        if (md == null) {
            throw new IllegalArgumentException("Meta Data is null");
        }
        this.jaccContextId = id;
        this.metaData = md;
    }

    @Override
    public void create() {
        try {
            PolicyConfigurationFactory pcf = PolicyConfigurationFactory.getPolicyConfigurationFactory();
            this.policyConfiguration = pcf.getPolicyConfiguration(this.jaccContextId, true);
            this.createPermissions(this.metaData, this.policyConfiguration);
        }
        catch (ClassNotFoundException e) {
            new RuntimeException(e);
        }
        catch (PolicyContextException e) {
            new RuntimeException(e);
        }
        if (this.trace) {
            log.trace((Object)("Create:contextID=" + this.jaccContextId));
        }
    }

    @Override
    public void destroy() {
        if (this.trace) {
            log.trace((Object)("destroy : " + this.jaccContextId));
        }
        this.policyConfiguration = null;
    }

    @Override
    public void start() {
        if (this.trace) {
            log.trace((Object)("Start : contextId=" + this.jaccContextId));
        }
    }

    @Override
    public void stop() {
        try {
            this.policyConfiguration.delete();
        }
        catch (PolicyContextException e) {
            new RuntimeException(e);
        }
        if (this.trace) {
            log.trace((Object)("stop : " + this.jaccContextId));
        }
    }

    @Override
    public PolicyConfiguration getPolicyConfiguration() {
        return this.policyConfiguration;
    }

    @Override
    public String getJaccContextID() {
        return this.jaccContextId;
    }

    protected abstract void createPermissions(T var1, PolicyConfiguration var2) throws PolicyContextException;
}

