/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.dependency.ContainerDependencyMetaData;
import org.jboss.deployment.dependency.JndiDependencyMetaData;
import org.jboss.deployment.plugin.LegacyEjb3JndiPolicy;
import org.jboss.deployment.plugin.MappedDeploymentEndpointResolver;
import org.jboss.deployment.spi.DeploymentEndpointResolver;
import org.jboss.deployment.spi.EndpointInfo;
import org.jboss.logging.Logger;
import org.jboss.metadata.client.jboss.JBossClientMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossEntityBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossGenericBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.plugins.SessionJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.AnnotatedEJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBLocalReferencesMetaData;
import org.jboss.metadata.javaee.spec.EJBReferenceMetaData;
import org.jboss.metadata.javaee.spec.EJBReferencesMetaData;
import org.jboss.metadata.javaee.spec.Environment;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedReferenceMetaDataResolverDeployer
extends AbstractRealDeployer {
    public static final String ENDPOINT_MAP_KEY = "MappedReferenceMetaDataResolverDeployer.endpointMap";
    public static final String DEPENDS_SET_KEY = "MappedReferenceMetaDataResolverDeployer.dependsSet";
    public static final String ALTERNATE_MAP_KEY = "MappedReferenceMetaDataResolverDeployer.endpointAlternateMap";
    private static Logger log = Logger.getLogger(MappedReferenceMetaDataResolverDeployer.class);
    private boolean failOnUnresolvedRefs;

    public MappedReferenceMetaDataResolverDeployer() {
        this.setStage(DeploymentStages.POST_CLASSLOADER);
        HashSet<String> inputs = new HashSet<String>();
        inputs.add(JBossClientMetaData.class.getName());
        inputs.add(JBossMetaData.class.getName());
        inputs.add(JBossWebMetaData.class.getName());
        super.setInputs(inputs);
        super.setOutput(DeploymentEndpointResolver.class);
    }

    public boolean isParentFirst() {
        return false;
    }

    public boolean isFailOnUnresolvedRefs() {
        return this.failOnUnresolvedRefs;
    }

    public void setFailOnUnresolvedRefs(boolean failOnUnresolvedRefs) {
        this.failOnUnresolvedRefs = failOnUnresolvedRefs;
    }

    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        MappedDeploymentEndpointResolver resolver;
        JBossMetaData ejbMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        JBossWebMetaData webMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
        JBossClientMetaData clientMetaData = (JBossClientMetaData)unit.getAttachment(JBossClientMetaData.class);
        if (ejbMetaData == null && webMetaData == null && clientMetaData == null) {
            return;
        }
        DeploymentUnit top = unit.getTopLevel();
        ConcurrentHashMap<String, ContainerDependencyMetaData> endpointMap = (ConcurrentHashMap<String, ContainerDependencyMetaData>)top.getAttachment(ENDPOINT_MAP_KEY, Map.class);
        ConcurrentHashMap<String, String> endpointAlternateMap = (ConcurrentHashMap<String, String>)top.getAttachment(ALTERNATE_MAP_KEY, Map.class);
        if (endpointMap == null) {
            endpointMap = new ConcurrentHashMap<String, ContainerDependencyMetaData>();
            endpointAlternateMap = new ConcurrentHashMap<String, String>();
            this.mapEndpoints(top, endpointMap, endpointAlternateMap);
            top.addAttachment(ENDPOINT_MAP_KEY, endpointMap, Map.class);
            top.addAttachment(ALTERNATE_MAP_KEY, endpointAlternateMap);
            resolver = new MappedDeploymentEndpointResolver(endpointMap, endpointAlternateMap, unit.getRelativePath());
            top.addAttachment(DeploymentEndpointResolver.class, (Object)resolver);
        }
        resolver = new MappedDeploymentEndpointResolver(endpointMap, (Map<String, String>)endpointAlternateMap, unit.getRelativePath());
        ArrayList<String> unresolvedPaths = new ArrayList<String>();
        if (ejbMetaData != null) {
            JBossEnterpriseBeansMetaData beans = ejbMetaData.getEnterpriseBeans();
            try {
                this.resolve(unit, endpointMap, beans, resolver, unresolvedPaths);
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
            if (unresolvedPaths.size() > 0) {
                log.warn((Object)("Unresolved references exist in JBossMetaData:" + unresolvedPaths));
            }
        }
        if (webMetaData != null) {
            ContainerDependencyMetaData webAppCDMD = new ContainerDependencyMetaData(unit.getSimpleName(), "web-app", unit.getRelativePath());
            try {
                this.resolve(webAppCDMD, unit, endpointMap, webMetaData.getJndiEnvironmentRefsGroup(), resolver, unresolvedPaths);
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
            if (unresolvedPaths.size() > 0) {
                log.warn((Object)("Unresolved references exist in JBossWebMetaData:" + unresolvedPaths));
            }
        }
        if (clientMetaData != null) {
            ContainerDependencyMetaData clientCDMD = new ContainerDependencyMetaData(unit.getSimpleName(), "client", unit.getRelativePath());
            try {
                this.resolve(clientCDMD, unit, endpointMap, clientMetaData.getJndiEnvironmentRefsGroup(), resolver, unresolvedPaths);
            }
            catch (Exception e) {
                throw new DeploymentException((Throwable)e);
            }
            if (unresolvedPaths.size() > 0) {
                log.warn((Object)("Unresolved references exist in JBossClientMetaData: " + unresolvedPaths));
            }
        }
        HashSet<ContainerDependencyMetaData> depends = new HashSet<ContainerDependencyMetaData>();
        for (ContainerDependencyMetaData cdmd : endpointMap.values()) {
            depends.add(cdmd);
        }
        top.addAttachment(DEPENDS_SET_KEY, depends, Set.class);
        unit.addAttachment(DeploymentEndpointResolver.class, (Object)resolver);
        this.dump(unit);
    }

    protected void mapEndpoints(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, Map<String, String> endpointAlternateMap) {
        boolean trace = log.isTraceEnabled();
        this.mapEjbs(unit, endpointMap, endpointAlternateMap, trace);
        this.mapMessageDestinations(unit, endpointMap, trace);
        this.mapPersistenceUnits(unit, endpointMap, trace);
        this.displayEndpoints(unit.getName(), endpointMap);
    }

    protected void mapPersistenceUnits(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, boolean trace) {
        String vfsPath = unit.getRelativePath();
    }

    protected void mapMessageDestinations(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, boolean trace) {
        List children;
        JBossClientMetaData clientMetaData;
        JBossWebMetaData webMetaData;
        String vfsPath = unit.getRelativePath();
        JBossMetaData ejbMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        MessageDestinationsMetaData msgDestinations = null;
        ClassLoader loader = unit.getClassLoader();
        if (ejbMetaData != null) {
            ejbMetaData.getAssemblyDescriptor().getMessageDestinations();
            this.mapMessageDestinations(vfsPath, msgDestinations, endpointMap, loader, trace);
        }
        if ((webMetaData = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class)) != null) {
            msgDestinations = webMetaData.getMessageDestinations();
            this.mapMessageDestinations(vfsPath, msgDestinations, endpointMap, loader, trace);
        }
        if ((clientMetaData = (JBossClientMetaData)unit.getAttachment(JBossClientMetaData.class)) != null) {
            msgDestinations = clientMetaData.getMessageDestinations();
            this.mapMessageDestinations(vfsPath, msgDestinations, endpointMap, loader, trace);
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                this.mapMessageDestinations(child, endpointMap, trace);
            }
        }
    }

    protected void mapMessageDestinations(String vfsPath, MessageDestinationsMetaData msgDestinations, Map<String, ContainerDependencyMetaData> endpointMap, ClassLoader loader, boolean trace) {
        if (msgDestinations == null || msgDestinations.size() == 0) {
            return;
        }
        String prefix = "message-destination/" + vfsPath;
        for (MessageDestinationMetaData dest : msgDestinations) {
            String mappedName = dest.getMappedName();
            String destName = dest.getMessageDestinationName();
            if (mappedName == null || mappedName.length() == 0) {
                log.debug((Object)("Message-destination: " + destName + " has no mappedName"));
                continue;
            }
            String destPath = prefix + "#" + destName;
            ContainerDependencyMetaData destMD = new ContainerDependencyMetaData(mappedName, destName, vfsPath);
            endpointMap.put(destPath, destMD);
            if (!trace) continue;
            log.trace((Object)("mapMessageDestinations: " + destPath + ", mappedName: " + mappedName));
        }
    }

    protected void mapEjbs(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, Map<String, String> endpointAlternateMap, boolean trace) {
        List children;
        JBossMetaData ejbMetaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        JBossEnterpriseBeansMetaData beans = null;
        if (ejbMetaData != null) {
            if (ejbMetaData.getDeploymentSummary() == null) {
                DeploymentSummary deploymentSummary = new DeploymentSummary();
                deploymentSummary.setDeploymentName(unit.getSimpleName());
                if (unit.getTopLevel() != unit) {
                    String deploymentScopeBaseName = unit.getTopLevel().getSimpleName();
                    int dot = deploymentScopeBaseName.lastIndexOf(46);
                    if (dot > 0) {
                        deploymentScopeBaseName = deploymentScopeBaseName.substring(0, dot);
                    }
                    deploymentSummary.setDeploymentScopeBaseName(deploymentScopeBaseName);
                }
                deploymentSummary.setLoader(unit.getClassLoader());
                ejbMetaData.setDeploymentSummary(deploymentSummary);
            }
            beans = ejbMetaData.getEnterpriseBeans();
        }
        if (beans != null) {
            String vfsPath = unit.getRelativePath();
            String prefix = "ejb/" + vfsPath;
            for (JBossEnterpriseBeanMetaData bean : beans) {
                String local;
                String remote;
                String ifacePath;
                String home;
                String ejbName;
                String ejbCompID = prefix + "#" + bean.getEjbName();
                LegacyEjb3JndiPolicy policy = new LegacyEjb3JndiPolicy();
                String jndiName = bean.determineResolvedJndiName(null, (DefaultJndiBindingPolicy)policy);
                ContainerDependencyMetaData cdmd = new ContainerDependencyMetaData(jndiName, bean.getEjbName(), vfsPath);
                cdmd.setEjb3X(ejbMetaData.isEJB3x());
                ClassLoader loader = unit.getClassLoader();
                EjbDeploymentSummary unitSummary = MappedReferenceMetaDataResolverDeployer.getUnitSummary(unit, bean);
                cdmd.setUnitSummary(unitSummary);
                endpointMap.put(ejbCompID, cdmd);
                ArrayList<String> mappings = new ArrayList<String>();
                String ejbNameKey = "ejb/" + bean.getEjbName();
                if (!endpointAlternateMap.containsKey(ejbNameKey)) {
                    endpointAlternateMap.put(ejbNameKey, ejbCompID);
                    mappings.add(ejbNameKey);
                    if (trace) {
                        log.trace((Object)("mapEjbs, added alternate root ejb-name: " + ejbNameKey));
                    }
                } else {
                    log.debug((Object)("Duplicate root ejb-name: " + ejbNameKey + " from: " + ejbCompID));
                }
                if (bean instanceof JBossSessionBeanMetaData) {
                    BusinessRemotesMetaData remotes;
                    BusinessLocalsMetaData locals;
                    JBossSessionBeanMetaData sbean = (JBossSessionBeanMetaData)bean;
                    ejbName = sbean.getEjbName();
                    if (sbean.getHome() != null && sbean.getHome().length() > 0) {
                        cdmd.addJndiName(sbean.determineResolvedJndiName("home", (DefaultJndiBindingPolicy)policy));
                        home = sbean.getHome();
                        ifacePath = prefix + "@" + home;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates home: " + home + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + home;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates home: " + home + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (sbean.getRemote() != null && sbean.getRemote().length() > 0) {
                        remote = sbean.getRemote();
                        ifacePath = prefix + "@" + remote;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates remote: " + remote + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, remote: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + remote;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates remote: " + remote + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (sbean.getLocalHome() != null && sbean.getLocalHome().length() > 0) {
                        cdmd.addJndiName(sbean.determineResolvedJndiName("localHome", (DefaultJndiBindingPolicy)policy));
                        local = sbean.getLocalHome();
                        ifacePath = prefix + "@" + local;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local-home: " + local + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + local;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local-home: " + local + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (sbean.getLocal() != null && sbean.getLocal().length() > 0) {
                        local = sbean.getLocal();
                        ifacePath = prefix + "@" + local;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local: " + local + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + local;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local: " + local + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if ((locals = sbean.getBusinessLocals()) != null && locals.size() > 0) {
                        String localBaseJndiName = sbean.determineResolvedJndiName("local", (DefaultJndiBindingPolicy)policy);
                        cdmd.addJndiName(localBaseJndiName);
                        for (String local2 : locals) {
                            cdmd.addJndiName(localBaseJndiName + "-" + local2);
                            String ifacePath2 = prefix + "@" + local2;
                            if (endpointAlternateMap.containsKey(ifacePath2)) {
                                log.debug((Object)(ejbName + " duplicates business local: " + local2 + ", existing: " + endpointAlternateMap.get(ifacePath2)));
                            } else {
                                endpointAlternateMap.put(ifacePath2, ejbCompID);
                                mappings.add(ifacePath2);
                                if (trace) {
                                    log.trace((Object)("mapEjbs, business-local: " + ifacePath2 + ", ejbName: " + ejbName));
                                }
                            }
                            ifacePath2 = "ejb@" + local2;
                            if (endpointMap.containsKey(ifacePath2)) {
                                log.debug((Object)(ejbName + " duplicates business-local: " + local2 + ", existing: " + (Object)((Object)endpointMap.get(ifacePath2))));
                                continue;
                            }
                            endpointAlternateMap.put(ifacePath2, ejbCompID);
                            mappings.add(ifacePath2);
                            if (!trace) continue;
                            log.trace((Object)("mapEjbs, business-local: " + ifacePath2 + ", ejbName: " + ejbName));
                        }
                    }
                    if ((remotes = sbean.getBusinessRemotes()) != null && remotes.size() > 0) {
                        String remoteBaseJndiName = sbean.determineResolvedJndiName("remote", (DefaultJndiBindingPolicy)policy);
                        cdmd.addJndiName(remoteBaseJndiName);
                        for (String remote2 : remotes) {
                            cdmd.addJndiName(remoteBaseJndiName + "-" + remote2);
                            String ifacePath3 = prefix + "@" + remote2;
                            if (endpointAlternateMap.containsKey(ifacePath3)) {
                                log.debug((Object)(ejbName + " duplicates business remote: " + remote2 + ", existing: " + endpointAlternateMap.get(ifacePath3)));
                            } else {
                                endpointAlternateMap.put(ifacePath3, ejbCompID);
                                mappings.add(ifacePath3);
                                if (trace) {
                                    log.trace((Object)("mapEjbs, business-remote: " + ifacePath3 + ", ejbName: " + ejbName));
                                }
                            }
                            ifacePath3 = "ejb@" + remote2;
                            if (endpointAlternateMap.containsKey(ifacePath3)) {
                                log.debug((Object)(ejbName + " duplicates business-remote: " + remote2 + ", existing: " + endpointAlternateMap.get(ifacePath3)));
                                continue;
                            }
                            endpointAlternateMap.put(ifacePath3, ejbCompID);
                            mappings.add(ifacePath3);
                            if (!trace) continue;
                            log.trace((Object)("mapEjbs, business-remote: " + ifacePath3 + ", ejbName: " + ejbName));
                        }
                    }
                    if (!trace) continue;
                    log.trace((Object)("mapEjbs: " + ejbCompID + ", mappings: " + mappings));
                    continue;
                }
                if (bean instanceof JBossEntityBeanMetaData) {
                    JBossEntityBeanMetaData ebean = (JBossEntityBeanMetaData)bean;
                    ejbName = ebean.getEjbName();
                    if (ebean.getHome() != null && ebean.getHome().length() > 0) {
                        cdmd.addJndiName(ebean.determineResolvedJndiName("home", (DefaultJndiBindingPolicy)policy));
                        home = ebean.getHome();
                        ifacePath = prefix + "@" + home;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates home: " + home + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + home;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates home: " + home + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (ebean.getRemote() != null && ebean.getRemote().length() > 0) {
                        remote = ebean.getRemote();
                        ifacePath = prefix + "@" + remote;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates remote: " + remote + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, remote: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + remote;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates remote: " + remote + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (ebean.getLocalHome() != null && ebean.getLocalHome().length() > 0) {
                        cdmd.addJndiName(ebean.determineResolvedJndiName("localHome", (DefaultJndiBindingPolicy)policy));
                        local = ebean.getLocalHome();
                        ifacePath = prefix + "@" + local;
                        if (endpointAlternateMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local-home: " + local + ", existing: " + endpointAlternateMap.get(ifacePath)));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                        ifacePath = "ejb@" + local;
                        if (endpointMap.containsKey(ifacePath)) {
                            log.debug((Object)(ejbName + " duplicates local-home: " + local + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        } else {
                            endpointAlternateMap.put(ifacePath, ejbCompID);
                            mappings.add(ifacePath);
                            if (trace) {
                                log.trace((Object)("mapEjbs, local-home: " + ifacePath + ", ejbName: " + ejbName));
                            }
                        }
                    }
                    if (ebean.getLocal() == null || ebean.getLocal().length() <= 0) continue;
                    local = ebean.getLocal();
                    ifacePath = prefix + "@" + local;
                    if (endpointAlternateMap.containsKey(ifacePath)) {
                        log.debug((Object)(ejbName + " duplicates local: " + local + ", existing: " + endpointAlternateMap.get(ifacePath)));
                    } else {
                        endpointAlternateMap.put(ifacePath, ejbCompID);
                        mappings.add(ifacePath);
                        if (trace) {
                            log.trace((Object)("mapEjbs, local: " + ifacePath + ", ejbName: " + ejbName));
                        }
                    }
                    ifacePath = "ejb@" + local;
                    if (endpointMap.containsKey(ifacePath)) {
                        log.debug((Object)(ejbName + " duplicates local: " + local + ", existing: " + (Object)((Object)endpointMap.get(ifacePath))));
                        continue;
                    }
                    endpointAlternateMap.put(ifacePath, ejbCompID);
                    mappings.add(ifacePath);
                    if (!trace) continue;
                    log.trace((Object)("mapEjbs, local: " + ifacePath + ", ejbName: " + ejbName));
                    continue;
                }
                if (!(bean instanceof JBossGenericBeanMetaData)) continue;
                log.warn((Object)("JBossGenericBeanMetaData seen for: " + bean.getEjbName()));
            }
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                this.mapEjbs(child, endpointMap, endpointAlternateMap, trace);
            }
        }
    }

    protected void resolve(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, Environment env, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) throws Exception {
        if (env == null) {
            return;
        }
        AnnotatedEJBReferencesMetaData annotatedRefs = env.getAnnotatedEjbReferences();
        this.resolveEjbAnnotatedRefs(cdmd, unit, endpointMap, annotatedRefs, resolver, unresolvedRefs);
        EJBLocalReferencesMetaData localRefs = env.getEjbLocalReferences();
        this.resolveEjbLocalRefs(cdmd, unit, endpointMap, localRefs, resolver, unresolvedRefs);
        EJBReferencesMetaData ejbRefs = env.getEjbReferences();
        this.resolveEjbRefs(cdmd, unit, endpointMap, ejbRefs, resolver, unresolvedRefs);
        MessageDestinationReferencesMetaData msgRefs = env.getMessageDestinationReferences();
        this.resolveMsgRefs(cdmd, unit, endpointMap, msgRefs, resolver, unresolvedRefs);
    }

    protected void resolve(DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, JBossEnterpriseBeansMetaData beans, DeploymentEndpointResolver resolver, List<String> unresolvedPaths) throws Exception {
        if (beans == null || beans.size() == 0) {
            return;
        }
        String vfsPath = unit.getRelativePath();
        for (JBossEnterpriseBeanMetaData bean : beans) {
            String ejbCompID = "ejb/" + vfsPath + "#" + bean.getEjbName();
            ContainerDependencyMetaData cdmd = endpointMap.get(ejbCompID);
            if (cdmd == null) {
                throw new IllegalStateException("Failed to find ContainerDependencyMetaData for: " + ejbCompID);
            }
            Environment env = bean.getJndiEnvironmentRefsGroup();
            this.resolve(cdmd, unit, endpointMap, env, resolver, unresolvedPaths);
        }
    }

    protected void resolveEjbAnnotatedRefs(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, AnnotatedEJBReferencesMetaData annotatedRefs, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) {
        if (annotatedRefs == null) {
            return;
        }
        String vfsContext = unit.getRelativePath();
        for (AnnotatedEJBReferenceMetaData ref : annotatedRefs) {
            Class iface = ref.getBeanInterface();
            String link = ref.getLink();
            EndpointInfo info = null;
            if (link != null) {
                info = resolver.getEndpointInfo(link, "ejb", vfsContext);
            }
            if (info == null && iface != null) {
                info = resolver.getEndpointInfo(iface, "ejb", vfsContext);
            }
            if (info != null) {
                ContainerDependencyMetaData target = endpointMap.get(info.getComponentKey());
                if (target != null) {
                    cdmd.addDependency(target);
                    String ifaceName = iface != null ? iface.getName() : null;
                    LegacyEjb3JndiPolicy policy = new LegacyEjb3JndiPolicy();
                    String containerJndiName = target.getBeanMetaData().determineResolvedJndiName(ifaceName, (DefaultJndiBindingPolicy)policy);
                    if (containerJndiName == null) continue;
                    ref.setResolvedJndiName(containerJndiName);
                    continue;
                }
                unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                continue;
            }
            unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
        }
    }

    protected void resolveEjbLocalRefs(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, EJBLocalReferencesMetaData localRefs, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) throws Exception {
        if (localRefs == null) {
            return;
        }
        String vfsContext = unit.getRelativePath();
        ClassLoader loader = unit.getClassLoader();
        for (EJBLocalReferenceMetaData ref : localRefs) {
            if (ref.getIgnoreDependency() != null) {
                log.debug((Object)("IGNORING <ejb-ref> DEPENDENCY: " + ref));
                return;
            }
            String link = ref.getLink();
            String mappedName = ref.getMappedName();
            if (mappedName == null || mappedName.length() == 0) {
                ContainerDependencyMetaData target = null;
                if (link != null) {
                    EndpointInfo info = resolver.getEndpointInfo(link, "ejb", vfsContext);
                    if (info != null) {
                        target = endpointMap.get(info.getComponentKey());
                    } else {
                        List<String> ejbPaths = this.getEjbDeploymentPaths(unit);
                        for (String path : ejbPaths) {
                            EndpointInfo altInfo = resolver.getEndpointInfo(link, "ejb", path);
                            if (altInfo != null) {
                                target = endpointMap.get(altInfo.getComponentKey());
                            }
                            if (target == null) continue;
                            break;
                        }
                    }
                }
                if (target == null && ref.getLocal() != null) {
                    target = this.resolveEjbInterface(ref.getLocal(), unit, endpointMap, resolver);
                }
                if (target == null) {
                    unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                    continue;
                }
                cdmd.addDependency(target);
                String localJndiName = target.getBeanMetaData().determineLocalJndiName();
                if (localJndiName == null) continue;
                ref.setResolvedJndiName(localJndiName);
                continue;
            }
            ref.setResolvedJndiName(mappedName);
            JndiDependencyMetaData jdmd = new JndiDependencyMetaData(mappedName, loader);
            cdmd.addJndiDependency(jdmd);
        }
    }

    protected void resolveEjbRefs(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, EJBReferencesMetaData ejbRefs, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) throws Exception {
        if (ejbRefs == null) {
            return;
        }
        String vfsContext = unit.getRelativePath();
        ClassLoader loader = unit.getClassLoader();
        for (EJBReferenceMetaData ref : ejbRefs) {
            if (ref.getIgnoreDependency() != null) {
                log.debug((Object)("IGNORING <ejb-ref> DEPENDENCY: " + ref));
                return;
            }
            String link = ref.getLink();
            String mappedName = ref.getMappedName();
            if (mappedName == null || mappedName.length() == 0) {
                ContainerDependencyMetaData target = null;
                if (link != null) {
                    EndpointInfo info = resolver.getEndpointInfo(link, "ejb", vfsContext);
                    if (info != null) {
                        target = endpointMap.get(info.getComponentKey());
                    } else {
                        List<String> ejbPaths = this.getEjbDeploymentPaths(unit);
                        for (String path : ejbPaths) {
                            EndpointInfo altInfo = resolver.getEndpointInfo(link, "ejb", path);
                            if (altInfo != null) {
                                target = endpointMap.get(altInfo.getComponentKey());
                            }
                            if (target == null) continue;
                            break;
                        }
                    }
                    if (target == null) {
                        unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                        continue;
                    }
                }
                if (target == null && ref.getRemote() != null) {
                    target = this.resolveEjbInterface(ref.getRemote(), unit, endpointMap, resolver);
                }
                if (target == null) {
                    unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                    continue;
                }
                cdmd.addDependency(target);
                String iface = this.getInterface(ref);
                LegacyEjb3JndiPolicy policy = new LegacyEjb3JndiPolicy();
                String containerJndiName = target.getBeanMetaData().determineResolvedJndiName(iface, (DefaultJndiBindingPolicy)policy);
                if (containerJndiName == null) continue;
                ref.setResolvedJndiName(containerJndiName);
                continue;
            }
            ref.setResolvedJndiName(mappedName);
            JndiDependencyMetaData jdmd = new JndiDependencyMetaData(mappedName, loader);
            cdmd.addJndiDependency(jdmd);
        }
    }

    protected String getInterface(EJBReferenceMetaData ref) {
        String iface = ref.getHome();
        if (iface == null) {
            iface = ref.getRemote();
        }
        return iface;
    }

    protected void resolveMsgRefs(ContainerDependencyMetaData cdmd, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, MessageDestinationReferencesMetaData msgRefs, DeploymentEndpointResolver resolver, List<String> unresolvedRefs) {
        if (msgRefs == null) {
            return;
        }
        ClassLoader loader = unit.getClassLoader();
        String vfsContext = unit.getRelativePath();
        for (MessageDestinationReferenceMetaData ref : msgRefs) {
            String mappedName = ref.getMappedName();
            if (mappedName == null || mappedName.length() == 0) {
                EndpointInfo info;
                String link = ref.getLink();
                ContainerDependencyMetaData target = null;
                if (link != null && (info = resolver.getEndpointInfo(link, "message-destination", vfsContext)) != null) {
                    target = endpointMap.get(info.getComponentKey());
                }
                if (target == null) {
                    unresolvedRefs.add(cdmd.getComponentID() + ":" + ref);
                    continue;
                }
                cdmd.addDependency(target);
                String containerJndiName = target.getContainerName();
                if (containerJndiName == null) continue;
                ref.setResolvedJndiName(containerJndiName);
                continue;
            }
            ref.setResolvedJndiName(mappedName);
            JndiDependencyMetaData jdmd = new JndiDependencyMetaData(mappedName, loader);
            cdmd.addJndiDependency(jdmd);
        }
    }

    protected ContainerDependencyMetaData resolveEjbInterface(String iface, DeploymentUnit unit, Map<String, ContainerDependencyMetaData> endpointMap, DeploymentEndpointResolver resolver) throws Exception {
        String vfsContext;
        ClassLoader loader = unit.getClassLoader();
        Class<?> ifaceClass = loader.loadClass(iface);
        EndpointInfo info = resolver.getEndpointInfo(ifaceClass, "ejb", vfsContext = unit.getRelativePath());
        if (info == null) {
            throw new IllegalStateException("Failed to find ContainerDependencyMetaData for interface: " + iface);
        }
        ContainerDependencyMetaData cdmd = endpointMap.get(info.getComponentKey());
        return cdmd;
    }

    private List<String> getEjbDeploymentPaths(DeploymentUnit unit) {
        ArrayList<String> paths = new ArrayList<String>();
        DeploymentUnit root = unit.getTopLevel();
        this.getEjbDeploymentPaths(root, paths);
        return paths;
    }

    private void getEjbDeploymentPaths(DeploymentUnit unit, ArrayList<String> paths) {
        List children;
        if (unit.isAttachmentPresent(JBossMetaData.class)) {
            paths.add(unit.getRelativePath());
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                this.getEjbDeploymentPaths(child, paths);
            }
        }
    }

    private static <T> void getAllAttachments(DeploymentUnit unit, Class<T> type, ArrayList<T> attachments) {
        List children;
        Object attachment = unit.getAttachment(type);
        if (attachment != null) {
            attachments.add(attachment);
        }
        if ((children = unit.getChildren()) != null) {
            for (DeploymentUnit child : children) {
                MappedReferenceMetaDataResolverDeployer.getAllAttachments(child, type, attachments);
            }
        }
    }

    private static String getJndiName(JBossEnterpriseBeanMetaData beanMD, boolean isLocal, DeploymentUnit unit) {
        String jndiName = beanMD.getMappedName();
        if (isLocal && jndiName == null) {
            if (jndiName == null) {
                jndiName = beanMD.determineLocalJndiName();
            }
            if (jndiName == null) {
                log.warn((Object)("LocalHome jndi name requested for: '" + beanMD.getEjbName() + "' but there is no LocalHome class"));
            }
        } else if (jndiName == null) {
            ClassLoader loader = unit.getClassLoader();
            EjbDeploymentSummary unitSummary = MappedReferenceMetaDataResolverDeployer.getUnitSummary(unit, beanMD);
            Class defaultPolicyClass = null;
            try {
                if (beanMD.getJBossMetaData().isEJB3x()) {
                    String policyClassName = "org.jboss.ejb3.jndipolicy.impl.PackagingBasedJndiBindingPolicy";
                    defaultPolicyClass = loader.loadClass(policyClassName);
                } else if (beanMD.isSession()) {
                    defaultPolicyClass = SessionJndiBindingPolicy.class;
                }
                DefaultJndiBindingPolicy policy = beanMD.createPolicy(loader, defaultPolicyClass);
                if (beanMD.isSession()) {
                    JBossSessionBeanMetaData sbeanMD = (JBossSessionBeanMetaData)beanMD;
                    jndiName = sbeanMD.getJndiName();
                    if (jndiName == null) {
                        jndiName = sbeanMD.getBusinessRemotes() != null && sbeanMD.getBusinessRemotes().size() > 0 ? policy.getDefaultRemoteJndiName(unitSummary) : (sbeanMD.getHome() != null ? policy.getDefaultRemoteHomeJndiName(unitSummary) : (sbeanMD.getRemote() != null ? policy.getDefaultRemoteJndiName(unitSummary) : (sbeanMD.getLocalHome() != null ? policy.getDefaultLocalHomeJndiName(unitSummary) : (sbeanMD.getLocal() != null ? policy.getDefaultLocalJndiName(unitSummary) : policy.getJndiName(unitSummary)))));
                    }
                } else if (policy != null) {
                    jndiName = policy.getJndiName(unitSummary);
                } else if (beanMD.isEntity()) {
                    JBossEntityBeanMetaData ebeanMD = (JBossEntityBeanMetaData)beanMD;
                    jndiName = ebeanMD.determineJndiName();
                }
            }
            catch (Exception e) {
                log.warn((Object)("Failed to obtain jndi name for bean: " + beanMD.getEjbName()), (Throwable)e);
                jndiName = beanMD.getEjbName();
            }
        }
        return jndiName;
    }

    private static EjbDeploymentSummary getUnitSummary(DeploymentUnit unit, JBossEnterpriseBeanMetaData beanMD) {
        ClassLoader loader = unit.getClassLoader();
        EjbDeploymentSummary summary = new EjbDeploymentSummary();
        summary.setBeanMD(beanMD);
        summary.setBeanClassName(beanMD.getEjbClass());
        summary.setDeploymentName(unit.getSimpleName());
        String baseName = unit.getTopLevel().getSimpleName();
        int dot = baseName.lastIndexOf(46);
        if (dot > 0) {
            baseName = baseName.substring(0, dot);
        }
        summary.setDeploymentScopeBaseName(baseName);
        summary.setEjbName(beanMD.getEjbName());
        summary.setLoader(loader);
        summary.setLocal(beanMD.isMessageDriven());
        if (beanMD instanceof JBossSessionBeanMetaData) {
            JBossSessionBeanMetaData sbeanMD = (JBossSessionBeanMetaData)beanMD;
            summary.setStateful(sbeanMD.isStateful());
        }
        summary.setService(beanMD.isService());
        return summary;
    }

    private void dump(DeploymentUnit unit) {
        DeploymentUnit top = unit.getTopLevel();
        StringBuffer tmp = new StringBuffer();
        this.dump(top, tmp, 0);
        log.debug((Object)("Processing unit=" + unit.getSimpleName() + ", structure:\n" + tmp));
    }

    private void dump(DeploymentUnit unit, StringBuffer tmp, int depth) {
        for (int n = 0; n < depth; ++n) {
            tmp.append('+');
        }
        if (depth == 0) {
            tmp.append(unit.getSimpleName());
        } else {
            tmp.append(unit.getRelativePath());
        }
        tmp.append('\n');
        JBossMetaData metaData = (JBossMetaData)unit.getAttachment(JBossMetaData.class);
        if (metaData != null) {
            JBossEnterpriseBeansMetaData beans = metaData.getEnterpriseBeans();
            if (beans != null) {
                for (JBossEnterpriseBeanMetaData bean : beans) {
                    for (int n = 0; n < depth + 1; ++n) {
                        tmp.append('+');
                    }
                    tmp.append("EjbEndpoint:ejbName=");
                    tmp.append(bean.getEjbName());
                    if (bean.getEjbClass() != null) {
                        tmp.append(",ejbClass=");
                        tmp.append(bean.getEjbClass());
                    }
                    if (bean instanceof JBossSessionBeanMetaData) {
                        BusinessRemotesMetaData remotes;
                        BusinessLocalsMetaData locals;
                        JBossSessionBeanMetaData sbean = (JBossSessionBeanMetaData)bean;
                        if (sbean.getHome() != null) {
                            tmp.append(",home=");
                            tmp.append(sbean.getHome());
                        }
                        if (sbean.getRemote() != null) {
                            tmp.append(",remote=");
                            tmp.append(sbean.getRemote());
                        }
                        if ((locals = sbean.getBusinessLocals()) != null) {
                            tmp.append(",BusinessLocals: ");
                            tmp.append(locals);
                        }
                        if ((remotes = sbean.getBusinessRemotes()) != null) {
                            tmp.append(",BusinessRemotes: ");
                            tmp.append(remotes);
                        }
                        this.dumpEnv(bean.getJndiEnvironmentRefsGroup(), tmp, depth + 1);
                    }
                    tmp.append('\n');
                }
            }
        } else if (unit.isAttachmentPresent(JBossWebMetaData.class)) {
            JBossWebMetaData webMD = (JBossWebMetaData)unit.getAttachment(JBossWebMetaData.class);
            this.dumpEnv(webMD.getJndiEnvironmentRefsGroup(), tmp, depth++);
        } else if (unit.isAttachmentPresent(JBossClientMetaData.class)) {
            JBossClientMetaData clientMD = (JBossClientMetaData)unit.getAttachment(JBossClientMetaData.class);
            this.dumpEnv(clientMD.getJndiEnvironmentRefsGroup(), tmp, depth++);
        }
        tmp.append('\n');
        List children = unit.getChildren();
        if (children != null) {
            for (DeploymentUnit child : children) {
                this.dump(child, tmp, depth + 1);
            }
        }
    }

    private void dumpEnv(Environment env, StringBuffer tmp, int depth) {
        EJBReferencesMetaData ejbRefs;
        EJBLocalReferencesMetaData localRefs;
        if (env == null) {
            return;
        }
        AnnotatedEJBReferencesMetaData annotatedRefs = env.getAnnotatedEjbReferences();
        if (annotatedRefs != null) {
            for (AnnotatedEJBReferenceMetaData ref : annotatedRefs) {
                for (int n = 0; n < depth + 1; ++n) {
                    tmp.append('+');
                }
                tmp.append("@EJB(");
                tmp.append(ref.getEjbRefName());
                tmp.append(") -> mappedName=");
                tmp.append(ref.getMappedName());
                tmp.append("| resolvedJndiName=");
                tmp.append(ref.getResolvedJndiName());
                tmp.append('\n');
            }
        }
        if ((localRefs = env.getEjbLocalReferences()) != null) {
            for (EJBLocalReferenceMetaData ref : localRefs) {
                for (int n = 0; n < depth + 1; ++n) {
                    tmp.append('+');
                }
                tmp.append("ejb-local-ref(");
                tmp.append(ref.getEjbRefName());
                tmp.append(") -> mappedName=");
                tmp.append(ref.getMappedName());
                tmp.append("| resolvedJndiName=");
                tmp.append(ref.getResolvedJndiName());
                tmp.append('\n');
            }
        }
        if ((ejbRefs = env.getEjbReferences()) != null) {
            for (EJBReferenceMetaData ref : ejbRefs) {
                for (int n = 0; n < depth + 1; ++n) {
                    tmp.append('+');
                }
                tmp.append("ejb-ref(");
                tmp.append(ref.getEjbRefName());
                tmp.append(") -> mappedName=");
                tmp.append(ref.getMappedName());
                tmp.append("| resolvedJndiName=");
                tmp.append(ref.getResolvedJndiName());
                tmp.append('\n');
            }
        }
        MessageDestinationReferencesMetaData msgRefs = env.getMessageDestinationReferences();
    }

    private void displayEndpoints(String unitName, Map<String, ContainerDependencyMetaData> endpointMap) {
        StringBuilder tmp = new StringBuilder(unitName + " endpoint mappings:\n");
        for (Map.Entry<String, ContainerDependencyMetaData> entry : endpointMap.entrySet()) {
            tmp.append("  + " + entry.getKey() + " -> " + (Object)((Object)entry.getValue()));
            tmp.append('\n');
        }
        log.debug((Object)tmp.toString());
    }
}

