/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.acl.Group;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.resource.security.AbstractPasswordCredentialLoginModule;
import org.jboss.resource.security.SubjectActions;
import org.jboss.security.SimplePrincipal;

public class JaasSecurityDomainIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private static final Logger log = Logger.getLogger(JaasSecurityDomainIdentityLoginModule.class);
    private String username;
    private String password;
    private ObjectName jaasSecurityDomain;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        this.username = (String)options.get("username");
        if (this.username == null) {
            this.username = (String)options.get("userName");
            if (this.username == null) {
                throw new IllegalArgumentException("The user name is a required option");
            }
        }
        this.password = (String)options.get("password");
        if (this.password == null) {
            throw new IllegalArgumentException("The password is a required option");
        }
        String name = (String)options.get("jaasSecurityDomain");
        if (name == null) {
            throw new IllegalArgumentException("The jaasSecurityDomain is a required option");
        }
        try {
            this.jaasSecurityDomain = new ObjectName(name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid jaasSecurityDomain: " + e.getMessage());
        }
    }

    public boolean login() throws LoginException {
        log.trace((Object)"login called");
        if (super.login()) {
            return true;
        }
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        SimplePrincipal principal = new SimplePrincipal(this.username);
        SubjectActions.addPrincipals(this.subject, principal);
        this.sharedState.put("javax.security.auth.login.name", this.username);
        try {
            char[] decodedPassword = DecodeAction.decode(this.password, this.jaasSecurityDomain, this.getServer());
            PasswordCredential cred = new PasswordCredential(this.username, decodedPassword);
            cred.setManagedConnectionFactory(this.getMcf());
            SubjectActions.addCredentials(this.subject, cred);
        }
        catch (Exception e) {
            log.debug((Object)"Failed to decode password", (Throwable)e);
            throw new LoginException("Failed to decode password: " + e.getMessage());
        }
        return true;
    }

    public boolean abort() {
        this.username = null;
        this.password = null;
        return true;
    }

    protected Principal getIdentity() {
        log.trace((Object)("getIdentity called, username=" + this.username));
        SimplePrincipal principal = new SimplePrincipal(this.username);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] empty = new Group[]{};
        return empty;
    }

    private static class DecodeAction
    implements PrivilegedExceptionAction {
        String password;
        ObjectName jaasSecurityDomain;
        MBeanServer server;

        DecodeAction(String password, ObjectName jaasSecurityDomain, MBeanServer server) {
            this.password = password;
            this.jaasSecurityDomain = jaasSecurityDomain;
            this.server = server;
        }

        public Object run() throws Exception {
            Object[] args = new Object[]{this.password};
            String[] sig = new String[]{String.class.getName()};
            byte[] secret = (byte[])this.server.invoke(this.jaasSecurityDomain, "decode64", args, sig);
            String secretPassword = new String(secret, "UTF-8");
            return secretPassword.toCharArray();
        }

        static char[] decode(String password, ObjectName jaasSecurityDomain, MBeanServer server) throws Exception {
            DecodeAction action = new DecodeAction(password, jaasSecurityDomain, server);
            try {
                char[] decode = (char[])AccessController.doPrivileged(action);
                return decode;
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
        }
    }
}

