/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classloader.spi.jdk;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.classloader.plugins.jdk.AbstractJDKChecker;
import org.jboss.classloader.spi.jdk.JDKChecker;

public class JDKCheckerFactory {
    private static final JDKChecker checker = AccessController.doPrivileged(new PrivilegedAction<JDKChecker>(){

        @Override
        public JDKChecker run() {
            String defaultChecker = AbstractJDKChecker.class.getName();
            String className = System.getProperty(JDKChecker.class.getName(), defaultChecker);
            try {
                Class<?> clazz;
                try {
                    clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException e) {
                    try {
                        clazz = this.getClass().getClassLoader().loadClass(className);
                    }
                    catch (ClassNotFoundException ignored) {
                        throw e;
                    }
                }
                Object result = clazz.newInstance();
                return (JDKChecker)JDKChecker.class.cast(result);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new Error("Unexpected error loading JDKChecker " + className, e);
            }
        }
    });

    public static JDKChecker getChecker() {
        return checker;
    }
}

